/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.validate;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import net.sf.saxon.Configuration;
import net.sf.saxon.Version;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.StreamWriterToReceiver;
import net.sf.saxon.lib.Invalidity;
import net.sf.saxon.lib.InvalidityReportGenerator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.DateTimeValue;

public class InvalidityReportGeneratorEE
extends InvalidityReportGenerator {
    private Destination destination = null;
    private int warningCount = 0;
    private int errorCount = 0;
    private String xsdversion = "1.0";
    private String systemId = null;
    private String schemaName = null;
    private Builder builder;
    private XMLStreamWriter writer;
    private boolean closed = false;
    boolean started = false;

    public InvalidityReportGeneratorEE(Configuration config) {
        super(config);
    }

    public InvalidityReportGeneratorEE(Configuration config, Destination destination) throws SaxonApiException {
        super(config);
        this.destination = destination;
        Receiver r = destination.getReceiver(config.makePipelineConfiguration(), config.obtainDefaultSerializationProperties());
        r = new NamespaceReducer(r);
        this.writer = new StreamWriterToReceiver(r);
    }

    public InvalidityReportGeneratorEE(Configuration config, Receiver receiver) throws XPathException {
        super(config);
        if (receiver instanceof Builder) {
            this.builder = (Builder)receiver;
        }
        NamespaceReducer r = new NamespaceReducer(receiver);
        this.writer = new StreamWriterToReceiver(r);
    }

    @Override
    public void setReceiver(Receiver receiver) {
        if (receiver instanceof Builder) {
            this.builder = (Builder)receiver;
        }
        NamespaceReducer r = new NamespaceReducer(receiver);
        this.writer = new StreamWriterToReceiver(r);
    }

    public void setDestination(Destination destination) throws SaxonApiException {
        this.destination = destination;
        Receiver r = destination.getReceiver(this.getConfiguration().makePipelineConfiguration(), this.getConfiguration().obtainDefaultSerializationProperties());
        r = new NamespaceReducer(r);
        this.writer = new StreamWriterToReceiver(r);
    }

    @Override
    public void setSystemId(String id) {
        this.systemId = id;
    }

    @Override
    public void setSchemaName(String name) {
        this.schemaName = name;
    }

    @Override
    public int getErrorCount() {
        return this.errorCount;
    }

    @Override
    public int getWarningCount() {
        return this.warningCount;
    }

    @Override
    public void setXsdVersion(String version) {
        this.xsdversion = version;
    }

    @Override
    public XMLStreamWriter getWriter() {
        return this.writer;
    }

    @Override
    public void reportInvalidity(Invalidity failure) throws XPathException {
        if (this.closed) {
            return;
        }
        ++this.errorCount;
        try {
            this.writer.writeStartElement("http://saxon.sf.net/ns/validation", "error");
            if (failure.getLineNumber() != -1) {
                this.writer.writeAttribute("line", String.valueOf(failure.getLineNumber()));
            }
            if (failure.getColumnNumber() > -1) {
                this.writer.writeAttribute("column", String.valueOf(failure.getColumnNumber()));
            }
            if (failure.getPath() != null) {
                this.writer.writeAttribute("path", failure.getPath().toString());
            }
            if (failure.getSystemId() != null && !failure.getSystemId().equals(this.systemId)) {
                this.writer.writeAttribute("system-id", failure.getSystemId());
            }
            if (failure.getSchemaPart() != -1) {
                this.writer.writeAttribute("xsd-part", String.valueOf(failure.getSchemaPart()));
            }
            if (failure.getConstraintName() != null) {
                this.writer.writeAttribute("constraint", failure.getConstraintReference());
            }
            if (failure.getContextPath() != null) {
                this.writer.writeAttribute("context-path", failure.getContextPath().toString());
            }
            this.writer.writeCharacters(failure.getMessage());
            this.writer.writeEndElement();
            if (failure instanceof ValidationFailure) {
                List<NodeInfo> offenders = ((ValidationFailure)failure).getOffendingNodes();
                for (NodeInfo node : offenders) {
                    this.writer.writeStartElement("http://saxon.sf.net/ns/validation", "contributing-node");
                    this.writer.writeAttribute("type", Type.displayTypeName(node));
                    if (node.getNodeKind() == 3 && node.getStringValue().length() < 200) {
                        this.writer.writeAttribute("content", node.getStringValue());
                    }
                    if (node.getLineNumber() != -1) {
                        this.writer.writeAttribute("line", String.valueOf(node.getLineNumber()));
                    }
                    if (node.getColumnNumber() > -1) {
                        this.writer.writeAttribute("column", String.valueOf(node.getColumnNumber()));
                    }
                    this.writer.writeAttribute("path", Navigator.getPath(node));
                    if (node.getSystemId() != null && !node.getSystemId().equals(this.systemId)) {
                        this.writer.writeAttribute("system-id", node.getSystemId());
                    }
                    this.writer.writeEndElement();
                }
            }
        }
        catch (XMLStreamException e) {
            throw new XPathException(e);
        }
    }

    public Destination getDestination() {
        return this.destination;
    }

    @Override
    public void startReporting(String systemId) throws XPathException {
        if (this.closed) {
            return;
        }
        this.systemId = systemId;
        if (systemId != null) {
            try {
                this.systemId = new URI(systemId).toString();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        if (!this.started) {
            try {
                this.started = true;
                this.writer.writeStartDocument();
                this.writer.setDefaultNamespace("http://saxon.sf.net/ns/validation");
                this.writer.writeStartElement("http://saxon.sf.net/ns/validation", "validation-report");
                if (this.systemId != null) {
                    this.writer.writeAttribute("system-id", this.systemId);
                }
            }
            catch (XMLStreamException e) {
                throw new XPathException(e);
            }
        }
    }

    @Override
    public Sequence<?> endReporting() throws XPathException {
        if (this.closed) {
            return null;
        }
        this.createMetaData();
        try {
            if (!this.started) {
                throw new IllegalStateException("Reporting not started");
            }
            this.writer.writeEndElement();
            this.writer.writeEndDocument();
            this.writer.close();
            this.closed = true;
        }
        catch (XMLStreamException e) {
            throw new XPathException(e);
        }
        if (this.builder != null) {
            return this.builder.getCurrentRoot();
        }
        return super.endReporting();
    }

    @Override
    public void createMetaData() throws XPathException {
        try {
            this.writer.writeStartElement("http://saxon.sf.net/ns/validation", "meta-data");
            this.writer.writeStartElement("http://saxon.sf.net/ns/validation", "validator");
            this.writer.writeAttribute("name", Version.getProductName() + "-" + this.getConfiguration().getEditionCode());
            this.writer.writeAttribute("version", Version.getProductVersion());
            this.writer.writeEndElement();
            this.writer.writeStartElement("http://saxon.sf.net/ns/validation", "results");
            this.writer.writeAttribute("errors", "" + this.errorCount);
            this.writer.writeAttribute("warnings", "" + this.warningCount);
            this.writer.writeEndElement();
            this.writer.writeStartElement("http://saxon.sf.net/ns/validation", "schema");
            if (this.schemaName != null) {
                this.writer.writeAttribute("file", this.schemaName);
            }
            this.writer.writeAttribute("xsd-version", this.xsdversion);
            this.writer.writeEndElement();
            this.writer.writeStartElement("http://saxon.sf.net/ns/validation", "run");
            this.writer.writeAttribute("at", DateTimeValue.getCurrentDateTime(null).getStringValue());
            this.writer.writeEndElement();
            this.writer.writeEndElement();
        }
        catch (XMLStreamException ex) {
            throw new XPathException(ex);
        }
    }
}

