/*
 * Decompiled with CFR 0.152.
 */
package chipmunk.segmenter;

import java.io.Serializable;
import java.util.List;
import marmot.core.Feature;
import marmot.util.DynamicWeights;
import marmot.util.Encoder;
import marmot.util.SymbolTable;

public abstract class IndexConsumer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private SymbolTable<Feature> feature_map_;
    protected DynamicWeights weights_;
    private boolean insert_;
    private int num_tags_bits_;
    private Encoder.State state_;

    public abstract void consume(int var1);

    public IndexConsumer(DynamicWeights weights, SymbolTable<Feature> feature_map, boolean insert, int num_tag_bits) {
        this.setWeights(weights);
        this.feature_map_ = feature_map;
        this.insert_ = insert;
        this.num_tags_bits_ = num_tag_bits;
        this.state_ = new Encoder.State();
    }

    public void consume(Encoder encoder, List<Integer> tags) {
        encoder.storeState(this.state_);
        for (int tag : tags) {
            encoder.append(tag, this.num_tags_bits_);
            int index = this.feature_map_.toIndex(encoder.getFeature(), -1, this.getInsert());
            this.consume(index);
            encoder.restoreState(this.state_);
        }
    }

    public void setWeights(DynamicWeights weights) {
        this.weights_ = weights;
    }

    public DynamicWeights getWeights() {
        return this.weights_;
    }

    public SymbolTable<Feature> getFeatureTable() {
        return this.feature_map_;
    }

    protected boolean getInsert() {
        return this.insert_;
    }

    public void setInsert(boolean insert) {
        this.insert_ = insert;
    }
}

