/*
 * Decompiled with CFR 0.152.
 */
package marmot.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import marmot.util.Lexicon;
import marmot.util.LineIterator;
import marmot.util.StringUtils;

public class HashLexicon
implements Lexicon {
    private static final long serialVersionUID = 1L;
    private transient Map<String, int[]> map_;
    private StringUtils.Mode mode_;

    public HashLexicon(StringUtils.Mode mode) {
        this.mode_ = mode;
        this.map_ = new HashMap<String, int[]>();
    }

    private static void checkUnigramLine(boolean condition, String unigram_file, List<String> line) {
        if (!condition) {
            throw new RuntimeException(String.format("Line in file %s should be of format <WORD> [<COUNT>], but is \"%s\"", unigram_file, line));
        }
    }

    public static HashLexicon readFromFile(String path, int min_count) {
        LineIterator iterator2 = new LineIterator(path);
        HashLexicon unigram_lexicon = new HashLexicon(StringUtils.Mode.lower);
        while (iterator2.hasNext()) {
            Object line = iterator2.next();
            if (line.isEmpty()) continue;
            HashLexicon.checkUnigramLine(line.size() == 1 || line.size() == 2, path, (List<String>)line);
            String word = (String)line.get(0);
            int count2 = 1;
            if (line.size() > 1) {
                try {
                    String count_string = (String)line.get(1);
                    count2 = Integer.parseInt(count_string);
                }
                catch (NumberFormatException e) {
                    HashLexicon.checkUnigramLine(false, path, (List<String>)line);
                }
            }
            if (count2 < min_count) continue;
            unigram_lexicon.addEntry(word, count2);
        }
        return unigram_lexicon;
    }

    public void addEntry(String word, Integer value) {
        String key = StringUtils.normalize(word, this.mode_);
        int[] current_value = this.map_.computeIfAbsent(key, k -> new int[ARRAY_LENGTH]);
        StringUtils.Shape shape = StringUtils.getShape(word);
        int n = shape.ordinal();
        current_value[n] = current_value[n] + value;
        int n2 = ARRAY_LENGTH - 1;
        current_value[n2] = current_value[n2] + value;
    }

    @Override
    public int[] getCount(String word) {
        String key = StringUtils.normalize(word, this.mode_);
        int[] value = this.map_.get(key);
        return value;
    }

    public int size() {
        return this.map_.size();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeInt(this.map_.size());
        for (Map.Entry<String, int[]> entry : this.map_.entrySet()) {
            String string = entry.getKey();
            oos.writeUTF(string);
            int[] counts = entry.getValue();
            int non_zeroes = 0;
            for (int count2 : counts) {
                if (count2 <= 0) continue;
                ++non_zeroes;
            }
            oos.writeShort(non_zeroes);
            for (int i = 0; i < counts.length; ++i) {
                int count3 = counts[i];
                if (count3 <= 0) continue;
                oos.writeShort(i);
                oos.writeShort(count3);
            }
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        int map_size = ois.readInt();
        this.map_ = new HashMap<String, int[]>(map_size);
        for (int number = 0; number < map_size; ++number) {
            String string = ois.readUTF();
            int[] counts = new int[Lexicon.ARRAY_LENGTH];
            int non_zeroes = ois.readShort();
            for (int non_zero = 0; non_zero < non_zeroes; ++non_zero) {
                short index = ois.readShort();
                short count2 = ois.readShort();
                counts[index] = count2;
            }
            this.map_.put(string, counts);
        }
    }

    public Map<String, int[]> getMap() {
        return this.map_;
    }
}

