/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.optim;

import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.stream.ContentDetector;
import com.saxonica.ee.stream.Inversion;
import com.saxonica.ee.stream.Posture;
import com.saxonica.ee.stream.PostureAndSweep;
import com.saxonica.ee.stream.StreamInstr;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.Sweep;
import com.saxonica.ee.stream.watch.StreamWatch;
import com.saxonica.ee.stream.watch.WatchManager;
import com.saxonica.ee.trans.ContextItemStaticInfoEE;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.event.SequenceNormalizerWithItemSeparator;
import net.sf.saxon.event.StartTagBuffer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.GlobalContextRequirement;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.parser.ExpressionAction;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.lib.StandardLogger;
import net.sf.saxon.om.MutableNodeInfo;
import net.sf.saxon.om.TreeModel;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.query.UpdateAgent;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.serialize.SerializationProperties;
import net.sf.saxon.trans.QuitParsingException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;

public class XQueryExpressionEE
extends XQueryExpression {
    private boolean allowDocumentProjection;
    private boolean isUpdating;
    private PathMap pathMap;
    private Inversion inversion;

    public XQueryExpressionEE(Expression exp, QueryModule mainModule, boolean streaming) throws XPathException {
        super(exp, mainModule, streaming);
        boolean isUpdatingExpression;
        Configuration config = mainModule.getConfiguration();
        if (config.isLicensedFeature(4)) {
            final PackageData pd = mainModule.getPackageData();
            ExpressionTool.processExpressionTree(this.expression, null, new ExpressionAction(){

                @Override
                public boolean process(Expression exp, Object result) throws XPathException {
                    Expression fallback;
                    if (exp instanceof StreamInstr && (fallback = ((StreamInstr)exp).prepareForStreaming(pd)) != exp) {
                        if (exp == XQueryExpressionEE.this.expression) {
                            XQueryExpressionEE.this.expression = fallback;
                        } else {
                            Expression parent = exp.getParentExpression();
                            for (Operand o : parent.operands()) {
                                if (o.getChildExpression() != exp) continue;
                                o.setChildExpression(fallback);
                            }
                        }
                        return true;
                    }
                    return false;
                }
            });
        }
        if (streaming && config.isLicensedFeature(4)) {
            ContextItemStaticInfoEE contextInfo;
            PostureAndSweep ps;
            if (!ExpressionTool.dependsOnFocus(exp)) {
                throw new XPathException("Streaming is not possible because the query does not use the context item");
            }
            Iterator<GlobalVariable> it = mainModule.getModuleVariables();
            while (it.hasNext()) {
                GlobalVariable gVar = it.next();
                if (gVar.getSelectExpression() == null || !ExpressionTool.dependsOnFocus(gVar.getSelectExpression())) continue;
                throw new XPathException("Streaming is not possible because a variable $" + gVar.getObjectName().getDisplayName() + " depends on the context item");
            }
            ArrayList<String> reasons = new ArrayList<String>();
            ItemType contextItemType = AnyItemType.getInstance();
            GlobalContextRequirement req = mainModule.getExecutable().getGlobalContextRequirement();
            if (req != null) {
                contextItemType = req.getRequiredItemType();
            }
            if ((ps = Streamability.getStreamability(this.expression, contextInfo = new ContextItemStaticInfoEE(contextItemType, false, Posture.STRIDING), reasons)).getPosture() == Posture.ROAMING || ps.getSweep() == Sweep.FREE_RANGING) {
                FastStringBuffer fsb = new FastStringBuffer(256);
                fsb.append("Streaming is not possible. ");
                for (String r : reasons) {
                    fsb.append(r);
                    fsb.append(". ");
                }
                throw new XPathException(fsb.toString(), "XTSE3430");
            }
            this.inversion = Inversion.invertExpression(this.expression, false);
        }
        boolean bl = isUpdatingExpression = mainModule.isUpdating() && this.expression.isUpdatingExpression();
        if (config.getConfigurationProperty(Feature.GENERATE_BYTE_CODE).booleanValue() && config.isLicensedFeature(4) && !streaming && !isUpdatingExpression) {
            Expression cexp;
            Optimizer optimizer = config.obtainOptimizer();
            if (config.getCountDown() == 0) {
                if (config.isTiming()) {
                    config.getStandardErrorOutput().println("Generating byte code...");
                }
                CompilerService compilerService = new CompilerService(config, 51);
                cexp = optimizer.compileToByteCode(compilerService, this.getExpression(), "main", 6);
            } else {
                optimizer.injectByteCodeCandidates(this.getExpression());
                cexp = optimizer.makeByteCodeCandidate(this, this.getExpression(), "main", 6);
            }
            if (cexp != null) {
                this.expression = cexp;
                ExpressionTool.copyLocationInfo(exp, this.expression);
            }
        }
        this.isUpdating = isUpdatingExpression;
    }

    @Override
    public boolean isUpdateQuery() {
        return this.isUpdating;
    }

    @Override
    public void setAllowDocumentProjection(boolean allowed) {
        this.allowDocumentProjection = allowed;
    }

    @Override
    public boolean isDocumentProjectionAllowed() {
        return this.allowDocumentProjection;
    }

    public PathMap getPathMap() {
        if (this.pathMap == null) {
            this.pathMap = new PathMap(this.expression);
        }
        for (PackageData pack : this.getExecutable().getPackages()) {
            for (GlobalVariable var : pack.getGlobalVariableList()) {
                Expression select;
                if (var.isUnused() || (select = var.getSelectExpression()) == null) continue;
                select.addToPathMap(this.pathMap, null);
            }
        }
        return this.pathMap;
    }

    @Override
    public Controller newController(DynamicQueryContext env) throws XPathException {
        Controller controller = new Controller(this.executable.getConfiguration(), this.executable);
        if (this.isUpdateQuery() && controller.getModel() == TreeModel.TINY_TREE) {
            controller.setModel(TreeModel.LINKED_TREE);
        }
        env.initializeController(controller);
        if (this.allowDocumentProjection) {
            controller.setUseDocumentProjection(this.getPathMap());
        }
        return controller;
    }

    @Override
    public Set<MutableNodeInfo> runUpdate(DynamicQueryContext dynamicEnv) throws XPathException {
        if (!this.isUpdating) {
            throw new XPathException("Calling runUpdate() on a non-updating query");
        }
        Configuration config = this.executable.getConfiguration();
        Controller controller = this.newController(dynamicEnv);
        XPathContextMajor context = this.initialContext(dynamicEnv, controller);
        try {
            PendingUpdateList pul = config.newPendingUpdateList();
            context.openStackFrame(this.stackFrameMap);
            this.expression.evaluatePendingUpdates(context, pul);
            pul.apply(context, this.mainModule.getRevalidationMode());
            Set<MutableNodeInfo> set = pul.getAffectedTrees();
            return set;
        }
        catch (XPathException e) {
            if (!e.hasBeenReported()) {
                controller.getErrorListener().fatalError(e);
            }
            throw e;
        }
        finally {
            if (controller.getTraceListener() != null) {
                controller.getTraceListener().close();
            }
        }
    }

    @Override
    public void runUpdate(DynamicQueryContext dynamicEnv, UpdateAgent agent) throws XPathException {
        if (!this.isUpdating) {
            throw new XPathException("Calling runUpdate() on a non-updating query");
        }
        Configuration config = this.executable.getConfiguration();
        Controller controller = this.newController(dynamicEnv);
        XPathContextMajor context = this.initialContext(dynamicEnv, controller);
        try {
            PendingUpdateList pul = config.newPendingUpdateList();
            context.openStackFrame(this.stackFrameMap);
            this.expression.evaluatePendingUpdates(context, pul);
            pul.apply(context, this.mainModule.getRevalidationMode());
            for (MutableNodeInfo mutableNodeInfo : pul.getAffectedTrees()) {
                agent.update(mutableNodeInfo, controller);
            }
        }
        catch (XPathException e) {
            if (!e.hasBeenReported()) {
                controller.getErrorListener().fatalError(e);
            }
            throw e;
        }
        finally {
            if (controller.getTraceListener() != null) {
                controller.getTraceListener().close();
            }
        }
    }

    @Override
    public void runStreamed(DynamicQueryContext dynamicEnv, Source source, Result result, Properties outputProperties) throws XPathException {
        if (this.inversion == null) {
            throw new XPathException("Query was not compiled for streaming");
        }
        Controller controller = this.newController(dynamicEnv);
        XPathContextMajor context = controller.newXPathContext();
        PipelineConfiguration pipe = controller.makePipelineConfiguration();
        pipe.setHostLanguage(51);
        SerializerFactory sf = context.getConfiguration().getSerializerFactory();
        Properties actualProperties = this.validateOutputProperties(controller, outputProperties);
        Receiver receiver = sf.getReceiver(result, new SerializationProperties(actualProperties), pipe);
        context.setReceiver(receiver);
        String itemSeparator = actualProperties.getProperty("item-separator");
        if (receiver instanceof ComplexContentOutputter && itemSeparator != null && !"#absent".equals(itemSeparator)) {
            receiver = new SequenceNormalizerWithItemSeparator(receiver, itemSeparator);
            context.setReceiver(receiver);
        }
        receiver.open();
        WatchManager wm = new WatchManager(pipe);
        wm.setXPathContext(context);
        StartTagBuffer stb = new StartTagBuffer(wm);
        wm.setStartTagBuffer(stb);
        StreamWatch streamWatch = new StreamWatch(this.inversion, wm, context);
        wm.addWatch(streamWatch, true);
        stb.setUnderlyingReceiver(wm);
        ContentDetector cd = new ContentDetector(stb);
        context.openStackFrame(this.stackFrameMap);
        boolean mustClose = result instanceof StreamResult && ((StreamResult)result).getOutputStream() == null;
        try {
            Sender.send(source, cd, controller.getConfiguration().getParseOptions());
        }
        catch (QuitParsingException quitParsingException) {
        }
        catch (XPathException err) {
            controller.reportFatalError(err);
            throw err;
        }
        finally {
            if (controller.getTraceListener() != null) {
                controller.getTraceListener().close();
            }
        }
        receiver.close();
        if (result instanceof StreamResult) {
            this.closeStreamIfNecessary((StreamResult)result, mustClose);
        }
    }

    @Override
    public void explainPathMap() {
        PathMap map = this.getPathMap();
        StandardLogger pw = new StandardLogger();
        pw.info("DOCUMENT PROJECTION: PATH MAP");
        map.diagnosticDump(pw);
    }
}

