/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.adjunct.TransmissionAdjunct;
import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.watch.WatchManager;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.AttributeCollectionImpl;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.AtomicValue;

public class WherePopulatedAdjunct
extends TransmissionAdjunct {
    @Override
    public Feed makeItemFeed(WatchManager watchManager, Feed out, XPathContext context) throws XPathException {
        return new WherePopulatedFeed(out, context);
    }

    private static class WherePopulatedReceiver
    extends ProxyReceiver {
        private int level = 0;
        private boolean pendingStartTag = false;
        private NodeName pendingElemName;
        private SchemaType pendingSchemaType;
        private Location pendingLocationId;
        private int pendingProperties;
        private AttributeCollectionImpl pendingAttributes;
        private List<NamespaceBindingSet> pendingNamespaceSets;

        public WherePopulatedReceiver(Receiver next) {
            super(next);
        }

        @Override
        public void startDocument(int properties) throws XPathException {
            if (this.level++ == 0) {
                this.pendingStartTag = true;
                this.pendingElemName = null;
                this.pendingProperties = properties;
            } else {
                super.startDocument(properties);
            }
        }

        @Override
        public void startElement(NodeName elemName, SchemaType typeCode, Location location, int properties) throws XPathException {
            this.releaseStartTag();
            if (this.level++ == 0) {
                this.pendingStartTag = true;
                this.pendingElemName = elemName;
                this.pendingSchemaType = typeCode;
                this.pendingLocationId = location.saveLocation();
                this.pendingProperties = properties;
                if (this.pendingAttributes == null) {
                    this.pendingAttributes = new AttributeCollectionImpl(this.getPipelineConfiguration().getConfiguration());
                } else {
                    this.pendingAttributes.clear();
                }
                if (this.pendingNamespaceSets == null) {
                    this.pendingNamespaceSets = new ArrayList<NamespaceBindingSet>(4);
                } else {
                    this.pendingNamespaceSets.clear();
                }
            } else {
                super.startElement(elemName, typeCode, location, properties);
            }
        }

        @Override
        public void attribute(NodeName nameCode, SimpleType typeCode, CharSequence value, Location locationId, int properties) throws XPathException {
            if (this.level == 1 && this.pendingStartTag) {
                this.pendingAttributes.addAttribute(nameCode, typeCode, value.toString(), locationId, properties);
            } else {
                super.attribute(nameCode, typeCode, value, locationId, properties);
            }
        }

        @Override
        public void namespace(NamespaceBindingSet namespaceBindings, int properties) throws XPathException {
            if (this.level == 1 && this.pendingStartTag) {
                this.pendingNamespaceSets.add(namespaceBindings);
            } else {
                super.namespace(namespaceBindings, properties);
            }
        }

        @Override
        public void startContent() throws XPathException {
            if (this.level != 1 || !this.pendingStartTag) {
                super.startContent();
            }
        }

        @Override
        public void endDocument() throws XPathException {
            if (--this.level == 0) {
                if (!this.pendingStartTag) {
                    super.endDocument();
                }
            } else {
                super.endDocument();
            }
            this.pendingStartTag = false;
        }

        @Override
        public void endElement() throws XPathException {
            if (--this.level == 0) {
                if (!this.pendingStartTag) {
                    super.endElement();
                }
            } else {
                super.endElement();
            }
            this.pendingStartTag = false;
        }

        public void releaseStartTag() throws XPathException {
            if (this.level == 1 && this.pendingStartTag) {
                if (this.pendingElemName == null) {
                    this.getNextReceiver().startDocument(this.pendingProperties);
                } else {
                    this.getNextReceiver().startElement(this.pendingElemName, this.pendingSchemaType, this.pendingLocationId, this.pendingProperties);
                    for (NamespaceBindingSet ns : this.pendingNamespaceSets) {
                        this.getNextReceiver().namespace(ns, 0);
                    }
                    for (int i = 0; i < this.pendingAttributes.getLength(); ++i) {
                        this.getNextReceiver().attribute(this.pendingAttributes.getNodeName(i), this.pendingAttributes.getTypeAnnotation(i), this.pendingAttributes.getValue(i), this.pendingAttributes.getLocation(i), this.pendingAttributes.getProperties(i));
                    }
                    this.getNextReceiver().startContent();
                }
                this.pendingStartTag = false;
            }
        }

        @Override
        public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
            if (this.level == 0 || chars.length() > 0) {
                this.releaseStartTag();
                super.characters(chars, locationId, properties);
            }
        }

        @Override
        public void append(Item item, Location locationId, int copyNamespaces) throws XPathException {
            if (this.level == 1 && this.pendingStartTag) {
                if (item instanceof NodeInfo) {
                    NodeInfo node = (NodeInfo)item;
                    if (node.getNodeKind() == 3 && node.getStringValueCS().length() == 0) {
                        return;
                    }
                    if (node.getNodeKind() == 2) {
                        this.pendingAttributes.addAttribute(NameOfNode.makeName(node), (SimpleType)node.getSchemaType(), node.getStringValue(), locationId, 0);
                        return;
                    }
                    if (node.getNodeKind() == 13) {
                        this.pendingNamespaceSets.add(new NamespaceBinding(node.getLocalPart(), node.getStringValue()));
                        return;
                    }
                }
                this.releaseStartTag();
            }
            super.append(item, locationId, copyNamespaces);
        }
    }

    private static class WherePopulatedFeed
    extends ItemFeed {
        private WherePopulatedReceiver receiver;

        public WherePopulatedFeed(Feed out, XPathContext context) {
            super(out, context);
        }

        @Override
        public void processItem(Item<?> item) throws XPathException {
            if (!this.isEmpty(item)) {
                if (this.receiver != null) {
                    this.receiver.releaseStartTag();
                }
                this.getResult().processItem(item);
            }
        }

        private boolean isEmpty(Item item) {
            if (item instanceof NodeInfo) {
                switch (((NodeInfo)item).getNodeKind()) {
                    case 1: 
                    case 9: {
                        return !((NodeInfo)item).hasChildNodes();
                    }
                }
                return item.getStringValueCS().length() == 0;
            }
            if (item instanceof AtomicValue) {
                return item.getStringValueCS().length() == 0;
            }
            if (item instanceof MapItem) {
                return ((MapItem)item).isEmpty();
            }
            if (item instanceof ArrayItem) {
                return ((ArrayItem)item).isEmpty();
            }
            return false;
        }

        @Override
        public SequenceReceiver getReceiver() {
            if (this.receiver == null) {
                this.receiver = new WherePopulatedReceiver(this.getResult().getReceiver());
            }
            return this.receiver;
        }
    }
}

