/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ApplyTemplatesCompiler;
import com.saxonica.ee.bytecode.ToPushCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.ContextOriginator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.CallTemplate;
import net.sf.saxon.expr.instruct.NamedTemplate;
import net.sf.saxon.expr.instruct.ParameterSet;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.TailCall;

public class CallTemplateCompiler
extends ToPushCompiler {
    @Override
    public void compileToPush(CompilerService compiler, Expression expression) throws CannotCompileException {
        CallTemplate call = (CallTemplate)expression;
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        CallTemplateCompiler.visitLineNumber(compiler, ga, expression);
        compiler.generateGetContext();
        ga.push(call.getBindingSlot());
        ga.invokeInstanceMethod(XPathContext.class, "getTargetComponent", Integer.TYPE);
        ga.dup();
        ga.invokeInstanceMethod(Component.class, "isHiddenAbstractComponent", new Class[0]);
        LabelInfo notAbstract = methodInfo.newLabel("notAbstract");
        ga.ifFalse(notAbstract);
        compiler.generateDynamicError("Cannot call an abstract template (" + call.getCalledTemplateName() + ") with no implementation", "XTDE3052", expression.getLocation(), false);
        ga.throwException();
        methodInfo.placeLabel(notAbstract);
        ga.dup();
        int targetComponentVar = methodInfo.allocateLocal(NamedTemplate.class);
        ga.storeLocal(targetComponentVar);
        ga.invokeInstanceMethod(Component.class, "getActor", new Class[0]);
        ga.checkClass(NamedTemplate.class);
        int templateVar = methodInfo.allocateLocal(NamedTemplate.class);
        ga.storeLocal(templateVar);
        if (call.usesTailRecursion()) {
            throw new CannotCompileException("tail recursive call-template", true);
        }
        compiler.generateGetContext();
        ga.invokeInstanceMethod(XPathContext.class, "newContext", new Class[0]);
        int context2Var = methodInfo.allocateLocal(XPathContextMajor.class);
        CallTemplateCompiler.visitAnnotation(compiler, "CallTemplateCompiler - newMajorContext");
        ga.storeLocal(context2Var);
        ga.loadLocal(context2Var);
        ga.loadLocal(targetComponentVar);
        ga.invokeInstanceMethod(XPathContextMajor.class, "setCurrentComponent", Component.class);
        ga.loadLocal(context2Var);
        ga.loadLocal(templateVar);
        ga.invokeInstanceMethod(NamedTemplate.class, "getStackFrameMap", new Class[0]);
        ga.invokeInstanceMethod(XPathContextMajor.class, "openStackFrame", SlotManager.class);
        ga.loadLocal(context2Var);
        ApplyTemplatesCompiler.compileParameterSet(compiler, this, call.getActualParams());
        ga.invokeInstanceMethod(XPathContextMajor.class, "setLocalParameters", ParameterSet.class);
        ga.loadLocal(context2Var);
        ApplyTemplatesCompiler.compileTunnelParameterSet(compiler, this, call.getTunnelParams());
        ga.invokeInstanceMethod(XPathContextMajor.class, "setTunnelParameters", ParameterSet.class);
        ga.loadLocal(context2Var);
        CallTemplateCompiler.allocateStatic(compiler, expression);
        ga.invokeInstanceMethod(XPathContextMajor.class, "setOrigin", ContextOriginator.class);
        ga.loadLocal(templateVar);
        ga.loadLocal(context2Var);
        ga.invokeInstanceMethod(NamedTemplate.class, "expand", XPathContext.class);
        LabelInfo callEnd = methodInfo.newLabel("callEnd");
        LabelInfo tailCallLoop = methodInfo.placeNewLabel("loop");
        ga.dup();
        ga.ifNull(callEnd.label());
        ga.invokeInstanceMethod(TailCall.class, "processLeavingTail", new Class[0]);
        ga.goTo(tailCallLoop);
        methodInfo.placeLabel(callEnd);
        ga.pop();
        methodInfo.releaseLocal(context2Var);
        methodInfo.releaseLocal(templateVar);
    }
}

