/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.feed;

import com.saxonica.ee.stream.feed.AbsorptionFeed;
import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.StringValueGatherer;
import com.saxonica.ee.stream.om.FleetingParentNode;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;

public class TypedValueFeed
extends AbsorptionFeed {
    public TypedValueFeed(Feed result, XPathContext context) {
        super(result, context);
    }

    @Override
    protected AbsorptionFeed.PendingItem makePendingItem(int sequenceNr, FleetingParentNode node) {
        return new PendingTypedValue(sequenceNr, node);
    }

    @Override
    protected Sequence<?> processGroundedItem(Item item) throws XPathException {
        if (item instanceof AtomicValue) {
            return item;
        }
        if (item instanceof NodeInfo) {
            return item.atomize();
        }
        if (item instanceof ArrayItem) {
            return item.atomize();
        }
        this.dynamicError(new XPathException("Cannot atomize item of type " + Type.displayTypeName(item), "FOTY0013"));
        return null;
    }

    private static class PendingTypedValue
    extends AbsorptionFeed.PendingItem {
        public FastStringBuffer buffer = new FastStringBuffer(100);
        public FleetingParentNode node;

        public PendingTypedValue(int sequence, FleetingParentNode node) {
            super(sequence);
            this.node = node;
        }

        @Override
        public Receiver getGatherer() {
            return new StringValueGatherer(this.buffer);
        }

        @Override
        public Sequence<?> deliver() throws XPathException {
            this.node.setStringValue(this.buffer);
            return this.node.atomize();
        }

        @Override
        public void rollback() {
            this.buffer.setLength(0);
        }
    }
}

