/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query.spans;

import de.ids_mannheim.korap.query.SpanDistanceQuery;
import de.ids_mannheim.korap.query.spans.CandidateSpan;
import de.ids_mannheim.korap.query.spans.OrderedDistanceSpans;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.util.Bits;

public class TokenDistanceSpans
extends OrderedDistanceSpans {
    public TokenDistanceSpans(SpanDistanceQuery query, LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts) throws IOException {
        super(query, context, acceptDocs, termContexts);
        this.hasMoreSpans = this.hasMoreFirstSpans;
    }

    @Override
    protected void setCandidateList() throws IOException {
        if (this.hasMoreSpans) {
            if (this.candidateListDocNum == this.secondSpans.doc()) {
                this.copyPossibleCandidates();
                this.addNewCandidates();
                this.candidateListIndex = -1;
            } else {
                this.candidateList.clear();
                if (this.hasMoreFirstSpans && this.ensureSameDoc(this.firstSpans, this.secondSpans)) {
                    this.candidateListDocNum = this.firstSpans.doc();
                    this.addNewCandidates();
                    this.candidateListIndex = -1;
                }
            }
        } else {
            this.candidateList.clear();
        }
    }

    private void copyPossibleCandidates() {
        ArrayList<CandidateSpan> temp = new ArrayList<CandidateSpan>();
        for (CandidateSpan cs : this.candidateList) {
            if (cs.getEnd() + this.maxDistance <= this.secondSpans.start()) continue;
            temp.add(cs);
        }
        this.candidateList = temp;
    }

    private void addNewCandidates() throws IOException {
        while (this.hasMoreFirstSpans && this.firstSpans.doc() == this.candidateListDocNum && this.firstSpans.start() < this.secondSpans.end()) {
            if (this.firstSpans.end() + this.maxDistance > this.secondSpans.start()) {
                this.candidateList.add(new CandidateSpan(this.firstSpans));
            }
            this.hasMoreFirstSpans = this.firstSpans.next();
        }
    }

    @Override
    protected boolean findMatch() throws IOException {
        CandidateSpan candidateSpan = (CandidateSpan)this.candidateList.get(this.candidateListIndex);
        if (this.minDistance == 0 && candidateSpan.getStart() < this.secondSpans.end() && this.secondSpans.start() < candidateSpan.getEnd()) {
            this.setMatchProperties(candidateSpan, true);
            return true;
        }
        int actualDistance = this.secondSpans.start() - candidateSpan.getEnd() + 1;
        if (candidateSpan.getStart() < this.secondSpans.start() && this.minDistance <= actualDistance && actualDistance <= this.maxDistance) {
            this.setMatchProperties(candidateSpan, false);
            return true;
        }
        return false;
    }

    @Override
    public long cost() {
        if (this.candidateList.size() > 0) {
            long cost = 0L;
            for (CandidateSpan candidateSpan : this.candidateList) {
                cost += candidateSpan.getCost();
            }
            return cost + this.secondSpans.cost();
        }
        return this.firstSpans.cost() + this.secondSpans.cost();
    }

    @Override
    protected boolean isSecondSpanValid() throws IOException {
        return true;
    }
}

