/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema.sdoc;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.PreparedSchema;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SingleNamespaceSchema;
import com.saxonica.ee.schema.sdoc.AnnotationParent;
import com.saxonica.ee.schema.sdoc.SchemaDocument;
import com.saxonica.ee.schema.sdoc.SchemaReader;
import com.saxonica.ee.schema.sdoc.XMLNamespaceSchema;
import com.saxonica.ee.schema.sdoc.XSDInclude;
import com.saxonica.ee.schema.sdoc.XSDSchema;
import com.saxonica.ee.schema.sdoc.XSINamespaceSchema;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Version;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.SchemaURIResolver;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaException;

public class XSDImport
extends AnnotationParent {
    private PreparedSchema importedSchema;

    @Override
    protected void prepareAttributes() throws SchemaException {
        int errors;
        AttributeMap atts = this.attributes();
        String[] allowed = new String[]{"id", "namespace", "schemaLocation"};
        this.allowAttributes(atts, allowed);
        this.processId();
        String schemaLocation = atts.getValue(NamespaceUri.NULL, "schemaLocation");
        String namespace = atts.getValue(NamespaceUri.NULL, "namespace");
        if (schemaLocation == null && namespace == null) {
            return;
        }
        NamespaceUri targetNamespace = NamespaceUri.of(namespace);
        XSDSchema thisSchemaDocument = this.getXSDSchema();
        EnterpriseConfiguration config = (EnterpriseConfiguration)this.getConfiguration();
        SchemaCompiler compiler = thisSchemaDocument.getSchemaCompiler();
        String documentBase = this.getBaseURI();
        if (schemaLocation != null) {
            try {
                String location = ResolveURI.makeAbsolute(schemaLocation, documentBase).toString();
                XSDSchema existing = compiler.getExistingSchemaDocument(location, targetNamespace);
                if (existing != null) {
                    this.importedSchema = existing.getSchema();
                    return;
                }
            }
            catch (URISyntaxException location) {
                // empty catch block
            }
        }
        if (targetNamespace.equals(NamespaceUri.XML) && (schemaLocation == null || schemaLocation.equals("http://www.w3.org/2001/xml.xsd") || schemaLocation.equals("http://www.w3.org/2001/03/xml.xsd"))) {
            if (config.getNamespaceStatus(targetNamespace) != 3) {
                this.importedSchema = XMLNamespaceSchema.buildSchema(config);
                config.addSchema(this.importedSchema);
            }
            return;
        }
        if (targetNamespace.equals(thisSchemaDocument.getTargetNamespace())) {
            this.error("The namespace attribute in the xs:import element cannot be the same as the targetNamespace of the containing schema");
            return;
        }
        Source source = null;
        if (schemaLocation != null) {
            try {
                source = SchemaReader.getSource(documentBase, schemaLocation, compiler, targetNamespace);
            }
            catch (SchemaException e) {
                this.processSchemaException(schemaLocation, namespace, e);
                return;
            }
        }
        if (source != null && compiler.isBeingRead(source.getSystemId())) {
            return;
        }
        int status = config.getNamespaceStatus(targetNamespace);
        if (status == 2) {
            if (source == null || !compiler.isBeingRead(source.getSystemId()) && !config.getBooleanProperty(Feature.MULTIPLE_SCHEMA_IMPORTS)) {
                if (schemaLocation != null) {
                    String message = "The schema document at " + schemaLocation + " is not being read because schema components for this namespace are already being processed";
                    if (!"http://www.w3.org/XML/1998/namespace".equals(namespace)) {
                        message = message + ". To force the schema document to be read, set --multipleSchemaImports:on";
                    }
                    this.warning(message);
                }
                return;
            }
        } else {
            if (status == 4) {
                return;
            }
            if (status == 3 && !config.getBooleanProperty(Feature.MULTIPLE_SCHEMA_IMPORTS)) {
                if (schemaLocation != null) {
                    String message = "The schema document at " + schemaLocation + " is not being read because schema components for this namespace are already available";
                    if (!targetNamespace.equals(NamespaceUri.XML)) {
                        message = message + ". To force the schema document to be read, set --multipleSchemaImports:on";
                    }
                    this.warning(message);
                }
                return;
            }
        }
        if (source == null && schemaLocation != null) {
            this.warning("Failed to locate imported schema document: " + schemaLocation);
            this.importedSchema = new SingleNamespaceSchema((EnterpriseConfiguration)this.getConfiguration(), targetNamespace);
            return;
        }
        if (schemaLocation == null) {
            if (namespace.equals("http://www.w3.org/2001/XMLSchema-instance")) {
                this.importedSchema = XSINamespaceSchema.buildSchema(config);
                config.addSchema(this.importedSchema);
                return;
            }
            if (targetNamespace.equals(NamespaceUri.FN)) {
                if (!config.isSchemaAvailable(NamespaceUri.FN)) {
                    ArrayList<String> messages = new ArrayList<String>();
                    InputStream in = Version.platform.locateResource("xpath-functions.xsd", messages);
                    if (config.isTiming()) {
                        config.getLogger().info("Loading schema from resources for: http://www.w3.org/2005/xpath-functions");
                    }
                    source = new StreamSource(in, "http://www.w3.org/2005/xpath-functions.scm");
                }
            } else {
                SchemaURIResolver resolver = compiler.getSchemaURIResolver();
                if (resolver != null) {
                    try {
                        Source[] sources = resolver.resolve(namespace, this.getBaseURI(), new String[0]);
                        if (sources == null || sources.length == 0) {
                            this.warning("Cannot locate a schema document for namespace " + namespace);
                            this.importedSchema = new SingleNamespaceSchema((EnterpriseConfiguration)this.getConfiguration(), targetNamespace);
                            return;
                        }
                        if (sources.length > 1) {
                            this.error("SchemaURIResolver returned more than one schema document");
                        } else {
                            source = sources[0];
                        }
                    }
                    catch (XPathException err) {
                        throw new SchemaException(err);
                    }
                }
            }
        }
        SchemaDocument importee = null;
        try {
            PipelineConfiguration pipe = this.getSchemaNodeFactory().getPipelineConfiguration();
            importee = SchemaReader.read(source, compiler, pipe, null);
            XSDSchema s = importee.getXSDSchema();
            errors = importee.getXSDSchema().getErrorCount();
            this.importedSchema = s.getSchema();
        }
        catch (SchemaException e) {
            this.processSchemaException(schemaLocation, namespace, e);
            return;
        }
        boolean valid = errors == 0;
        config.removeSchema(targetNamespace);
        if (!valid) {
            throw new SchemaException("Imported schema is invalid");
        }
        NamespaceUri importedNamespace = importee.getTargetNamespace();
        if (thisSchemaDocument.getTargetNamespace().equals(importedNamespace)) {
            this.error("The targetNamespace of the imported schema must not be the same as the targetNamespace of the importing schema");
            return;
        }
        if (!targetNamespace.equals(importedNamespace)) {
            this.error("The namespace attribute in xs:import differs from the targetNamespace of the imported schema");
            return;
        }
        config.addSchema(this.importedSchema);
    }

    private void processSchemaException(String schemaLocation, String namespace, SchemaException e) throws SchemaException {
        Throwable cause = e.getException();
        if (XSDInclude.isFileNotFoundException(cause)) {
            this.warning("Imported schema document " + schemaLocation + " cannot be located: " + cause.getClass().getName() + " (" + cause.getMessage() + ")");
        } else {
            this.error("Failed to process imported schema document: " + e.getMessage());
        }
        this.importedSchema = new SingleNamespaceSchema((EnterpriseConfiguration)this.getConfiguration(), this.getTargetNamespace());
    }

    public PreparedSchema getImportedSchema() {
        return this.importedSchema;
    }

    public NamespaceUri getTargetNamespace() {
        String uri = this.attributes().getValue(NamespaceUri.NULL, "namespace");
        if (uri == null) {
            return NamespaceUri.NULL;
        }
        return NamespaceUri.of(uri);
    }
}

