/*
 * Decompiled with CFR 0.152.
 */
package marmot.util;

import marmot.core.Feature;
import marmot.util.Encoder;

public class Decoder {
    private int[] bytes_;
    private short byte_index_;
    private short bit_index_;
    private short total_byte_length;
    private short total_bit_index;

    public Decoder(Feature feature) {
        this.bytes_ = feature.getBytes();
        this.total_bit_index = feature.getCurrentBitIndex();
        this.total_byte_length = (short)(feature.getCurrentLength() - 1);
    }

    int decode(int bits) {
        int read_now;
        if (this.byte_index_ > this.total_byte_length || this.bit_index_ > this.total_bit_index && this.byte_index_ == this.total_byte_length) {
            return -1;
        }
        int value = 0;
        for (int bits_read = 0; bits_read < bits; bits_read += read_now) {
            read_now = Math.min(32 - this.bit_index_, bits - bits_read);
            assert (read_now > 0);
            if (this.byte_index_ > this.total_byte_length) {
                return -1;
            }
            int byte_value = this.bytes_[this.byte_index_];
            int mask = (2 << read_now - 1) - 1;
            int new_value = (byte_value >>= this.bit_index_) & mask;
            value += (new_value <<= bits_read);
            this.bit_index_ = (short)(this.bit_index_ + read_now);
            if (this.bit_index_ <= this.total_bit_index || this.byte_index_ != this.total_byte_length) continue;
            return -1;
        }
        return value;
    }

    public static void main(String[] args) {
        Encoder encoder = new Encoder(3);
        encoder.append(0, 1);
        encoder.append(0, 2);
        encoder.append(8, 5);
        encoder.append(65, 7);
        encoder.append(20, 7);
        encoder.append(14, 7);
        encoder.append(6, 7);
        encoder.append(5, 7);
        encoder.append(3, 7);
        encoder.append(16, 7);
        encoder.append(6, 7);
        Feature f = encoder.getFeature();
        Decoder decoder = new Decoder(f);
        assert (0 == decoder.decode(1));
        assert (0 == decoder.decode(2));
        assert (8 == decoder.decode(5));
        assert (65 == decoder.decode(7));
        assert (20 == decoder.decode(7));
        assert (14 == decoder.decode(7));
        assert (6 == decoder.decode(7));
        assert (5 == decoder.decode(7));
        assert (3 == decoder.decode(7));
        assert (16 == decoder.decode(7));
        assert (6 == decoder.decode(7));
        assert (-1 == decoder.decode(1));
    }

    public short getByteLength() {
        return this.byte_index_;
    }

    public short getBitIndex() {
        return this.bit_index_;
    }

    public short getTotalByteLength() {
        return this.total_byte_length;
    }

    public short getTotalBitIndex() {
        return this.total_bit_index;
    }
}

