/*
 * Decompiled with CFR 0.152.
 */
package me.tongfei.progressbar;

import java.text.DecimalFormat;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.function.Function;
import me.tongfei.progressbar.DefaultProgressBarRenderer;
import me.tongfei.progressbar.ProgressBar;
import me.tongfei.progressbar.ProgressBarConsumer;
import me.tongfei.progressbar.ProgressBarRenderer;
import me.tongfei.progressbar.ProgressBarStyle;
import me.tongfei.progressbar.ProgressState;
import me.tongfei.progressbar.Util;

public class ProgressBarBuilder {
    private String task = "";
    private long initialMax = -1L;
    private int updateIntervalMillis = 1000;
    private boolean continuousUpdate = false;
    private ProgressBarStyle style = ProgressBarStyle.COLORFUL_UNICODE_BLOCK;
    private ProgressBarConsumer consumer = null;
    private boolean clearDisplayOnFinish = false;
    private String unitName = "";
    private long unitSize = 1L;
    private boolean showSpeed = false;
    private boolean hideEta = false;
    private Function<ProgressState, Optional<Duration>> eta = Util::linearEta;
    private DecimalFormat speedFormat;
    private ChronoUnit speedUnit = ChronoUnit.SECONDS;
    private long processed = 0L;
    private Duration elapsed = Duration.ZERO;
    private int maxRenderedLength = -1;
    private ProgressBarRenderer renderer = null;

    public ProgressBarBuilder setTaskName(String task) {
        this.task = task;
        return this;
    }

    boolean initialMaxIsSet() {
        return this.initialMax != -1L;
    }

    public ProgressBarBuilder setInitialMax(long initialMax) {
        this.initialMax = initialMax;
        return this;
    }

    public ProgressBarBuilder setStyle(ProgressBarStyle style) {
        this.style = style;
        return this;
    }

    public ProgressBarBuilder setUpdateIntervalMillis(int updateIntervalMillis) {
        this.updateIntervalMillis = updateIntervalMillis;
        return this;
    }

    public ProgressBarBuilder continuousUpdate() {
        this.continuousUpdate = true;
        return this;
    }

    public ProgressBarBuilder setConsumer(ProgressBarConsumer consumer) {
        this.consumer = consumer;
        return this;
    }

    public ProgressBarBuilder clearDisplayOnFinish() {
        this.clearDisplayOnFinish = true;
        return this;
    }

    public ProgressBarBuilder setUnit(String unitName, long unitSize) {
        this.unitName = unitName;
        this.unitSize = unitSize;
        return this;
    }

    public ProgressBarBuilder setMaxRenderedLength(int maxRenderedLength) {
        this.maxRenderedLength = maxRenderedLength;
        return this;
    }

    public ProgressBarBuilder setRenderer(ProgressBarRenderer renderer) {
        this.renderer = renderer;
        return this;
    }

    public ProgressBarBuilder showSpeed() {
        return this.showSpeed(new DecimalFormat("#.0"));
    }

    public ProgressBarBuilder showSpeed(DecimalFormat speedFormat) {
        this.showSpeed = true;
        this.speedFormat = speedFormat;
        return this;
    }

    public ProgressBarBuilder hideEta() {
        this.hideEta = true;
        return this;
    }

    public ProgressBarBuilder setEtaFunction(Function<ProgressState, Optional<Duration>> eta) {
        this.hideEta = false;
        this.eta = eta;
        return this;
    }

    public ProgressBarBuilder setSpeedUnit(ChronoUnit speedUnit) {
        this.speedUnit = speedUnit;
        return this;
    }

    public ProgressBarBuilder startsFrom(long processed, Duration elapsed) {
        this.processed = processed;
        this.elapsed = elapsed;
        return this;
    }

    public ProgressBar build() {
        return new ProgressBar(this.task, this.initialMax, this.updateIntervalMillis, this.continuousUpdate, this.clearDisplayOnFinish, this.processed, this.elapsed, this.renderer == null ? new DefaultProgressBarRenderer(this.style, this.unitName, this.unitSize, this.showSpeed, this.speedFormat, this.speedUnit, !this.hideEta, this.eta) : this.renderer, this.consumer == null ? Util.createConsoleConsumer(this.maxRenderedLength) : this.consumer);
    }
}

