/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query;

import de.ids_mannheim.korap.query.SimpleSpanQuery;
import de.ids_mannheim.korap.query.spans.ElementSpans;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.ToStringUtils;

public final class SpanElementQuery
extends SimpleSpanQuery {
    private static Term elementTerm;
    private String elementStr;

    public SpanElementQuery(String field, String term) {
        elementTerm = new Term(field, "<>:" + term);
        super(new SpanTermQuery(elementTerm), true);
        this.elementStr = term;
    }

    @Override
    public Spans getSpans(LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts) throws IOException {
        return new ElementSpans(this, context, acceptDocs, termContexts);
    }

    public String getElementStr() {
        return this.elementStr;
    }

    public void setElementStr(String elementStr) {
        this.elementStr = elementStr;
    }

    @Override
    public SimpleSpanQuery clone() {
        SpanElementQuery sq = new SpanElementQuery(this.getField(), this.getElementStr());
        sq.setBoost(this.getBoost());
        return sq;
    }

    @Override
    public void extractTerms(Set<Term> terms) {
        terms.add(elementTerm);
    }

    @Override
    public String toString(String field) {
        StringBuilder buffer = new StringBuilder("<");
        buffer.append(this.getField()).append(':').append(this.elementStr);
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.append(" />").toString();
    }

    @Override
    public int hashCode() {
        int prime = 37;
        int result = super.hashCode();
        result = 37 * result + (this.elementStr == null ? 0 : this.elementStr.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpanElementQuery other = (SpanElementQuery)obj;
        if (this.elementStr == null && other.elementStr != null) {
            return false;
        }
        if (!this.elementStr.equals(other.elementStr)) {
            return false;
        }
        return this.getField().equals(other.getField());
    }
}

