/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KrillProperties {
    public static final String DEFAULT_PROPERTIES_LOCATION = "krill.properties";
    public static final String DEFAULT_INFO_LOCATION = "krill.info";
    private static Properties prop;
    private static Properties info;
    public static int maxTokenMatchSize;
    public static int maxTokenContextSize;
    public static int maxCharContextSize;
    public static int leftContextAdjustment;
    public static int rightContextAdjustment;
    public static int defaultSearchContextLength;
    public static int maxTextSize;
    public static boolean matchExpansionIncludeContextSize;
    public static String namedVCPath;
    public static boolean isTest;
    public static String secret;
    private static final Logger log;

    public static Properties loadDefaultProperties() {
        if (prop != null) {
            return prop;
        }
        prop = KrillProperties.loadProperties(DEFAULT_PROPERTIES_LOCATION);
        return prop;
    }

    public static Properties loadProperties(String propFile) {
        if (propFile == null) {
            return KrillProperties.loadDefaultProperties();
        }
        try {
            FileInputStream iFile = new FileInputStream(propFile);
            prop = new Properties();
            prop.load(iFile);
        }
        catch (IOException t) {
            try {
                InputStream iFile = KrillProperties.class.getClassLoader().getResourceAsStream(propFile);
                if (iFile == null) {
                    log.warn("Cannot find {}. Please create it using \"src/main/resources/krill.properties.info\" as template.", (Object)propFile, (Object)propFile);
                    return null;
                }
                prop = new Properties();
                prop.load(iFile);
                iFile.close();
            }
            catch (IOException e) {
                log.error(e.getLocalizedMessage());
                return null;
            }
        }
        KrillProperties.updateConfigurations(prop);
        return prop;
    }

    public static void updateConfigurations(Properties prop) {
        String maxTokenMatchSize = prop.getProperty("krill.match.max.token");
        String maxTokenContextSize = prop.getProperty("krill.context.max.token");
        String leftContextAdjustment = prop.getProperty("krill.context.left.adjust");
        String rightContextAdjustment = prop.getProperty("krill.context.right.adjust");
        String defaultSearchContextLength = prop.getProperty("krill.search.context.default");
        String maxTextSizeValue = prop.getProperty("krill.index.textSize.max");
        try {
            if (maxTokenMatchSize != null) {
                KrillProperties.maxTokenMatchSize = Integer.parseInt(maxTokenMatchSize);
            }
            if (maxTokenContextSize != null) {
                KrillProperties.maxTokenContextSize = Integer.parseInt(maxTokenContextSize);
            }
            if (defaultSearchContextLength != null) {
                KrillProperties.defaultSearchContextLength = Integer.parseInt(defaultSearchContextLength);
            }
            if (maxTextSizeValue != null) {
                int userMaxTextLength = Integer.parseInt(maxTextSizeValue);
                if (userMaxTextLength < 20000000) {
                    log.warn("Specified krill.index.textSize.max is too small. Using default value: 20000000");
                    maxTextSize = 20000000;
                } else {
                    maxTextSize = userMaxTextLength;
                }
            }
            if (leftContextAdjustment != null) {
                if (leftContextAdjustment.equals("max")) {
                    KrillProperties.leftContextAdjustment = KrillProperties.maxTokenContextSize;
                } else {
                    KrillProperties.leftContextAdjustment = Integer.parseInt(leftContextAdjustment);
                    if (KrillProperties.leftContextAdjustment > KrillProperties.maxTokenContextSize) {
                        KrillProperties.leftContextAdjustment = KrillProperties.maxTokenContextSize;
                    } else if (KrillProperties.leftContextAdjustment < 0) {
                        KrillProperties.leftContextAdjustment = 0;
                    }
                }
            }
            if (rightContextAdjustment != null) {
                if (rightContextAdjustment.equals("max")) {
                    KrillProperties.rightContextAdjustment = KrillProperties.maxTokenContextSize;
                } else {
                    KrillProperties.rightContextAdjustment = Integer.parseInt(rightContextAdjustment);
                    if (KrillProperties.rightContextAdjustment > KrillProperties.maxTokenContextSize) {
                        KrillProperties.rightContextAdjustment = KrillProperties.maxTokenContextSize;
                    } else if (KrillProperties.rightContextAdjustment < 0) {
                        KrillProperties.rightContextAdjustment = 0;
                    }
                }
            }
        }
        catch (NumberFormatException e) {
            log.error("A Krill property expects numerical values: " + e.getMessage());
        }
        String p = prop.getProperty("krill.test", "false");
        isTest = Boolean.parseBoolean(p);
        namedVCPath = prop.getProperty("krill.namedVC", "");
        String matchExpansion = prop.getProperty("krill.match.expansion.includeContextSize", "false");
        matchExpansionIncludeContextSize = Boolean.parseBoolean(matchExpansion);
        secret = prop.getProperty("krill.secretB64", "");
    }

    public static Properties loadInfo() {
        try {
            info = new Properties();
            InputStream iFile = KrillProperties.class.getClassLoader().getResourceAsStream(DEFAULT_INFO_LOCATION);
            if (iFile == null) {
                log.error("Cannot find {}.", (Object)DEFAULT_INFO_LOCATION);
                return null;
            }
            info.load(iFile);
            iFile.close();
        }
        catch (IOException e) {
            log.error(e.getLocalizedMessage());
            return null;
        }
        return info;
    }

    public static void setProp(Properties prop) {
        KrillProperties.prop = prop;
    }

    static {
        maxTokenMatchSize = 50;
        maxTokenContextSize = 60;
        maxCharContextSize = 500;
        leftContextAdjustment = 0;
        rightContextAdjustment = 0;
        defaultSearchContextLength = 6;
        maxTextSize = 20000000;
        matchExpansionIncludeContextSize = false;
        namedVCPath = "";
        isTest = false;
        secret = "";
        log = LoggerFactory.getLogger(KrillProperties.class);
    }
}

