/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.qt4;

import java.math.BigInteger;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.Translate;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.str.Twine8;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.StringValue;

public class ParseInteger
extends SystemFunction {
    public static StringValue ignorables = new StringValue(new Twine8(new byte[]{9, 10, 13, 32, 95}));

    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        StringValue s = (StringValue)arguments[0].head();
        int radix = 10;
        if (arguments.length == 2) {
            IntegerValue r = (IntegerValue)arguments[1].head();
            if (r.compareTo(2L) < 0 || r.compareTo(36L) > 0) {
                throw new XPathException("Radix in parse-integer must be in range 2..36", "FORG0011");
            }
            radix = (int)r.longValue();
        }
        String val = Translate.translate(s, ignorables, StringValue.EMPTY_STRING).getStringValue();
        try {
            BigInteger x = new BigInteger(val, radix);
            return IntegerValue.makeIntegerValue(x);
        }
        catch (NumberFormatException e) {
            throw new XPathException("Cannot parse integer '" + s.getStringValue() + "'", "FORG0012");
        }
    }
}

