/*
 * Decompiled with CFR 0.152.
 */
package chipmunk.segmenter;

import chipmunk.segmenter.SegmentationReading;
import chipmunk.segmenter.SegmentationResult;
import chipmunk.segmenter.Segmenter;
import chipmunk.segmenter.Word;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import marmot.util.Numerics;

public class Scorer {
    Score precision = new Score();
    Score recall = new Score();

    private Set<Boundary> getBrackets(SegmentationReading reading, int length) {
        HashSet<Boundary> brackets = new HashSet<Boundary>();
        int start = 0;
        for (String segment : reading.getSegments()) {
            int end = start + segment.length();
            if (end < length) {
                brackets.add(new Boundary(end));
            }
            start = end;
        }
        return brackets;
    }

    private static Set<Boundary> getBoundary(SegmentationResult candidate, int length) {
        HashSet<Boundary> brackets = new HashSet<Boundary>();
        for (int end : candidate.getInputIndexes()) {
            if (end >= length) continue;
            brackets.add(new Boundary(end));
        }
        return brackets;
    }

    public void eval(List<Set<Boundary>> predicted, List<Set<Boundary>> reference) {
        this.eval(predicted, reference, this.recall);
        this.eval(reference, predicted, this.precision);
    }

    public void eval(Collection<Word> words, Segmenter segmenter) {
        for (Word word : words) {
            SegmentationReading reading = segmenter.segment(word);
            Set<Boundary> brackets = this.getBrackets(reading, word.getLength());
            List<Set<Boundary>> predicted = Collections.singletonList(brackets);
            LinkedList<Set<Boundary>> reference = new LinkedList<Set<Boundary>>();
            for (SegmentationReading ref_reading : word.getReadings()) {
                reference.add(this.getBrackets(ref_reading, word.getLength()));
            }
            this.eval(reference, predicted);
        }
    }

    public String report() {
        double p = this.getPrecision();
        double r = this.getRecall();
        double f = this.getFscore();
        return String.format("F1: %g Pr: %g / %g = %g Re:%g / %g = %g", f, this.precision.score, this.precision.total, p, this.recall.score, this.recall.total, r);
    }

    void eval(Collection<Set<Boundary>> predicted, Collection<Set<Boundary>> reference, Score s) {
        double max_score = 0.0;
        double max_total = -1.0;
        for (Set<Boundary> ref : reference) {
            double total = ref.size();
            for (Set<Boundary> pre : predicted) {
                Score m_tmp = new Score();
                this.eval_single(pre, ref, m_tmp);
                if (max_total != -1.0 && !(m_tmp.score > max_score)) continue;
                max_score = m_tmp.score;
                max_total = total;
            }
        }
        max_total = 1.0;
        s.total += max_total;
        s.score += max_score;
    }

    private void eval_single(Set<Boundary> pre, Set<Boundary> ref, Score s) {
        int total = ref.size();
        if (total == 0) {
            s.score = 1.0;
            s.total = 0.0;
            return;
        }
        HashSet<Boundary> intersect = new HashSet<Boundary>(pre);
        intersect.retainAll(ref);
        s.score = (double)intersect.size() / (double)total;
        s.total = total;
    }

    public double getFscore() {
        double r;
        double p = this.getPrecision();
        if (Numerics.approximatelyLesserEqual(p + (r = this.getRecall()), 0.0)) {
            return 0.0;
        }
        double f = 2.0 * p * r / (p + r);
        return f;
    }

    private double getRecall() {
        return 100.0 * this.recall.score / this.recall.total;
    }

    private double getPrecision() {
        return 100.0 * this.precision.score / this.precision.total;
    }

    public static SegmentationResult closest(SegmentationResult result, Collection<SegmentationResult> results, int length) {
        double best_score = Double.NEGATIVE_INFINITY;
        SegmentationResult best_result = null;
        Set<Boundary> brackets = Scorer.getBoundary(result, length);
        for (SegmentationResult candidate : results) {
            Set<Boundary> other = Scorer.getBoundary(candidate, length);
            Scorer scorer = new Scorer();
            scorer.eval(Collections.singletonList(brackets), Collections.singletonList(other));
            double score = scorer.getFscore();
            assert (!Double.isNaN(score));
            assert (!Double.isInfinite(score));
            if (!(score > best_score)) continue;
            best_result = candidate;
            best_score = score;
        }
        return best_result;
    }

    private static class Score {
        double score;
        double total;

        private Score() {
        }
    }

    private static class Boundary {
        int position_;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.position_;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Boundary other = (Boundary)obj;
            return this.position_ == other.position_;
        }

        public Boundary(int position) {
            this.position_ = position;
        }
    }
}

