/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.serialize;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.serialize.XMLEmitter;
import net.sf.saxon.serialize.XMLIndenter;
import net.sf.saxon.value.Whitespace;

public class XMLIndenterPE
extends XMLIndenter {
    private int indentSpaces = 3;
    private int lineLength = 80;
    private Set<NodeName> doubleSpacedElements = null;

    public XMLIndenterPE(XMLEmitter next) {
        super(next);
    }

    @Override
    public void setOutputProperties(Properties props) {
        super.setOutputProperties(props);
        String s = props.getProperty("{http://saxon.sf.net/}indent-spaces");
        if (s == null) {
            this.indentSpaces = 3;
        } else {
            try {
                this.indentSpaces = Integer.parseInt(Whitespace.trim(s));
            }
            catch (NumberFormatException err) {
                this.indentSpaces = 3;
            }
        }
        s = props.getProperty("{http://saxon.sf.net/}line-length");
        if (s != null) {
            try {
                this.lineLength = Integer.parseInt(Whitespace.trim(s));
            }
            catch (NumberFormatException err) {
                this.lineLength = 80;
            }
        }
        if ((s = props.getProperty("{http://saxon.sf.net/}double-space")) != null) {
            this.doubleSpacedElements = new HashSet<NodeName>(8);
            StringTokenizer st = new StringTokenizer(s, " \t\r\n");
            while (st.hasMoreTokens()) {
                String clarkName = st.nextToken();
                this.doubleSpacedElements.add(FingerprintedQName.fromClarkName(clarkName));
            }
        }
    }

    @Override
    protected boolean isDoubleSpaced(NodeName name) {
        return this.doubleSpacedElements != null && this.doubleSpacedElements.contains(name);
    }

    @Override
    protected int getIndentation() {
        return this.indentSpaces;
    }

    @Override
    protected int getLineLength() {
        return this.lineLength;
    }
}

