/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korapxmltools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0003H\u0086@\u00a2\u0006\u0002\u0010\u0014J\u000e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0003J\u0014\u0010\u0015\u001a\u00020\u00112\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u0018J\u0006\u0010\u0019\u001a\u00020\u0011J\b\u0010\u001a\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lde/ids_mannheim/korapxmltools/AnnotationWorkerPool;", "", "command", "", "numWorkers", "", "LOGGER", "Ljava/util/logging/Logger;", "<init>", "(Ljava/lang/String;ILjava/util/logging/Logger;)V", "queue", "Ljava/util/concurrent/BlockingQueue;", "threads", "", "Ljava/lang/Thread;", "threadCount", "openWorkerPool", "", "printOutput", "output", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "pushToQueue", "text", "texts", "", "close", "waitForWorkersToFinish", "app"})
@SourceDebugExtension(value={"SMAP\nAnnotationWorkerPool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotationWorkerPool.kt\nde/ids_mannheim/korapxmltools/AnnotationWorkerPool\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,190:1\n1863#2,2:191\n1863#2,2:193\n*S KotlinDebug\n*F\n+ 1 AnnotationWorkerPool.kt\nde/ids_mannheim/korapxmltools/AnnotationWorkerPool\n*L\n144#1:191,2\n173#1:193,2\n*E\n"})
public final class AnnotationWorkerPool {
    @NotNull
    private final String command;
    private final int numWorkers;
    @NotNull
    private final Logger LOGGER;
    @NotNull
    private final BlockingQueue<String> queue;
    @NotNull
    private final List<Thread> threads;
    private int threadCount;

    public AnnotationWorkerPool(@NotNull String command2, int numWorkers, @NotNull Logger LOGGER) {
        Intrinsics.checkNotNullParameter(command2, "command");
        Intrinsics.checkNotNullParameter(LOGGER, "LOGGER");
        this.command = command2;
        this.numWorkers = numWorkers;
        this.LOGGER = LOGGER;
        this.queue = new LinkedBlockingQueue();
        this.threads = new ArrayList();
        this.openWorkerPool();
        this.LOGGER.info("Annotation worker pool with " + this.numWorkers + " threads opened");
    }

    private final void openWorkerPool() {
        int n = this.numWorkers;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            new Thread(() -> AnnotationWorkerPool.openWorkerPool$lambda$1$lambda$0(this, it)).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Object printOutput(@NotNull String output, @NotNull Continuation<? super Unit> $completion) {
        PrintStream printStream = System.out;
        Intrinsics.checkNotNullExpressionValue(printStream, "out");
        PrintStream printStream2 = printStream;
        synchronized (printStream2) {
            boolean bl = false;
            try {
                byte[] byArray = output.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
                System.out.write(byArray);
            }
            catch (IOException e) {
                this.LOGGER.severe("Failed to write to stdout: " + e.getMessage());
            }
            Unit unit = Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    public final void pushToQueue(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        this.queue.offer(text);
    }

    public final void pushToQueue(@NotNull List<String> texts) {
        Intrinsics.checkNotNullParameter(texts, "texts");
        Iterable $this$forEach$iv = texts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.queue.offer(it);
        }
        int n = this.queue.remainingCapacity();
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            this.queue.offer("#eof");
        }
    }

    public final void close() {
        int n = this.threadCount;
        this.LOGGER.info("Closing worker pool with " + n + " threads");
        while (n > 0) {
            if (this.queue.offer("#eof")) {
                --n;
                continue;
            }
            this.LOGGER.info("Queue is full, waiting for workers to process");
            Thread.sleep(100L);
        }
        if (this.threadCount > 0) {
            this.waitForWorkersToFinish();
        }
    }

    private final void waitForWorkersToFinish() {
        while (!((Collection)this.queue).isEmpty()) {
            Thread.sleep(100L);
        }
        this.LOGGER.info("Queue is empty, waiting for workers to finish");
        Iterable $this$forEach$iv = this.threads;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Thread p0 = (Thread)element$iv;
            boolean bl = false;
            p0.join();
        }
        this.LOGGER.info("All workers finished");
    }

    private static final void openWorkerPool$lambda$1$lambda$0(AnnotationWorkerPool this$0, int $it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        try {
            List<Thread> list = this$0.threads;
            Thread thread2 = Thread.currentThread();
            Intrinsics.checkNotNullExpressionValue(thread2, "currentThread(...)");
            list.add(thread2);
            int n = this$0.threadCount;
            this$0.threadCount = n + 1;
            Object object = new String[]{"/bin/sh", "-c", this$0.command};
            Process process = new ProcessBuilder((String)object).redirectOutput(ProcessBuilder.Redirect.PIPE).redirectInput(ProcessBuilder.Redirect.PIPE).redirectError(ProcessBuilder.Redirect.INHERIT).start();
            if (process.getOutputStream() == null) {
                this$0.LOGGER.severe("Worker " + $it + " failed to open pipe '" + this$0.command + "'");
                return;
            }
            OutputStream outputStream = process.getOutputStream();
            Intrinsics.checkNotNullExpressionValue(outputStream, "getOutputStream(...)");
            object = outputStream;
            int n2 = 10000000;
            BufferedOutputStream bufferedOutputStream = object instanceof BufferedOutputStream ? (BufferedOutputStream)object : new BufferedOutputStream((OutputStream)object, n2);
            InputStream inputStream = process.getInputStream();
            Intrinsics.checkNotNullExpressionValue(inputStream, "getInputStream(...)");
            object = inputStream;
            n2 = 10000000;
            BufferedInputStream bufferedInputStream = object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n2);
            CoroutineScope coroutineScope = CoroutineScopeKt.CoroutineScope(Dispatchers.getIO());
            Ref.BooleanRef inputGotEof = new Ref.BooleanRef();
            Ref.IntRef readBytes = new Ref.IntRef();
            Ref.IntRef writtenBytes = new Ref.IntRef();
            BuildersKt.launch$default(coroutineScope, null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(process, this$0, $it, writtenBytes, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ Process $process;
                final /* synthetic */ AnnotationWorkerPool this$0;
                final /* synthetic */ int $it;
                final /* synthetic */ Ref.IntRef $writtenBytes;
                {
                    this.$process = $process;
                    this.this$0 = $receiver;
                    this.$it = $it;
                    this.$writtenBytes = $writtenBytes;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(object);
                            CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(this.$process.getOutputStream());
                            while (true) {
                                String text;
                                if (Intrinsics.areEqual(text = (String)AnnotationWorkerPool.access$getQueue$p(this.this$0).poll(5L, TimeUnit.SECONDS), "#eof") || text == null) break;
                                try {
                                    outputStreamWriter.write(text + "\n# eot\n");
                                    outputStreamWriter.flush();
                                    this.$writtenBytes.element += text.length();
                                }
                                catch (IOException e) {
                                    AnnotationWorkerPool.access$getLOGGER$p(this.this$0).severe("Worker " + this.$it + " failed to write to process: " + e.getMessage());
                                    AnnotationWorkerPool.access$getThreads$p(this.this$0).remove(Thread.currentThread());
                                    int n = AnnotationWorkerPool.access$getThreadCount$p(this.this$0);
                                    AnnotationWorkerPool.access$setThreadCount$p(this.this$0, n + -1);
                                    CoroutineScopeKt.cancel$default($this$launch, null, 1, null);
                                }
                            }
                            outputStreamWriter.write("\n# eof\n");
                            outputStreamWriter.close();
                            AnnotationWorkerPool.access$getLOGGER$p(this.this$0).info("Worker " + this.$it + " received eof");
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return var3_3;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 3, null);
            BuildersKt.launch$default(coroutineScope, null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(inputGotEof, process, this$0, $it, readBytes, null){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                int I$0;
                int label;
                final /* synthetic */ Ref.BooleanRef $inputGotEof;
                final /* synthetic */ Process $process;
                final /* synthetic */ AnnotationWorkerPool this$0;
                final /* synthetic */ int $it;
                final /* synthetic */ Ref.IntRef $readBytes;
                {
                    this.$inputGotEof = $inputGotEof;
                    this.$process = $process;
                    this.this$0 = $receiver;
                    this.$it = $it;
                    this.$readBytes = $readBytes;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public final Object invokeSuspend(Object var1_1) {
                    block19: {
                        var24_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        block4 : switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure(var1_1);
                                output = new StringBuilder();
                                break;
                            }
                            case 1: {
                                $i$f$useLines = false;
                                $i$a$-use-TextStreamsKt$useLines$2$iv = false;
                                $i$a$-useLines-AnnotationWorkerPool$openWorkerPool$1$1$2$1 = false;
                                $i$f$forEach = false;
                                $i$a$-forEach-AnnotationWorkerPool$openWorkerPool$1$1$2$1$1 = false;
                                var7_9 = this.I$0;
                                var18_23 = (Iterator<String>)this.L$6;
                                var11_13 = null;
                                var10_12 = (Closeable)this.L$5;
                                var8_10 = (Ref.IntRef)this.L$4;
                                var6_7 = (Process)this.L$3;
                                var5_6 = (Ref.BooleanRef)this.L$2;
                                var4_5 = (AnnotationWorkerPool)this.L$1;
                                output = (StringBuilder)this.L$0;
                                ResultKt.throwOnFailure($result);
                                v0 = $result;
                                while (true) {
                                    StringsKt.clear(output);
                                    break block19;
                                    break;
                                }
                            }
                            case 2: {
                                $i$f$useLines = false;
                                $i$a$-use-TextStreamsKt$useLines$2$iv = false;
                                $i$a$-useLines-AnnotationWorkerPool$openWorkerPool$1$1$2$1 = false;
                                var7_9 = this.I$0;
                                var11_13 = null;
                                var10_12 = (Closeable)this.L$4;
                                var6_7 = (Process)this.L$3;
                                var5_6 = (Ref.BooleanRef)this.L$2;
                                var4_5 = (AnnotationWorkerPool)this.L$1;
                                output = (StringBuilder)this.L$0;
                                ResultKt.throwOnFailure($result);
                                v1 = $result;
lbl45:
                                // 2 sources

                                while (true) {
                                    StringsKt.clear(output);
                                    if (!var5_6.element && var6_7.isAlive()) {
                                        AnnotationWorkerPool.access$getLOGGER$p((AnnotationWorkerPool)var4_5).info("Worker " + var7_9 + " waiting for more output");
                                        Thread.sleep(10L);
                                    }
                                    var12_15 = Unit.INSTANCE;
                                    break block4;
                                    break;
                                }
                            }
                            default: {
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }
                        }
lbl56:
                        // 3 sources

                        while (true) {
                            if (this.$inputGotEof.element != false) return Unit.INSTANCE;
                            if (this.$process.isAlive() == false) return Unit.INSTANCE;
                            Intrinsics.checkNotNullExpressionValue(this.$process.getInputStream(), "getInputStream(...)");
                            var4_5 = Charsets.UTF_8;
                            var5_6 = new InputStreamReader(var3_4, (Charset)var4_5);
                            var6_8 = 8192;
                            $this$useLines$iv = var5_6 instanceof BufferedReader != false ? (BufferedReader)var5_6 : new BufferedReader((Reader)var5_6, var6_8);
                            var4_5 = this.this$0;
                            var5_6 = this.$inputGotEof;
                            var6_7 = this.$process;
                            var7_9 = this.$it;
                            var8_10 = this.$readBytes;
                            $i$f$useLines = false;
                            var10_12 = $this$useLines$iv;
                            var11_14 = 8192;
                            var10_12 = var10_12 instanceof BufferedReader != false ? (BufferedReader)var10_12 : new BufferedReader((Reader)var10_12, var11_14);
                            var11_13 = null;
                            try {
                                it$iv = (BufferedReader)var10_12;
                                $i$a$-use-TextStreamsKt$useLines$2$iv = false;
                                lines = TextStreamsKt.lineSequence(it$iv);
                                $i$a$-useLines-AnnotationWorkerPool$openWorkerPool$1$1$2$1 = false;
                                $this$forEach$iv = lines;
                                $i$f$forEach = false;
                                var18_23 = $this$forEach$iv.iterator();
                                break block19;
                            }
                            catch (Throwable var12_16) {
                                var11_13 = var12_16;
                                throw var12_16;
                            }
                            catch (Throwable var12_17) {
                                throw var12_17;
                            }
                            break;
                        }
                        finally {
                            CloseableKt.closeFinally(var10_12, var11_13);
                            ** continue;
                        }
                    }
                    while (var18_23.hasNext()) {
                        element$iv = var18_23.next();
                        line = (String)element$iv;
                        $i$a$-forEach-AnnotationWorkerPool$openWorkerPool$1$1$2$1$1 = false;
                        var22_27 = line;
                        if (Intrinsics.areEqual(var22_27, "# eof")) {
                            AnnotationWorkerPool.access$getLOGGER$p((AnnotationWorkerPool)var4_5).info("Worker " + var7_9 + " got EOF in output");
                            var5_6.element = true;
                            continue;
                        }
                        if (Intrinsics.areEqual(var22_27, "# eot")) {
                            v2 = output.toString();
                            Intrinsics.checkNotNullExpressionValue(v2, "toString(...)");
                            this.L$0 = output;
                            this.L$1 = var4_5;
                            this.L$2 = var5_6;
                            this.L$3 = var6_7;
                            this.L$4 = var8_10;
                            this.L$5 = var10_12;
                            this.L$6 = var18_23;
                            this.I$0 = var7_9;
                            this.label = 1;
                            if ((v0 = var4_5.printOutput(v2, this)) != var24_2) ** continue;
                            return var24_2;
                        }
                        var23_28 = new String[]{line, "\n"};
                        StringsKt.append(output, var23_28);
                        var8_10.element += line.length() + 1;
                    }
                    v3 = output.toString();
                    Intrinsics.checkNotNullExpressionValue(v3, "toString(...)");
                    this.L$0 = output;
                    this.L$1 = var4_5;
                    this.L$2 = var5_6;
                    this.L$3 = var6_7;
                    this.L$4 = var10_12;
                    this.L$5 = null;
                    this.L$6 = null;
                    this.I$0 = var7_9;
                    this.label = 2;
                    ** while ((v1 = var4_5.printOutput((String)v3, (Continuation<? super Unit>)this)) != var24_2)
lbl135:
                    // 1 sources

                    return var24_2;
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 3, null);
            process.waitFor();
            this$0.LOGGER.info("Worker " + $it + " finished");
        }
        catch (IOException e) {
            e.printStackTrace();
            this$0.LOGGER.warning("Worker " + $it + " failed: " + e.getMessage());
            this$0.threads.remove(Thread.currentThread());
            int n = this$0.threadCount;
            this$0.threadCount = n + -1;
        }
    }

    public static final /* synthetic */ BlockingQueue access$getQueue$p(AnnotationWorkerPool $this) {
        return $this.queue;
    }

    public static final /* synthetic */ Logger access$getLOGGER$p(AnnotationWorkerPool $this) {
        return $this.LOGGER;
    }

    public static final /* synthetic */ List access$getThreads$p(AnnotationWorkerPool $this) {
        return $this.threads;
    }

    public static final /* synthetic */ int access$getThreadCount$p(AnnotationWorkerPool $this) {
        return $this.threadCount;
    }

    public static final /* synthetic */ void access$setThreadCount$p(AnnotationWorkerPool $this, int n) {
        $this.threadCount = n;
    }
}

