/*
 * Decompiled with CFR 0.152.
 */
package marmot.test.morph;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import junit.framework.AssertionFailedError;
import marmot.core.Model;
import marmot.core.PerceptronTrainer;
import marmot.core.Sequence;
import marmot.core.Tagger;
import marmot.core.Token;
import marmot.morph.MorphEvaluator;
import marmot.morph.MorphModel;
import marmot.morph.MorphOptions;
import marmot.morph.MorphResult;
import marmot.morph.Sentence;
import marmot.morph.Word;
import marmot.morph.io.SentenceReader;
import marmot.util.Copy;
import marmot.util.FileUtils;
import marmot.util.StringUtils;
import org.junit.Test;

public class PipelineTest {
    private String getResourceFile(String name) {
        Package pack = this.getClass().getPackage();
        String path = pack.getName().replace(".", "/");
        return String.format("res:///%s/%s", path, name);
    }

    public static List<Sequence> getSentences(String filename, int number) {
        LinkedList<Sequence> list = new LinkedList<Sequence>();
        for (Sequence sentence : new SentenceReader(filename)) {
            list.add(sentence);
            if (number < 0 || list.size() < number) continue;
            break;
        }
        return list;
    }

    public List<Sequence> getTrainSentences() {
        LinkedList<Sequence> sentences = new LinkedList<Sequence>();
        LinkedList<Word> tokens = new LinkedList<Word>();
        tokens.add(new Word("das", "A", "c=N|n=S"));
        tokens.add(new Word("ist", "V", "n=S"));
        tokens.add(new Word("ein", "A", "c=N|n=S"));
        tokens.add(new Word("Test", "N", "c=N|n=S"));
        tokens.add(new Word(".", ".", "_"));
        sentences.add(new Sentence(tokens));
        tokens = new LinkedList();
        tokens.add(new Word("die", "A", "c=N|n=P"));
        tokens.add(new Word("R\u00fcben", "N", "c=N|n=P"));
        tokens.add(new Word("sind", "V", "n=P"));
        tokens.add(new Word("kalt", "J", "c=N|n=P"));
        tokens.add(new Word(".", ".", "_"));
        sentences.add(new Sentence(tokens));
        return sentences;
    }

    public List<Sequence> getTestSentences() {
        LinkedList<Word> tokens = new LinkedList<Word>();
        tokens.add(new Word("das", "A", "c=N|n=S"));
        tokens.add(new Word("ist", "V", "n=S"));
        tokens.add(new Word("mein", "A", "c=N|n=S"));
        tokens.add(new Word("Test", "N", "c=N|n=S"));
        tokens.add(new Word(".", ".", "_"));
        return Collections.singletonList(new Sentence(tokens));
    }

    public Model getModel(Collection<Sequence> sentences, MorphOptions options) {
        MorphModel model = new MorphModel();
        model.init(options, sentences);
        return model;
    }

    @Test
    public void toyPosTest() {
        MorphOptions options = new MorphOptions();
        options.setProperty("seed", "42");
        options.setProperty("num-iterations", "10");
        options.setProperty("initial-vector-size", "1024");
        options.setProperty("candidates-per-state", "[9, 9, 9]");
        options.setProperty("prune", "false");
        this.toyTestWithOptions(options);
        options.setProperty("prune", "true");
        options.setProperty("tag-morph", "false");
        this.toyTestWithOptions(options);
        options.setProperty("candidates-per-state", "[4, 2, 1.5, 1.25]");
        this.toyTestWithOptions(options);
    }

    @Test
    public void toyTest() {
        MorphOptions options = new MorphOptions();
        options.setProperty("seed", "42");
        options.setProperty("num-iterations", "10");
        options.setProperty("initial-vector-size", "1024");
        options.setProperty("candidates-per-state", "[9, 9, 9]");
        options.setProperty("prune", "false");
        this.toyTestWithOptions(options);
        options.setProperty("prune", "true");
        this.toyTestWithOptions(options);
        options.setProperty("candidates-per-state", "[4, 2, 1.5, 1.25]");
        this.toyTestWithOptions(options);
    }

    @Test
    public void realTest() {
        MorphOptions options = new MorphOptions();
        options.setProperty("seed", "42");
        options.setProperty("num-iterations", "10");
        options.setProperty("initial-vector-size", "10000000");
        options.setProperty("candidates-per-state", "[4, 2, 1.5, 1.25]");
        options.setProperty("prune", "true");
        options.setProperty("order", "3");
        options.setProperty("penalty", ".1");
        options.setProperty("use-hash-feature-table", "false");
        options.setProperty("train-file", "form-index=1,tag-index=4,morph-index=6," + this.getResourceFile("trn.txt"));
        options.setProperty("test-file", "form-index=1,tag-index=4,morph-index=6," + this.getResourceFile("tst.txt"));
        PipelineTest.realTestWithOptions(options, 98.51, 54.1);
    }

    @Test
    public void realInfixTest() {
        MorphOptions options = new MorphOptions();
        options.setProperty("seed", "42");
        options.setProperty("num-iterations", "10");
        options.setProperty("initial-vector-size", "10000000");
        options.setProperty("candidates-per-state", "[4, 2, 1.5, 1.25]");
        options.setProperty("prune", "true");
        options.setProperty("order", "3");
        options.setProperty("penalty", ".1");
        options.setProperty("max-affix-length", "5");
        options.setProperty("feature-templates", "form,rare,infix,context,sig,bigrams");
        options.setProperty("train-file", "form-index=1,tag-index=4,morph-index=6," + this.getResourceFile("trn.txt"));
        options.setProperty("test-file", "form-index=1,tag-index=4,morph-index=6," + this.getResourceFile("tst.txt"));
        PipelineTest.realTestWithOptions(options, 99.0, 51.5);
    }

    @Test
    public void realFloatTest() {
        MorphOptions options = new MorphOptions();
        options.setProperty("seed", "42");
        options.setProperty("num-iterations", "10");
        options.setProperty("initial-vector-size", "10000000");
        options.setProperty("candidates-per-state", "[4, 2, 1.5, 1.25]");
        options.setProperty("prune", "true");
        options.setProperty("order", "3");
        options.setProperty("penalty", ".1");
        options.setProperty("type-embeddings", this.getResourceFile("svd_small.txt"));
        options.setProperty("train-file", "form-index=1,tag-index=4,morph-index=6," + this.getResourceFile("trn.txt"));
        options.setProperty("test-file", "form-index=1,tag-index=4,morph-index=6," + this.getResourceFile("tst.txt"));
        PipelineTest.realTestWithOptions(options, 98.89, 54.52);
    }

    @Test
    public void realOptimizerTest() {
        MorphOptions options = new MorphOptions();
        options.setProperty("seed", "42");
        options.setProperty("num-iterations", "10");
        options.setProperty("initial-vector-size", "10000000");
        options.setProperty("candidates-per-state", "[4, 2, 1.5, 1.25]");
        options.setProperty("prune", "true");
        options.setProperty("optimize-num-iterations", "true");
        options.setProperty("train-file", "form-index=1,tag-index=4,morph-index=6," + this.getResourceFile("trn.txt"));
        options.setProperty("test-file", "form-index=1,tag-index=4,morph-index=6," + this.getResourceFile("tst.txt"));
    }

    @Test
    public void realNonHashTest() {
        MorphOptions options = new MorphOptions();
        options.setProperty("seed", "42");
        options.setProperty("num-iterations", "10");
        options.setProperty("initial-vector-size", "1");
        options.setProperty("use-hash-vector", "false");
        options.setProperty("candidates-per-state", "[4, 2, 1.5, 1.25]");
        options.setProperty("prune", "true");
        options.setProperty("order", "3");
        options.setProperty("penalty", "0.1");
        options.setProperty("train-file", "form-index=1,tag-index=4,morph-index=6," + this.getResourceFile("trn.txt"));
        options.setProperty("test-file", "form-index=1,tag-index=4,morph-index=6," + this.getResourceFile("tst.txt"));
        PipelineTest.realTestWithOptions(options, 98.51, 54.1);
    }

    @Test
    public void realNormalizeFormTest() {
        MorphOptions options = new MorphOptions();
        options.setProperty("seed", "42");
        options.setProperty("num-iterations", "10");
        options.setProperty("initial-vector-size", "10000000");
        options.setProperty("candidates-per-state", "[4, 2, 1.5, 1.25]");
        options.setProperty("prune", "true");
        options.setProperty("order", "3");
        options.setProperty("penalty", ".1");
        options.setProperty("form-normalization", StringUtils.Mode.lower.toString());
        options.setProperty("train-file", "form-index=1,tag-index=4,morph-index=6," + this.getResourceFile("trn.txt"));
        options.setProperty("test-file", "form-index=1,tag-index=4,morph-index=6," + this.getResourceFile("tst.txt"));
        PipelineTest.realTestWithOptions(options, 99.11, 55.38);
    }

    @Test
    public void realSpecialSignatureTest() {
        MorphOptions options = new MorphOptions();
        options.setProperty("seed", "42");
        options.setProperty("num-iterations", "10");
        options.setProperty("initial-vector-size", "10000000");
        options.setProperty("candidates-per-state", "[4, 2, 1.5, 1.25]");
        options.setProperty("prune", "true");
        options.setProperty("order", "3");
        options.setProperty("penalty", ".1");
        options.setProperty("special-signature", "true");
        options.setProperty("train-file", "form-index=1,tag-index=4,morph-index=6," + this.getResourceFile("trn.txt"));
        options.setProperty("test-file", "form-index=1,tag-index=4,morph-index=6," + this.getResourceFile("tst.txt"));
        PipelineTest.realTestWithOptions(options, 98.45, 53.96);
    }

    @Test
    public void realPosTest() {
        MorphOptions options = new MorphOptions();
        options.setProperty("seed", "42");
        options.setProperty("num-iterations", "10");
        options.setProperty("initial-vector-size", "10000000");
        options.setProperty("candidates-per-state", "[4, 2, 1.5, 1.25]");
        options.setProperty("prune", "true");
        options.setProperty("order", "3");
        options.setProperty("penalty", ".1");
        options.setProperty("train-file", "form-index=1,tag-index=4," + this.getResourceFile("trn.txt"));
        options.setProperty("test-file", "form-index=1,tag-index=4," + this.getResourceFile("tst.txt"));
        options.setProperty("tag-morph", "false");
        PipelineTest.realTestWithOptions(options, 99.66, 79.14);
    }

    @Test
    public void realPerceptronPosTest() {
        MorphOptions options = new MorphOptions();
        options.setProperty("seed", "42");
        options.setProperty("num-iterations", "10");
        options.setProperty("initial-vector-size", "10000000");
        options.setProperty("prune", "false");
        options.setProperty("order", "1");
        options.setProperty("trainer", PerceptronTrainer.class.getCanonicalName());
        options.setProperty("tag-morph", "false");
        options.setProperty("train-file", "form-index=1,tag-index=4,morph-index=6," + this.getResourceFile("trn.txt"));
        options.setProperty("test-file", "form-index=1,tag-index=4,morph-index=6," + this.getResourceFile("tst.txt"));
        PipelineTest.realTestWithOptions(options, 98.84, 77.49);
    }

    @Test
    public void realOracleTest() {
        MorphOptions options = new MorphOptions();
        options.setProperty("seed", "42");
        options.setProperty("num-iterations", "10");
        options.setProperty("initial-vector-size", "10000000");
        options.setProperty("candidates-per-state", "[4, 2, 1.5, 1.25]");
        options.setProperty("prune", "true");
        options.setProperty("order", "3");
        options.setProperty("penalty", ".1");
        options.setProperty("oracle", "true");
        options.setProperty("train-file", "form-index=1,tag-index=4,morph-index=6," + this.getResourceFile("trn.txt"));
        options.setProperty("test-file", "form-index=1,tag-index=4,morph-index=6," + this.getResourceFile("tst.txt"));
        PipelineTest.realTestWithOptions(options, 99.94, 53.39);
    }

    @Test
    public void realFstTest() {
        MorphOptions options = new MorphOptions();
        options.setProperty("seed", "42");
        options.setProperty("num-iterations", "10");
        options.setProperty("initial-vector-size", "10000000");
        options.setProperty("candidates-per-state", "[4, 2, 1.5, 1.25]");
        options.setProperty("prune", "true");
        options.setProperty("order", "3");
        options.setProperty("penalty", ".1");
        options.setProperty("train-file", "form-index=1,tag-index=4,morph-index=6,token-feature-index=7," + this.getResourceFile("trn.fst.txt"));
        options.setProperty("test-file", "form-index=1,tag-index=4,morph-index=6,token-feature-index=7," + this.getResourceFile("tst.fst.txt"));
        PipelineTest.realTestWithOptions(options, 99.33, 70.1);
    }

    @Test
    public void realFstNoDefaultFeaturesTest() {
        MorphOptions options = new MorphOptions();
        options.setProperty("seed", "42");
        options.setProperty("num-iterations", "10");
        options.setProperty("initial-vector-size", "10000000");
        options.setProperty("candidates-per-state", "[4, 2, 1.5, 1.25]");
        options.setProperty("prune", "true");
        options.setProperty("order", "3");
        options.setProperty("penalty", ".1");
        options.setProperty("train-file", "form-index=1,tag-index=4,morph-index=6,token-feature-index=7," + this.getResourceFile("trn.fst.txt"));
        options.setProperty("test-file", "form-index=1,tag-index=4,morph-index=6,token-feature-index=7," + this.getResourceFile("tst.fst.txt"));
        options.setProperty("use-default-features", "false");
        PipelineTest.realTestWithOptions(options, 60.84, 50.13);
    }

    @Test
    public void realAramorphBaselineTest() {
        MorphOptions options = new MorphOptions();
        options.setProperty("seed", "42");
        options.setProperty("num-iterations", "10");
        options.setProperty("initial-vector-size", "10000000");
        options.setProperty("candidates-per-state", "[4, 2, 1.5, 1.25]");
        options.setProperty("prune", "true");
        options.setProperty("order", "3");
        options.setProperty("penalty", ".1");
        options.setProperty("internal-analyzer", "ar");
        options.setProperty("train-file", "form-index=1,tag-index=4,morph-index=6," + this.getResourceFile("trn.aramorph.txt"));
        options.setProperty("test-file", "form-index=1,tag-index=4,morph-index=6," + this.getResourceFile("tst.aramorph.txt"));
        PipelineTest.realTestWithOptions(options, 100.0, 66.26);
    }

    @Test
    public void realFstMaxLevelTest() {
        MorphOptions options = new MorphOptions();
        options.setProperty("seed", "42");
        options.setProperty("num-iterations", "10");
        options.setProperty("initial-vector-size", "10000000");
        options.setProperty("candidates-per-state", "[4, 2, 1.5, 1.25]");
        options.setProperty("prune", "true");
        options.setProperty("order", "3");
        options.setProperty("penalty", ".1");
        options.setProperty("max-transition-feature-level", "0");
        options.setProperty("train-file", "form-index=1,tag-index=4,morph-index=6,token-feature-index=7," + this.getResourceFile("trn.fst.txt"));
        options.setProperty("test-file", "form-index=1,tag-index=4,morph-index=6,token-feature-index=7," + this.getResourceFile("tst.fst.txt"));
        PipelineTest.realTestWithOptions(options, 99.06, 69.46);
    }

    @Test
    public void realOracleFstTest() {
        MorphOptions options = new MorphOptions();
        options.setProperty("seed", "42");
        options.setProperty("num-iterations", "10");
        options.setProperty("initial-vector-size", "10000000");
        options.setProperty("candidates-per-state", "[4, 2, 1.5, 1.25]");
        options.setProperty("prune", "true");
        options.setProperty("order", "3");
        options.setProperty("penalty", ".1");
        options.setProperty("oracle", "true");
        options.setProperty("train-file", "form-index=1,tag-index=4,morph-index=6,token-feature-index=7," + this.getResourceFile("trn.fst.txt"));
        options.setProperty("test-file", "form-index=1,tag-index=4,morph-index=6,token-feature-index=7," + this.getResourceFile("tst.fst.txt"));
        PipelineTest.realTestWithOptions(options, 99.83, 70.94);
    }

    public void toyTestWithOptions(MorphOptions options) {
        options.setProperty("shape", "false");
        PipelineTest.testWithOptions(options, this.getTrainSentences(), this.getTestSentences(), 100.0, 100.0, 0.0, 0.0);
    }

    public void realOptimizerTestWithOptions(MorphOptions options, double train_acc, double test_acc) {
        PipelineTest.testOptimizerWithOptions(options, PipelineTest.getSentences(options.getTrainFile(), 100), PipelineTest.getSentences(options.getTestFile(), 100), train_acc, test_acc);
    }

    public static void realTestWithOptions(MorphOptions options, double train_acc, double test_acc) {
        PipelineTest.realTestWithOptions(options, train_acc, test_acc, 0.0, 0.0);
    }

    public static void realTestWithOptions(MorphOptions options, double train_acc, double test_acc, double lemma_train_acc, double lemma_test_acc) {
        PipelineTest.testWithOptions(options, PipelineTest.getSentences(options.getTrainFile(), 100), PipelineTest.getSentences(options.getTestFile(), 100), train_acc, test_acc, lemma_train_acc, lemma_test_acc);
    }

    public static void testWithOptions(MorphOptions options, List<Sequence> train_sentences, List<Sequence> test_sentences, double train_threshold, double test_threshold, double train_lemma_threshold, double test_lemma_threshold) {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        String caller = "None";
        if (stack.length > 3) {
            caller = stack[3].getMethodName();
        }
        Tagger tagger = MorphModel.train(options, train_sentences, null);
        PipelineTest.assertModelPerformanceOnTestset(caller + " Train", tagger, train_sentences, train_threshold, train_lemma_threshold);
        PipelineTest.assertModelPerformanceOnTestset(caller + " Test ", tagger, test_sentences, test_threshold, test_lemma_threshold);
        try {
            File tempfile = File.createTempFile("tagger", ".marmot");
            tempfile.deleteOnExit();
            FileUtils.saveToFile((Serializable)tagger, tempfile);
            Tagger loaded_tagger = (Tagger)FileUtils.loadFromFile(tempfile);
            PipelineTest.assertModelPerformanceOnTestset(caller + " Test (reload) ", loaded_tagger, test_sentences, test_threshold);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void testOptimizerWithOptions(MorphOptions options, List<Sequence> train_sentences, List<Sequence> test_sentences, double train_threshold, double test_threshold) {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        String caller = "None";
        if (stack.length > 3) {
            caller = stack[3].getMethodName();
        }
        assert (test_sentences != null);
        Tagger tagger = MorphModel.trainOptimal(options, train_sentences, null);
        PipelineTest.assertModelPerformanceOnTestset(caller + " Train", tagger, train_sentences, train_threshold);
        PipelineTest.assertModelPerformanceOnTestset(caller + " Test ", tagger, test_sentences, test_threshold);
        Tagger clone = Copy.clone(tagger);
        PipelineTest.assertModelPerformanceOnTestset(caller + " Test (reload) ", clone, test_sentences, test_threshold);
    }

    public static void assertModelPerformanceOnTestset(String name, Tagger tagger, List<Sequence> sentences, double threshold) {
        PipelineTest.assertModelPerformanceOnTestset(name, tagger, sentences, threshold, 0.0);
    }

    public static void assertModelPerformanceOnTestset(String name, Tagger tagger, List<Sequence> sentences, double threshold, double lemma_threshold) {
        MorphResult result2 = new MorphResult(tagger.getModel(), tagger.getNumLevels());
        MorphModel model = (MorphModel)tagger.getModel();
        for (Sequence sentence : sentences) {
            for (Token token2 : sentence) {
                Word word = (Word)token2;
                model.addIndexes(word, false);
            }
            result2.increment(MorphEvaluator.eval(tagger, (Sentence)sentence));
        }
        double accuracy = (double)(result2.num_tokens - result2.morph_errors) * 100.0 / (double)result2.num_tokens;
        double lemma_accuracy = (double)(result2.num_tokens - result2.lemma_errors) * 100.0 / (double)result2.num_tokens;
        System.err.println(result2.toString());
        if (accuracy - threshold < -1.0E-5) {
            throw new AssertionFailedError(accuracy + " < " + threshold);
        }
        if (lemma_accuracy - lemma_threshold < -1.0E-5) {
            throw new AssertionFailedError(accuracy + " < " + threshold);
        }
    }
}

