/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.jaxp;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.jaxp.SchemaFactoryImpl;
import com.saxonica.ee.jaxp.TypedContentHandler;
import com.saxonica.ee.jaxp.URIResourceResolver;
import com.saxonica.ee.schema.sdoc.LSSchemaResolver;
import javax.xml.transform.URIResolver;
import javax.xml.validation.TypeInfoProvider;
import javax.xml.validation.ValidatorHandler;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ReceivingContentHandler;
import net.sf.saxon.lib.UnfailingErrorListener;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.ext.LexicalHandler;

public class ValidatorHandlerImpl
extends ValidatorHandler
implements ContentHandler,
LexicalHandler,
DTDHandler {
    ReceivingContentHandler next;
    TypedContentHandler finalProxy;
    PipelineConfiguration pipe;

    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        this.pipe = pipe;
    }

    public void setReceivingContentHandler(ReceivingContentHandler rch) {
        this.next = rch;
    }

    public void setFinalProxy(TypedContentHandler proxy) {
        this.finalProxy = proxy;
    }

    @Override
    public void setContentHandler(ContentHandler receiver) {
        this.finalProxy.setUnderlyingContentHandler(receiver);
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.finalProxy.getUnderlyingContentHandler();
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        if (errorHandler == null) {
            errorHandler = SchemaFactoryImpl.DRACONIAN_ERROR_HANDLER;
        }
        SchemaFactoryImpl.ErrorListenerWrappingErrorHandler el = new SchemaFactoryImpl.ErrorListenerWrappingErrorHandler(errorHandler);
        this.pipe.setErrorListener(el);
    }

    @Override
    public ErrorHandler getErrorHandler() {
        UnfailingErrorListener el = this.pipe.getErrorListener();
        if (el instanceof SchemaFactoryImpl.ErrorListenerWrappingErrorHandler) {
            ErrorHandler eh = ((SchemaFactoryImpl.ErrorListenerWrappingErrorHandler)((Object)el)).getErrorHandler();
            return eh == SchemaFactoryImpl.DRACONIAN_ERROR_HANDLER ? null : eh;
        }
        return null;
    }

    @Override
    public void setResourceResolver(LSResourceResolver resourceResolver) {
        this.pipe.setURIResolver(new URIResourceResolver(resourceResolver));
        this.pipe.setSchemaURIResolver(new LSSchemaResolver(resourceResolver, this.pipe.getConfiguration()));
    }

    @Override
    public LSResourceResolver getResourceResolver() {
        URIResolver u = this.pipe.getURIResolver();
        if (u instanceof URIResourceResolver) {
            return ((URIResourceResolver)u).getLSResourceResolver();
        }
        return null;
    }

    @Override
    public TypeInfoProvider getTypeInfoProvider() {
        return this.finalProxy.getTypeInfoProvider();
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.next.setDocumentLocator(locator);
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        try {
            return this.pipe.getConfiguration().getConfigurationProperty(name);
        }
        catch (IllegalArgumentException err) {
            throw new SAXNotSupportedException(err.getMessage());
        }
    }

    @Override
    public void setProperty(String name, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        try {
            this.pipe.getConfiguration().setConfigurationProperty(name, object);
        }
        catch (IllegalArgumentException err) {
            throw new SAXNotSupportedException(err.getMessage());
        }
    }

    public EnterpriseConfiguration getConfiguration() {
        return (EnterpriseConfiguration)this.pipe.getConfiguration();
    }

    @Override
    public void startDocument() throws SAXException {
        this.next.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        this.next.endDocument();
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.next.startPrefixMapping(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.next.endPrefixMapping(prefix);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.next.startElement(uri, localName, qName, atts);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.next.endElement(uri, localName, qName);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.next.characters(ch, start, length);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.next.ignorableWhitespace(ch, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.next.processingInstruction(target, data);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.next.skippedEntity(name);
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.next.startDTD(name, publicId, systemId);
    }

    @Override
    public void endDTD() throws SAXException {
        this.next.endDTD();
    }

    @Override
    public void startEntity(String name) throws SAXException {
        this.next.startEntity(name);
    }

    @Override
    public void endEntity(String name) throws SAXException {
        this.next.endEntity(name);
    }

    @Override
    public void startCDATA() throws SAXException {
        this.next.startCDATA();
    }

    @Override
    public void endCDATA() throws SAXException {
        this.next.endCDATA();
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        this.next.comment(ch, start, length);
    }

    @Override
    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        this.next.notationDecl(name, publicId, systemId);
    }

    @Override
    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        this.next.unparsedEntityDecl(name, publicId, systemId, notationName);
    }
}

