/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream;

import com.saxonica.ee.stream.PostureGetter;
import java.util.Set;

public enum Posture implements PostureGetter
{
    GROUNDED,
    CLIMBING,
    STRIDING,
    CRAWLING,
    ROAMING;


    @Override
    public Posture getPosture() {
        return this;
    }

    public boolean isIncremental() {
        return this == STRIDING || this == CRAWLING;
    }

    public String toString() {
        return super.toString().toLowerCase();
    }

    public static Posture combinedPosture(Set<Posture> postures) {
        if (postures.contains(ROAMING)) {
            return ROAMING;
        }
        if (postures.isEmpty()) {
            return GROUNDED;
        }
        if (postures.contains(GROUNDED) && postures.size() == 1) {
            return GROUNDED;
        }
        if (postures.contains(CLIMBING)) {
            if (postures.size() == 1) {
                return CLIMBING;
            }
            if (postures.size() == 2 && postures.contains(GROUNDED)) {
                return CLIMBING;
            }
        }
        if (postures.contains(STRIDING)) {
            if (postures.size() == 1) {
                return STRIDING;
            }
            if (postures.size() == 2 && postures.contains(GROUNDED)) {
                return STRIDING;
            }
        }
        if (postures.contains(CRAWLING) && !postures.contains(CLIMBING)) {
            return CRAWLING;
        }
        return ROAMING;
    }
}

