/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.index;

import de.ids_mannheim.korap.index.PositionsToOffset;
import de.ids_mannheim.korap.index.TermInfo;
import de.ids_mannheim.korap.response.Match;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpanInfo {
    ArrayList<TermInfo> terms = new ArrayList(64);
    HashMap<Integer, Integer> startChar = new HashMap(16);
    HashMap<Integer, Integer> endChar = new HashMap(16);
    PositionsToOffset pto;
    int localDocID;
    private static final Logger log = LoggerFactory.getLogger(Match.class);
    public static final boolean DEBUG = false;

    public SpanInfo(PositionsToOffset pto, int localDocID) {
        this.pto = pto;
        this.localDocID = localDocID;
    }

    public void add(TermInfo info) {
        info.analyze();
        if (info.getType() != "pos") {
            this.terms.add(info);
        } else {
            this.startChar.put(info.getStartPos(), info.getStartChar());
            this.endChar.put(info.getEndPos(), info.getEndChar());
        }
    }

    public ArrayList<TermInfo> getTerms() {
        Collections.sort(this.terms);
        for (TermInfo t : this.terms) {
            boolean found = true;
            if (t.getStartChar() == -1) {
                if (this.startChar.containsKey(t.getStartPos())) {
                    t.setStartChar(this.startChar.get(t.getStartPos()));
                } else {
                    found = false;
                }
            }
            if (t.getEndChar() == -1) {
                if (this.endChar.containsKey(t.getEndPos())) {
                    t.setEndChar(this.endChar.get(t.getEndPos()));
                } else {
                    found = false;
                }
            }
            if (found && t.getStartPos() == t.getEndPos()) {
                this.pto.addOffset(this.localDocID, t.getStartPos(), t.getStartChar(), t.getEndChar());
                continue;
            }
            this.pto.add(this.localDocID, t.getStartPos());
            this.pto.add(this.localDocID, t.getStartPos());
        }
        return this.terms;
    }
}

