/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.feed;

import com.saxonica.ee.stream.feed.AbsorptionFeed;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.feed.StringValueGatherer;
import com.saxonica.ee.stream.om.FleetingParentNode;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

public class StringValueFeed
extends AbsorptionFeed {
    public StringValueFeed(ItemFeed result, XPathContext context) {
        super(result, context);
    }

    @Override
    protected AbsorptionFeed.PendingItem makePendingItem(int sequenceNr, FleetingParentNode node) {
        return new PendingStringValue(this.valuesReadyToBeOutput.size(), node);
    }

    @Override
    protected Sequence processGroundedItem(Item item) throws XPathException {
        return new StringValue(item.getUnicodeStringValue());
    }

    @Override
    public void close() throws XPathException {
        if (!this.hasFailed()) {
            this.getNextOutputter().close();
        }
    }

    private static class PendingStringValue
    extends AbsorptionFeed.PendingItem {
        public UnicodeBuilder buffer = new UnicodeBuilder();
        public FleetingParentNode node;

        public PendingStringValue(int sequence, FleetingParentNode node) {
            super(sequence);
            this.node = node;
        }

        @Override
        public Receiver getGatherer() {
            return new StringValueGatherer(this.buffer);
        }

        @Override
        public Sequence deliver() {
            return new StringValue(this.buffer.toUnicodeString());
        }

        @Override
        public void rollback() {
            this.buffer.clear();
        }
    }
}

