/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.qt4;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LazySequence;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;

public abstract class ItemsStarting
extends SystemFunction {
    protected abstract boolean includeMatchingItem();

    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        Sequence input = arguments[0];
        FunctionItem startCondition = (FunctionItem)arguments[1].head();
        return new LazySequence(new StartingIterator(input.iterate(), startCondition, this.includeMatchingItem(), context));
    }

    private static class StartingIterator
    implements SequenceIterator {
        private final SequenceIterator baseIterator;
        private final FunctionItem start;
        private final boolean inclusive;
        private final XPathContext context;
        private boolean started;

        StartingIterator(SequenceIterator in, FunctionItem start, boolean inclusive, XPathContext context) {
            this.baseIterator = in;
            this.start = start;
            this.inclusive = inclusive;
            this.context = context;
        }

        @Override
        public Item next() {
            Item item;
            while ((item = this.baseIterator.next()) != null) {
                if (this.started) {
                    return item;
                }
                try {
                    BooleanValue matches = (BooleanValue)this.start.call(this.context, SequenceTool.fromItems(item)).head();
                    if (!matches.getBooleanValue()) continue;
                    this.started = true;
                    if (!this.inclusive) continue;
                    return item;
                }
                catch (XPathException e) {
                    throw new UncheckedXPathException(e);
                }
            }
            return null;
        }

        @Override
        public void close() {
            this.baseIterator.close();
        }
    }

    public static class ItemsAfter
    extends ItemsStarting {
        @Override
        protected boolean includeMatchingItem() {
            return false;
        }

        @Override
        public String getStreamerName() {
            return "saxon:ItemsAfter";
        }
    }

    public static class ItemsFrom
    extends ItemsStarting {
        @Override
        protected boolean includeMatchingItem() {
            return true;
        }

        @Override
        public String getStreamerName() {
            return "saxon:ItemsFrom";
        }
    }
}

