/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ExpressionCompiler;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.objectweb.asm.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.expr.Calculator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;

public abstract class CalculatorCompiler {
    CompilerService compiler;
    Expression oper0;
    Expression oper1;

    public void setCompilerService(CompilerService compiler) {
        this.compiler = compiler;
    }

    public void setExpressions(Expression oper0, Expression oper1) {
        this.oper0 = oper0;
        this.oper1 = oper1;
    }

    public abstract void compute(Generator var1, SourceLocator var2);

    private static void doubleArithmetic(Generator ga, int operator) {
        ga.checkClass(NumericValue.class);
        ga.invokeInstanceMethod(NumericValue.class, "getDoubleValue", new Class[0]);
        ga.dup2X1();
        ga.pop2();
        ga.checkClass(NumericValue.class);
        ga.invokeInstanceMethod(NumericValue.class, "getDoubleValue", new Class[0]);
        ga.dup2X2();
        ga.pop2();
        ga.math(operator, Type.DOUBLE_TYPE);
        ga.newInstance(Type.getType(DoubleValue.class));
        ga.dupX2();
        ga.dupX2();
        ga.pop();
        ga.invokeConstructor(DoubleValue.class, Double.TYPE);
    }

    private static void floatArithmetic(Generator ga, int operator) {
        ga.checkClass(NumericValue.class);
        ga.invokeInstanceMethod(NumericValue.class, "getFloatValue", new Class[0]);
        ga.swap();
        ga.checkClass(NumericValue.class);
        ga.invokeInstanceMethod(NumericValue.class, "getFloatValue", new Class[0]);
        ga.swap();
        ga.math(operator, Type.FLOAT_TYPE);
        ga.newInstance(Type.getType(FloatValue.class));
        ga.dupX1();
        ga.swap();
        ga.invokeConstructor(FloatValue.class, Float.TYPE);
    }

    private static void decimalArithmetic(CompilerService compiler, Generator ga, String integerMethod, String decimalMethod) {
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        LabelInfo notInteger = methodInfo.newLabel("notInteger");
        LabelInfo end = methodInfo.newLabel("endCalc");
        int oper0Var = methodInfo.allocateLocal(NumericValue.class);
        int oper1Var = methodInfo.allocateLocal(NumericValue.class);
        ga.checkClass(NumericValue.class);
        ga.storeLocal(oper1Var);
        ga.checkClass(NumericValue.class);
        ga.storeLocal(oper0Var);
        ga.loadLocal(oper0Var);
        ga.ifNotInstance(IntegerValue.class, notInteger);
        ga.loadLocal(oper1Var);
        ga.ifNotInstance(IntegerValue.class, notInteger);
        ga.loadLocal(oper0Var);
        ga.checkClass(IntegerValue.class);
        ga.loadLocal(oper1Var);
        ga.checkClass(IntegerValue.class);
        ga.invokeInstanceMethod(IntegerValue.class, integerMethod, IntegerValue.class);
        ga.goTo(end);
        methodInfo.placeLabel(notInteger);
        ga.newInstance(Type.getType(BigDecimalValue.class));
        ga.dup();
        ga.loadLocal(oper0Var);
        ga.checkClass(NumericValue.class);
        ga.invokeInstanceMethod(NumericValue.class, "getDecimalValue", new Class[0]);
        ga.loadLocal(oper1Var);
        ga.checkClass(NumericValue.class);
        ga.invokeInstanceMethod(NumericValue.class, "getDecimalValue", new Class[0]);
        ga.invokeInstanceMethod(BigDecimal.class, decimalMethod, BigDecimal.class);
        ga.invokeConstructor(BigDecimalValue.class, BigDecimal.class);
        methodInfo.placeLabel(end);
    }

    private static void anyAnyArithmetic(CompilerService compiler, Generator ga, int operator, String opName, SourceLocator locator) {
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        ga.swap();
        ga.dup2();
        ga.invokeInstanceMethod(AtomicValue.class, "getItemType", new Class[0]);
        ga.invokeInstanceMethod(ItemType.class, "getPrimitiveType", new Class[0]);
        ga.swap();
        ga.invokeInstanceMethod(AtomicValue.class, "getItemType", new Class[0]);
        ga.invokeInstanceMethod(ItemType.class, "getPrimitiveType", new Class[0]);
        ga.push(operator);
        ga.push(true);
        ga.invokeStaticMethod(Calculator.class, "getCalculator", Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
        ga.dupX2();
        LabelInfo notNullCalc = methodInfo.newLabel("notNullCalc");
        ga.ifNonNull(notNullCalc.label());
        compiler.generateDynamicError("Unsuitable types for " + opName + " operation", "XPTY0004", locator, true);
        methodInfo.placeLabel(notNullCalc);
        ga.swap();
        compiler.generateGetContext();
        ga.invokeInstanceMethod(Calculator.class, "compute", AtomicValue.class, AtomicValue.class, XPathContext.class);
    }

    public static class AnyModAny
    extends CalculatorCompiler {
        @Override
        public void compute(Generator ga, SourceLocator locator) {
            ExpressionCompiler.visitAnnotation(this.compiler, "AnyModAnyCalculator");
            CalculatorCompiler.anyAnyArithmetic(this.compiler, ga, 4, "mod", locator);
        }
    }

    public static class AnyDivAny
    extends CalculatorCompiler {
        @Override
        public void compute(Generator ga, SourceLocator locator) {
            ExpressionCompiler.visitAnnotation(this.compiler, "AnyDivAnyCalculator");
            CalculatorCompiler.anyAnyArithmetic(this.compiler, ga, 3, "div", locator);
        }
    }

    public static class AnyIdivAny
    extends CalculatorCompiler {
        @Override
        public void compute(Generator ga, SourceLocator locator) {
            ExpressionCompiler.visitAnnotation(this.compiler, "AnyIdivAnyCalculator");
            CalculatorCompiler.anyAnyArithmetic(this.compiler, ga, 5, "idiv", locator);
        }
    }

    public static class AnyTimesAny
    extends CalculatorCompiler {
        @Override
        public void compute(Generator ga, SourceLocator locator) {
            ExpressionCompiler.visitAnnotation(this.compiler, "AnyTimesCalculator-0");
            CalculatorCompiler.anyAnyArithmetic(this.compiler, ga, 2, "multiply (*)", locator);
        }
    }

    public static class AnyMinusAny
    extends CalculatorCompiler {
        @Override
        public void compute(Generator ga, SourceLocator locator) {
            ExpressionCompiler.visitAnnotation(this.compiler, "AnyMinusCalculator-0");
            CalculatorCompiler.anyAnyArithmetic(this.compiler, ga, 1, "minus (-)", locator);
        }
    }

    public static class AnyPlusAny
    extends CalculatorCompiler {
        @Override
        public void compute(Generator ga, SourceLocator locator) {
            ExpressionCompiler.visitAnnotation(this.compiler, "AnyPlusCalculator-0");
            CalculatorCompiler.anyAnyArithmetic(this.compiler, ga, 0, "plus (+)", locator);
        }
    }

    public static class DecimalIdivDecimal
    extends CalculatorCompiler {
        @Override
        public void compute(Generator ga, SourceLocator locator) {
            GeneratedMethodInfo methodInfo = this.compiler.getCurrentMethod();
            int oper0Var = methodInfo.allocateLocal(NumericValue.class);
            int oper1Var = methodInfo.allocateLocal(NumericValue.class);
            ga.checkClass(NumericValue.class);
            ga.storeLocal(oper1Var);
            ga.checkClass(NumericValue.class);
            ga.storeLocal(oper0Var);
            LabelInfo notInstance = methodInfo.newLabel("notInstance");
            LabelInfo end = methodInfo.newLabel("endCalc");
            LabelInfo notNeg = methodInfo.newLabel("notNeg");
            ga.loadLocal(oper0Var);
            ga.instanceOf(Type.getType(IntegerValue.class));
            ga.ifZCmp(153, notInstance.label());
            ga.loadLocal(oper1Var);
            ga.instanceOf(Type.getType(IntegerValue.class));
            ga.ifZCmp(153, notInstance.label());
            ga.loadLocal(oper0Var);
            ga.checkClass(IntegerValue.class);
            ga.loadLocal(oper1Var);
            ga.checkClass(IntegerValue.class);
            ga.invokeInstanceMethod(IntegerValue.class, "idiv", IntegerValue.class);
            ga.goTo(end);
            methodInfo.placeLabel(notInstance);
            ga.loadLocal(oper0Var);
            ga.checkClass(NumericValue.class);
            ga.invokeInstanceMethod(NumericValue.class, "getDecimalValue", new Class[0]);
            ga.loadLocal(oper1Var);
            ga.checkClass(NumericValue.class);
            ga.invokeInstanceMethod(NumericValue.class, "getDecimalValue", new Class[0]);
            ga.dup();
            ga.invokeInstanceMethod(BigDecimal.class, "signum", new Class[0]);
            ga.ifZCmp(154, notNeg.label());
            this.compiler.generateDynamicError("Integer division by zero", "FOAR0001", locator, true);
            ga.goTo(end);
            methodInfo.placeLabel(notNeg);
            ga.invokeInstanceMethod(BigDecimal.class, "divideToIntegralValue", BigDecimal.class);
            ga.invokeInstanceMethod(BigDecimal.class, "toBigInteger", new Class[0]);
            ga.invokeStaticMethod(BigIntegerValue.class, "makeIntegerValue", BigInteger.class);
            methodInfo.placeLabel(end);
        }
    }

    public static class DecimalModDecimal
    extends CalculatorCompiler {
        @Override
        public void compute(Generator ga, SourceLocator locator) {
            GeneratedMethodInfo methodInfo = this.compiler.getCurrentMethod();
            int oper0Var = methodInfo.allocateLocal(NumericValue.class);
            int oper1Var = methodInfo.allocateLocal(NumericValue.class);
            ga.checkClass(NumericValue.class);
            ga.storeLocal(oper1Var);
            ga.checkClass(NumericValue.class);
            ga.storeLocal(oper0Var);
            LabelInfo notInstance = methodInfo.newLabel("notInstance");
            LabelInfo end = methodInfo.newLabel("endCalc");
            LabelInfo notZero = methodInfo.newLabel("notZero");
            ga.loadLocal(oper0Var);
            ga.instanceOf(Type.getType(IntegerValue.class));
            ga.ifZCmp(153, notInstance.label());
            ga.loadLocal(oper1Var);
            ga.instanceOf(Type.getType(IntegerValue.class));
            ga.ifZCmp(153, notInstance.label());
            ga.loadLocal(oper0Var);
            ga.checkClass(IntegerValue.class);
            ga.loadLocal(oper1Var);
            ga.checkClass(IntegerValue.class);
            ga.invokeInstanceMethod(IntegerValue.class, "mod", IntegerValue.class);
            ga.goTo(end);
            methodInfo.placeLabel(notInstance);
            LabelInfo L0 = methodInfo.newLabel("L0");
            LabelInfo L1 = methodInfo.newLabel("L1");
            LabelInfo L2 = methodInfo.newLabel("L2");
            ga.visitTryCatchBlock(L0, L1, L2, "java/lang/ArithmeticException");
            methodInfo.placeLabel(L0);
            ga.newInstance(Type.getType(BigDecimalValue.class));
            ga.dup();
            ga.loadLocal(oper0Var);
            ga.checkClass(NumericValue.class);
            ga.invokeInstanceMethod(NumericValue.class, "getDecimalValue", new Class[0]);
            ga.loadLocal(oper1Var);
            ga.checkClass(NumericValue.class);
            ga.invokeInstanceMethod(NumericValue.class, "getDecimalValue", new Class[0]);
            ga.invokeInstanceMethod(BigDecimal.class, "remainder", BigDecimal.class);
            ga.invokeConstructor(BigDecimalValue.class, BigDecimal.class);
            methodInfo.placeLabel(L1);
            ga.goTo(end);
            methodInfo.placeLabel(L2);
            ga.loadLocal(oper1Var);
            ga.checkClass(NumericValue.class);
            ga.push(0L);
            ga.invokeInstanceMethod(NumericValue.class, "compareTo", Long.TYPE);
            ga.ifZCmp(154, notZero.label());
            this.compiler.generateDynamicError("Decimal modulo zero", "FOAR0001", locator, false);
            ga.goTo(end.label());
            methodInfo.placeLabel(notZero);
            ga.throwException();
            methodInfo.placeLabel(end);
        }
    }

    public static class DecimalDivDecimal
    extends CalculatorCompiler {
        @Override
        public void compute(Generator ga, SourceLocator locator) {
            ga.checkClass(NumericValue.class);
            ga.swap();
            ga.checkClass(NumericValue.class);
            ga.swap();
            ga.invokeStaticMethod(Calculator.class, "decimalDivide", NumericValue.class, NumericValue.class);
        }
    }

    public static class DecimalTimesDecimal
    extends CalculatorCompiler {
        @Override
        public void compute(Generator ga, SourceLocator locator) {
            CalculatorCompiler.decimalArithmetic(this.compiler, ga, "times", "multiply");
        }
    }

    public static class DecimalMinusDecimal
    extends CalculatorCompiler {
        @Override
        public void compute(Generator ga, SourceLocator locator) {
            CalculatorCompiler.decimalArithmetic(this.compiler, ga, "minus", "subtract");
        }
    }

    public static class DecimalPlusDecimal
    extends CalculatorCompiler {
        @Override
        public void compute(Generator ga, SourceLocator locator) {
            CalculatorCompiler.decimalArithmetic(this.compiler, ga, "plus", "add");
        }
    }

    public static class FloatIdivFloat
    extends CalculatorCompiler {
        @Override
        public void compute(Generator ga, SourceLocator locator) {
            GeneratedMethodInfo methodInfo = this.compiler.getCurrentMethod();
            ExpressionCompiler.visitAnnotation(this.compiler, "FloatIdivFloatCalculator");
            LabelInfo notZero = methodInfo.newLabel("notZero");
            LabelInfo notNan = methodInfo.newLabel("notNan");
            LabelInfo end = methodInfo.newLabel("end");
            LabelInfo bOK = methodInfo.newLabel("bOK");
            LabelInfo aOK = methodInfo.newLabel("aOK");
            int oper0Var = methodInfo.allocateLocal(NumericValue.class);
            int oper1Var = methodInfo.allocateLocal(NumericValue.class);
            ga.checkClass(NumericValue.class);
            ga.storeLocal(oper1Var);
            ga.checkClass(NumericValue.class);
            ga.storeLocal(oper0Var);
            ga.loadLocal(oper0Var);
            ga.invokeInstanceMethod(NumericValue.class, "getFloatValue", new Class[0]);
            int floatA = methodInfo.allocateLocal(Float.TYPE);
            ga.storeLocal(floatA);
            ga.loadLocal(oper1Var);
            ga.invokeInstanceMethod(NumericValue.class, "getFloatValue", new Class[0]);
            int floatB = methodInfo.allocateLocal(Float.TYPE);
            ga.storeLocal(floatB);
            ga.loadLocal(floatB);
            ga.push(0.0f);
            ga.ifCmp(Type.getType(Float.TYPE), 154, notZero.label());
            this.compiler.generateDynamicError("Integer division by zero", "FOAR0001", locator, false);
            ga.goTo(end.label());
            methodInfo.placeLabel(notZero);
            ga.loadLocal(floatA);
            ga.invokeStaticMethod(Float.class, "isNaN", Float.TYPE);
            ga.ifFalse(notNan);
            this.compiler.generateDynamicError("First operand of idiv is NaN or infinity", "FOAR0002", locator, false);
            ga.goTo(end.label());
            methodInfo.placeLabel(notNan);
            ga.loadLocal(floatA);
            ga.invokeStaticMethod(Float.class, "isInfinite", Float.TYPE);
            ga.ifFalse(aOK);
            this.compiler.generateDynamicError("First operand of idiv is NaN or infinity", "FOAR0002", locator, false);
            ga.goTo(end.label());
            methodInfo.placeLabel(aOK);
            ga.loadLocal(floatB);
            ga.invokeStaticMethod(Float.class, "isNaN", Float.TYPE);
            ga.ifFalse(bOK);
            this.compiler.generateDynamicError("Second operand of idiv is NaN or infinity", "FOAR0002", locator, false);
            ga.goTo(end.label());
            methodInfo.placeLabel(bOK);
            ga.newInstance(FloatValue.class);
            ga.dup();
            ga.loadLocal(floatA);
            ga.loadLocal(floatB);
            ga.math(108, Type.FLOAT_TYPE);
            ga.invokeConstructor(FloatValue.class, Float.TYPE);
            ExpressionCompiler.allocateStatic(this.compiler, Converter.FloatToInteger.INSTANCE);
            ga.swap();
            ga.invokeInstanceMethod(Converter.FloatToInteger.class, "convert", AtomicValue.class);
            ga.invokeInstanceMethod(ConversionResult.class, "asAtomic", new Class[0]);
            methodInfo.placeLabel(end);
            methodInfo.releaseLocal(floatA);
            methodInfo.releaseLocal(floatB);
            methodInfo.releaseLocal(oper0Var);
            methodInfo.releaseLocal(oper1Var);
        }
    }

    public static class FloatModFloat
    extends CalculatorCompiler {
        @Override
        public void compute(Generator ga, SourceLocator locator) {
            CalculatorCompiler.floatArithmetic(ga, 112);
        }
    }

    public static class FloatDivFloat
    extends CalculatorCompiler {
        @Override
        public void compute(Generator ga, SourceLocator locator) {
            CalculatorCompiler.floatArithmetic(ga, 108);
        }
    }

    public static class FloatTimesFloat
    extends CalculatorCompiler {
        @Override
        public void compute(Generator ga, SourceLocator locator) {
            CalculatorCompiler.floatArithmetic(ga, 104);
        }
    }

    public static class FloatMinusFloat
    extends CalculatorCompiler {
        @Override
        public void compute(Generator ga, SourceLocator locator) {
            CalculatorCompiler.floatArithmetic(ga, 100);
        }
    }

    public static class FloatPlusFloat
    extends CalculatorCompiler {
        @Override
        public void compute(Generator ga, SourceLocator locator) {
            CalculatorCompiler.floatArithmetic(ga, 96);
        }
    }

    public static class DoubleModDouble
    extends CalculatorCompiler {
        @Override
        public void compute(Generator ga, SourceLocator locator) {
            ExpressionCompiler.visitAnnotation(this.compiler, "DoubleModDoubleCalculator-0");
            CalculatorCompiler.doubleArithmetic(ga, 112);
        }
    }

    public static class DoubleDivDouble
    extends CalculatorCompiler {
        @Override
        public void compute(Generator ga, SourceLocator locator) {
            ExpressionCompiler.visitAnnotation(this.compiler, "DoubleDivDoubleCalculator-0");
            CalculatorCompiler.doubleArithmetic(ga, 108);
        }
    }

    public static class DoubleTimesDouble
    extends CalculatorCompiler {
        @Override
        public void compute(Generator ga, SourceLocator locator) {
            ExpressionCompiler.visitAnnotation(this.compiler, "DoubleTimesDoubleCalculator-0");
            CalculatorCompiler.doubleArithmetic(ga, 104);
        }
    }

    public static class DoubleMinusDouble
    extends CalculatorCompiler {
        @Override
        public void compute(Generator ga, SourceLocator locator) {
            ExpressionCompiler.visitAnnotation(this.compiler, "DoubleMinusDoubleCalculator-0");
            CalculatorCompiler.doubleArithmetic(ga, 100);
        }
    }

    public static class DoublePlusDouble
    extends CalculatorCompiler {
        @Override
        public void compute(Generator ga, SourceLocator locator) {
            ExpressionCompiler.visitAnnotation(this.compiler, "DoublePlusDoubleCalculator-0");
            CalculatorCompiler.doubleArithmetic(ga, 96);
        }
    }

    public static class IntegerIdivInteger
    extends CalculatorCompiler {
        @Override
        public void compute(Generator ga, SourceLocator locator) {
            ExpressionCompiler.visitAnnotation(this.compiler, "IntIdivCalculator-0");
            ga.checkClass(IntegerValue.class);
            ga.swap();
            ga.checkClass(IntegerValue.class);
            ga.swap();
            ExpressionCompiler.allocateStatic(this.compiler, locator);
            ga.invokeInstanceMethod(IntegerValue.class, "idiv", IntegerValue.class, Location.class);
        }
    }

    public static class IntegerModInteger
    extends CalculatorCompiler {
        @Override
        public void compute(Generator ga, SourceLocator locator) {
            ExpressionCompiler.visitAnnotation(this.compiler, "IntModCalculator-0");
            ga.checkClass(IntegerValue.class);
            ga.swap();
            ga.checkClass(IntegerValue.class);
            ga.swap();
            ExpressionCompiler.allocateStatic(this.compiler, locator);
            ga.invokeInstanceMethod(IntegerValue.class, "mod", IntegerValue.class, Location.class);
        }
    }

    public static class IntegerDivInteger
    extends CalculatorCompiler {
        @Override
        public void compute(Generator ga, SourceLocator locator) {
            ExpressionCompiler.visitAnnotation(this.compiler, "IntDivCalculator-0");
            ga.checkClass(IntegerValue.class);
            ga.swap();
            ga.checkClass(IntegerValue.class);
            ga.swap();
            ExpressionCompiler.allocateStatic(this.compiler, locator);
            ga.invokeInstanceMethod(IntegerValue.class, "div", IntegerValue.class, Location.class);
        }
    }

    public static class IntegerTimesInteger
    extends CalculatorCompiler {
        @Override
        public void compute(Generator ga, SourceLocator locator) {
            ExpressionCompiler.visitAnnotation(this.compiler, "IntTimesCalculator-0");
            ga.checkClass(IntegerValue.class);
            ga.swap();
            ga.checkClass(IntegerValue.class);
            ga.invokeInstanceMethod(IntegerValue.class, "times", IntegerValue.class);
        }
    }

    public static class IntegerMinusInteger
    extends CalculatorCompiler {
        @Override
        public void compute(Generator ga, SourceLocator locator) {
            ExpressionCompiler.visitAnnotation(this.compiler, "IntMinusCalculator-0");
            ga.checkClass(IntegerValue.class);
            ga.swap();
            ga.checkClass(IntegerValue.class);
            ga.swap();
            ga.invokeInstanceMethod(IntegerValue.class, "minus", IntegerValue.class);
        }
    }

    public static class IntegerPlusInteger
    extends CalculatorCompiler {
        @Override
        public void compute(Generator ga, SourceLocator locator) {
            ExpressionCompiler.visitAnnotation(this.compiler, "IntPlusCalculator-0");
            ga.checkClass(IntegerValue.class);
            ga.swap();
            ga.checkClass(IntegerValue.class);
            ga.invokeInstanceMethod(IntegerValue.class, "plus", IntegerValue.class);
        }
    }
}

