/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToItemCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.IdentityComparison;
import net.sf.saxon.expr.sort.GlobalOrderComparer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;

public class IdentityComparisonCompiler
extends ToItemCompiler {
    @Override
    public void compileToItem(CompilerService compiler, Expression expression) throws CannotCompileException {
        Expression operand0 = ((IdentityComparison)expression).getLhsExpression();
        Expression operand1 = ((IdentityComparison)expression).getRhsExpression();
        boolean generateIdEmulation = ((IdentityComparison)expression).isGenerateIdEmulation();
        int operator = ((IdentityComparison)expression).getOperator();
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        IdentityComparisonCompiler.visitAnnotation(compiler, "IdentityComparison");
        compiler.compileToItem(operand0);
        ga.checkClass(NodeInfo.class);
        int operand0Var = methodInfo.allocateLocal(SequenceIterator.class);
        ga.storeLocal(operand0Var);
        LabelInfo notNull0 = methodInfo.newLabel("notNull0");
        LabelInfo notNull1 = methodInfo.newLabel("notNull1");
        LabelInfo end = methodInfo.newLabel("endIdCmp");
        LabelInfo trueLab = methodInfo.newLabel("trueLab");
        if (Cardinality.allowsZero(operand0.getCardinality()) && !generateIdEmulation) {
            ga.loadLocal(operand0Var);
            ga.ifNonNull(notNull0.label());
            ga.pushNull();
            ga.goTo(end);
            methodInfo.placeLabel(notNull0);
        }
        compiler.compileToItem(operand1);
        ga.checkClass(NodeInfo.class);
        int operand1Var = methodInfo.allocateLocal(SequenceIterator.class);
        ga.storeLocal(operand1Var);
        IdentityComparisonCompiler.visitLineNumber(compiler, ga, expression);
        if (Cardinality.allowsZero(operand1.getCardinality()) && !generateIdEmulation) {
            ga.loadLocal(operand1Var);
            ga.ifNonNull(notNull1.label());
            ga.pushNull();
            ga.goTo(end);
            methodInfo.placeLabel(notNull1);
        }
        if (generateIdEmulation) {
            LabelInfo firstIsNull = methodInfo.newLabel("firstIsNull");
            LabelInfo continueLab = methodInfo.newLabel("continueLab");
            ga.loadLocal(operand0Var);
            ga.ifNull(firstIsNull.label());
            ga.loadLocal(operand1Var);
            ga.ifNonNull(continueLab.label());
            ga.getStaticField(BooleanValue.class, "FALSE", BooleanValue.class);
            ga.goTo(end);
            methodInfo.placeLabel(firstIsNull);
            ga.loadLocal(operand1Var);
            ga.ifNull(trueLab.label());
            ga.getStaticField(BooleanValue.class, "FALSE", BooleanValue.class);
            ga.goTo(end);
            methodInfo.placeLabel(continueLab);
        }
        switch (operator) {
            case 20: {
                ga.loadLocal(operand0Var);
                ga.loadLocal(operand1Var);
                ga.invokeInstanceMethod(NodeInfo.class, "isSameNodeInfo", NodeInfo.class);
                ga.invokeStaticMethod(BooleanValue.class, "get", Boolean.TYPE);
                ga.goTo(end);
                break;
            }
            case 38: {
                ga.invokeStaticMethod(GlobalOrderComparer.class, "getInstance", new Class[0]);
                ga.loadLocal(operand0Var);
                ga.loadLocal(operand1Var);
                ga.invokeInstanceMethod(GlobalOrderComparer.class, "compare", Item.class, Item.class);
                ga.ifZCmp(155, trueLab.label());
                ga.getStaticField(BooleanValue.class, "FALSE", BooleanValue.class);
                ga.goTo(end);
                break;
            }
            case 39: {
                ga.invokeStaticMethod(GlobalOrderComparer.class, "getInstance", new Class[0]);
                ga.loadLocal(operand0Var);
                ga.loadLocal(operand1Var);
                ga.invokeInstanceMethod(GlobalOrderComparer.class, "compare", Item.class, Item.class);
                ga.ifZCmp(157, trueLab.label());
                ga.getStaticField(BooleanValue.class, "FALSE", BooleanValue.class);
                ga.goTo(end);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown node identity test");
            }
        }
        methodInfo.placeLabel(trueLab);
        ga.getStaticField(BooleanValue.class, "TRUE", BooleanValue.class);
        methodInfo.placeLabel(end);
        methodInfo.releaseLocal(operand0Var);
        methodInfo.releaseLocal(operand1Var);
    }

    @Override
    public void compileToBoolean(CompilerService compiler, Expression expression) throws CannotCompileException {
        Expression operand0 = ((IdentityComparison)expression).getLhsExpression();
        Expression operand1 = ((IdentityComparison)expression).getRhsExpression();
        boolean generateIdEmulation = ((IdentityComparison)expression).isGenerateIdEmulation();
        int operator = ((IdentityComparison)expression).getOperator();
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        IdentityComparisonCompiler.visitAnnotation(compiler, "IdentityComparison-Boolean");
        compiler.compileToItem(operand0);
        ga.checkClass(NodeInfo.class);
        int operand0Var = methodInfo.allocateLocal(SequenceIterator.class);
        ga.storeLocal(operand0Var);
        LabelInfo notNull0 = methodInfo.newLabel("notNull0");
        LabelInfo notNull1 = methodInfo.newLabel("notNull1");
        LabelInfo end = methodInfo.newLabel("endIdCmp");
        LabelInfo trueLab = methodInfo.newLabel("trueLab");
        if (Cardinality.allowsZero(operand0.getCardinality()) && !generateIdEmulation) {
            ga.loadLocal(operand0Var);
            ga.ifNonNull(notNull0.label());
            ga.push(false);
            ga.goTo(end);
            methodInfo.placeLabel(notNull0);
        }
        compiler.compileToItem(operand1);
        ga.checkClass(NodeInfo.class);
        int operand1Var = methodInfo.allocateLocal(SequenceIterator.class);
        ga.storeLocal(operand1Var);
        if (Cardinality.allowsZero(operand1.getCardinality()) && !generateIdEmulation) {
            ga.loadLocal(operand1Var);
            ga.ifNonNull(notNull1.label());
            ga.push(false);
            ga.goTo(end);
            methodInfo.placeLabel(notNull1);
        }
        if (generateIdEmulation) {
            LabelInfo firstIsNull = methodInfo.newLabel("firstIsNull");
            LabelInfo continueLab = methodInfo.newLabel("continueLab");
            ga.loadLocal(operand0Var);
            ga.ifNull(firstIsNull.label());
            ga.loadLocal(operand1Var);
            ga.ifNonNull(continueLab.label());
            ga.push(false);
            ga.goTo(end);
            methodInfo.placeLabel(firstIsNull);
            ga.loadLocal(operand1Var);
            ga.ifNull(trueLab.label());
            ga.push(false);
            ga.goTo(end);
            methodInfo.placeLabel(continueLab);
        }
        switch (operator) {
            case 20: {
                ga.loadLocal(operand0Var);
                ga.loadLocal(operand1Var);
                ga.invokeInstanceMethod(NodeInfo.class, "isSameNodeInfo", NodeInfo.class);
                ga.goTo(end);
                break;
            }
            case 38: {
                ga.invokeStaticMethod(GlobalOrderComparer.class, "getInstance", new Class[0]);
                ga.loadLocal(operand0Var);
                ga.loadLocal(operand1Var);
                ga.invokeInstanceMethod(GlobalOrderComparer.class, "compare", Item.class, Item.class);
                ga.ifZCmp(155, trueLab.label());
                ga.push(false);
                ga.goTo(end);
                break;
            }
            case 39: {
                ga.invokeStaticMethod(GlobalOrderComparer.class, "getInstance", new Class[0]);
                ga.loadLocal(operand0Var);
                ga.loadLocal(operand1Var);
                ga.invokeInstanceMethod(GlobalOrderComparer.class, "compare", Item.class, Item.class);
                ga.ifZCmp(157, trueLab.label());
                ga.push(false);
                ga.goTo(end);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown node identity test");
            }
        }
        methodInfo.placeLabel(trueLab);
        ga.push(true);
        methodInfo.placeLabel(end);
        methodInfo.releaseLocal(operand0Var);
        methodInfo.releaseLocal(operand1Var);
    }
}

