/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.CompiledExpression;
import com.saxonica.ee.bytecode.ToIteratorCompiler;
import com.saxonica.ee.bytecode.VariableReferenceCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.optim.SearchableValue;
import com.saxonica.ee.stream.Posture;
import com.saxonica.ee.stream.PostureAndSweep;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.objectweb.asm.Type;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.TailExpression;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.parser.Evaluator;
import net.sf.saxon.om.Chain;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ZeroOrOne;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Closure;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerRange;
import net.sf.saxon.value.MemoClosure;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SingletonClosure;

public class LetExpressionCompiler
extends ToIteratorCompiler {
    private int getEvaluatorCode(LetExpression expr) {
        Evaluator eval = expr.getEvaluator();
        if (eval == null) {
            return 8;
        }
        return eval.getCode();
    }

    @Override
    public void compileToItem(CompilerService compiler, Expression expression) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        LetExpressionCompiler.visitAnnotation(compiler, "LetExpressionCompiler - compileToItem");
        LetExpression letExpr = (LetExpression)expression;
        Expression action = letExpr.getAction();
        compiler.generateGetContext();
        ga.dup();
        ga.dup();
        ga.invokeInstanceMethod(XPathContext.class, "getTemporaryOutputState", new Class[0]);
        ga.swap();
        ga.push(206);
        ga.invokeInstanceMethod(XPathContext.class, "setTemporaryOutputState", Integer.TYPE);
        LetExpressionCompiler.compileCommonExpr(compiler, letExpr.getSequence(), this.getEvaluatorCode(letExpr), letExpr.getNominalReferenceCount());
        int valueRepVar = methodInfo.allocateLocal(Sequence.class);
        ga.storeLocal(valueRepVar);
        ga.invokeInstanceMethod(XPathContext.class, "setTemporaryOutputState", Integer.TYPE);
        compiler.generateGetContext();
        ga.push(letExpr.getLocalSlotNumber());
        ga.loadLocal(valueRepVar);
        ga.invokeInstanceMethod(XPathContext.class, "setLocalVariable", Integer.TYPE, Sequence.class);
        compiler.compileToItem(action);
        methodInfo.releaseLocal(valueRepVar);
    }

    @Override
    public void compileToPush(CompilerService compiler, Expression expression) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        LetExpressionCompiler.visitAnnotation(compiler, "LetExpressionCompiler - compileToPush");
        LetExpression letExpr = (LetExpression)expression;
        Expression action = letExpr.getAction();
        compiler.generateGetContext();
        ga.dup();
        ga.dup();
        ga.invokeInstanceMethod(XPathContext.class, "getTemporaryOutputState", new Class[0]);
        ga.swap();
        ga.push(206);
        ga.invokeInstanceMethod(XPathContext.class, "setTemporaryOutputState", Integer.TYPE);
        LetExpressionCompiler.compileCommonExpr(compiler, letExpr.getSequence(), this.getEvaluatorCode(letExpr), letExpr.getNominalReferenceCount());
        int valueRepVar = methodInfo.allocateLocal(Sequence.class);
        ga.storeLocal(valueRepVar);
        ga.invokeInstanceMethod(XPathContext.class, "setTemporaryOutputState", Integer.TYPE);
        compiler.generateGetContext();
        ga.push(letExpr.getLocalSlotNumber());
        ga.loadLocal(valueRepVar);
        ga.invokeInstanceMethod(XPathContext.class, "setLocalVariable", Integer.TYPE, Sequence.class);
        compiler.compileToPush(action);
    }

    @Override
    public void compileToIterator(CompilerService compiler, Expression expression) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        LetExpressionCompiler.visitAnnotation(compiler, "LetExpressionCompiler - compileToItr");
        LetExpression letExpr = (LetExpression)expression;
        Expression action = letExpr.getAction();
        compiler.generateGetContext();
        ga.dup();
        ga.dup();
        ga.invokeInstanceMethod(XPathContext.class, "getTemporaryOutputState", new Class[0]);
        ga.swap();
        ga.push(206);
        ga.invokeInstanceMethod(XPathContext.class, "setTemporaryOutputState", Integer.TYPE);
        LetExpressionCompiler.compileCommonExpr(compiler, letExpr.getSequence(), this.getEvaluatorCode(letExpr), letExpr.getNominalReferenceCount());
        int valueRepVar = methodInfo.allocateLocal(Sequence.class);
        ga.storeLocal(valueRepVar);
        ga.invokeInstanceMethod(XPathContext.class, "setTemporaryOutputState", Integer.TYPE);
        compiler.generateGetContext();
        ga.push(letExpr.getLocalSlotNumber());
        ga.loadLocal(valueRepVar);
        ga.invokeInstanceMethod(XPathContext.class, "setLocalVariable", Integer.TYPE, Sequence.class);
        compiler.compileToIterator(action);
    }

    public static void compileCommonExpr(CompilerService compiler, Expression exp, int evaluationMode, int refCount) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        LetExpressionCompiler.visitLineNumber(compiler, ga, exp);
        switch (evaluationMode) {
            case 0: {
                compiler.compileToSequence(exp);
                break;
            }
            case 1: {
                compiler.compileToSequence(exp);
                break;
            }
            case 3: {
                LetExpressionCompiler.makeClosure(compiler, exp, refCount, ga, methodInfo);
                break;
            }
            case 4: {
                LetExpressionCompiler.makeClosure(compiler, exp, refCount == 1 ? 10 : refCount, ga, methodInfo);
                break;
            }
            case 10: {
                TailExpression tail = (TailExpression)exp;
                VariableReference vr = (VariableReference)tail.getBaseExpression();
                LetExpressionCompiler.compileCommonExpr(compiler, vr, 1, refCount);
                ga.dup();
                int baseVar = methodInfo.allocateLocal(Sequence.class);
                ga.storeLocal(baseVar);
                LabelInfo notMemoLab = methodInfo.newLabel("notMemoLabel");
                LabelInfo notIntRangeLab = methodInfo.newLabel("notIntRangeLabel");
                LabelInfo notSeqLab = methodInfo.newLabel("notSeqExtLabel");
                LabelInfo end = methodInfo.newLabel("end_LAZY_TAIL_Label");
                ga.ifNotInstance(MemoClosure.class, notMemoLab);
                ga.loadLocal(baseVar);
                ga.invokeInstanceMethod(Sequence.class, "materialize", new Class[0]);
                ga.storeLocal(baseVar);
                methodInfo.placeLabel(notMemoLab);
                ga.loadLocal(baseVar);
                ga.ifNotInstance(IntegerRange.class, notIntRangeLab);
                ga.loadLocal(baseVar);
                ga.checkClass(IntegerRange.class);
                ga.dup();
                ga.invokeInstanceMethod(IntegerRange.class, "getStart", new Class[0]);
                ga.push((long)tail.getStart() - 1L);
                ga.math(96, Type.LONG_TYPE);
                int startVar = methodInfo.allocateLocal(Long.TYPE);
                ga.storeLocal(startVar);
                ga.invokeInstanceMethod(IntegerRange.class, "getEnd", new Class[0]);
                int endVar = methodInfo.allocateLocal(Long.TYPE);
                ga.storeLocal(endVar);
                LabelInfo notNELab = methodInfo.newLabel("notNELabel");
                ga.loadLocal(startVar);
                ga.loadLocal(endVar);
                ga.ifCmp(Type.LONG_TYPE, 154, notNELab.label());
                ga.loadLocal(endVar);
                ga.invokeStaticMethod(Int64Value.class, "makeIntegerValue", Long.TYPE);
                ga.goTo(end);
                methodInfo.placeLabel(notNELab);
                ga.loadLocal(startVar);
                ga.loadLocal(endVar);
                LabelInfo notGTLab = methodInfo.newLabel("notGTLabel");
                ga.ifCmp(Type.LONG_TYPE, 155, notGTLab.label());
                ga.invokeStaticMethod(EmptySequence.class, "getInstance", new Class[0]);
                ga.goTo(end);
                methodInfo.placeLabel(notGTLab);
                ga.newInstance(IntegerRange.class);
                ga.dup();
                ga.loadLocal(startVar);
                ga.loadLocal(endVar);
                ga.invokeConstructor(IntegerRange.class, Long.TYPE, Long.TYPE);
                ga.goTo(end);
                methodInfo.releaseLocal(startVar);
                methodInfo.releaseLocal(endVar);
                ga.goTo(end);
                methodInfo.placeLabel(notIntRangeLab);
                ga.loadLocal(baseVar);
                ga.ifNotInstance(SequenceExtent.class, notSeqLab);
                ga.newInstance(SequenceExtent.class);
                ga.dup();
                ga.loadLocal(baseVar);
                ga.checkClass(SequenceExtent.class);
                ga.dup();
                ga.push(tail.getStart() - 1);
                ga.swap();
                ga.invokeInstanceMethod(SequenceExtent.class, "getLength", new Class[0]);
                ga.push(tail.getStart());
                ga.math(100, Type.INT_TYPE);
                ga.push(1);
                ga.math(96, Type.INT_TYPE);
                ga.invokeConstructor(SequenceExtent.class, SequenceExtent.class, Integer.TYPE, Integer.TYPE);
                ga.invokeInstanceMethod(SequenceExtent.class, "reduce", new Class[0]);
                ga.goTo(end);
                methodInfo.placeLabel(notSeqLab);
                LetExpressionCompiler.visitAnnotation(compiler, "Closure, refCount:" + refCount);
                compiler.generateGetContext();
                ga.invokeInstanceMethod(XPathContext.class, "getConfiguration", new Class[0]);
                int configVar = methodInfo.allocateLocal(Configuration.class);
                ga.storeLocal(configVar);
                CompiledExpression compiledExpr = compiler.compileToByteCode(exp, "", 2);
                if (compiledExpr == null) {
                    throw new CannotCompileException(exp);
                }
                ga.loadLocal(configVar);
                LetExpressionCompiler.allocateStatic(compiler, compiledExpr);
                refCount = refCount == 1 ? 10 : refCount;
                ga.push(refCount);
                compiler.generateGetContext();
                ga.invokeInstanceMethod(Configuration.class, "makeClosure", Expression.class, Integer.TYPE, XPathContext.class);
                ga.dup();
                ga.instanceOf(Type.getType(Closure.class));
                LabelInfo notClosure = methodInfo.newLabel("notclosure");
                ga.ifFalse(notClosure);
                ga.showMessage(compiler, "created closure");
                ga.checkClass(Closure.class);
                int closureVar = methodInfo.allocateLocal(Closure.class);
                ga.storeLocal(closureVar);
                ga.loadLocal(closureVar);
                LetExpressionCompiler.allocateStatic(compiler, compiledExpr);
                LetExpressionCompiler.visitLineNumber(compiler, ga, exp);
                ga.invokeInstanceMethod(Closure.class, "setExpression", Expression.class);
                ga.loadLocal(closureVar);
                compiler.generateGetContext();
                ga.invokeInstanceMethod(XPathContext.class, "newContext", new Class[0]);
                ga.invokeInstanceMethod(Closure.class, "setSavedXPathContext", XPathContextMajor.class);
                ga.loadLocal(closureVar);
                LetExpressionCompiler.allocateStatic(compiler, compiledExpr);
                compiler.generateGetContext();
                ga.invokeInstanceMethod(Closure.class, "saveContext", Expression.class, XPathContext.class);
                ga.loadLocal(closureVar);
                methodInfo.placeLabel(notClosure);
                methodInfo.placeLabel(end);
                ga.checkClass(Sequence.class);
                methodInfo.releaseLocal(configVar);
                methodInfo.releaseLocal(closureVar);
                methodInfo.releaseLocal(baseVar);
                break;
            }
            case 13: {
                CompiledExpression compiledExpr = compiler.compileToByteCode(exp, "", 2);
                if (compiledExpr == null) {
                    throw new CannotCompileException(exp);
                }
                ga.newInstance(Type.getType(SingletonClosure.class));
                ga.dup();
                LetExpressionCompiler.allocateStatic(compiler, compiledExpr);
                compiler.generateGetContext();
                ga.invokeConstructor(SingletonClosure.class, Expression.class, XPathContext.class);
                break;
            }
            case 5: {
                ga.invokeStaticMethod(EmptySequence.class, "getInstance", new Class[0]);
                ga.checkClass(Sequence.class);
                break;
            }
            case 6: {
                LabelInfo doneEvalMaterialize = methodInfo.newLabel("doneEvalMaterialize");
                VariableReferenceCompiler.genEvaluateVariable(compiler, ga, (VariableReference)exp);
                ga.dup();
                ga.ifNotInstance(Closure.class, doneEvalMaterialize);
                ga.checkCast(Type.getType(Closure.class));
                ga.invokeInstanceMethod(Closure.class, "iterate", new Class[0]);
                ga.invokeInstanceMethod(SequenceIterator.class, "materialize", new Class[0]);
                methodInfo.placeLabel(doneEvalMaterialize);
                break;
            }
            case 7: {
                LetExpressionCompiler.visitLineNumber(compiler, ga, exp);
                compiler.compileToItem(exp);
                LabelInfo notNullLab = methodInfo.newLabel("notNullLab");
                ga.dup();
                ga.ifNonNull(notNullLab.label());
                ga.pop();
                ga.invokeStaticMethod(EmptySequence.class, "getInstance", new Class[0]);
                ga.checkClass(Sequence.class);
                methodInfo.placeLabel(notNullLab);
                break;
            }
            case 16: {
                LetExpressionCompiler.visitLineNumber(compiler, ga, exp);
                compiler.compileToItem(exp);
                break;
            }
            case -1: 
            case 8: {
                if (refCount == 10000) {
                    LetExpressionCompiler.visitLineNumber(compiler, ga, exp);
                    compiler.compileToIterator(exp);
                    ga.invokeStaticMethod(SearchableValue.class, "makeSearchableValue", SequenceIterator.class);
                    break;
                }
                LetExpressionCompiler.visitLineNumber(compiler, ga, exp);
                compiler.compileToIterator(exp);
                ga.invokeInstanceMethod(SequenceIterator.class, "materialize", new Class[0]);
                break;
            }
            case 9: {
                compiler.generateGetContext();
                ga.invokeInstanceMethod(XPathContext.class, "getController", new Class[0]);
                int conVar = methodInfo.allocateLocal(Controller.class);
                ga.storeLocal(conVar);
                ga.loadLocal(conVar);
                ga.invokeInstanceMethod(Controller.class, "allocateSequenceOutputter", new Class[0]);
                ga.dup();
                ga.loadLocal(conVar);
                ga.invokeInstanceMethod(Controller.class, "makePipelineConfiguration", new Class[0]);
                ga.dup();
                ga.push(exp.getPackageData().getHostLanguage());
                ga.invokeInstanceMethod(PipelineConfiguration.class, "setHostLanguage", Integer.TYPE);
                ga.invokeInstanceMethod(SequenceOutputter.class, "setPipelineConfiguration", PipelineConfiguration.class);
                compiler.pushNewReceiverInfo(ga);
                compiler.generateGetReceiver();
                ga.invokeInstanceMethod(SequenceOutputter.class, "open", new Class[0]);
                compiler.compileToPush(exp);
                compiler.generateGetReceiver();
                ga.invokeInstanceMethod(SequenceOutputter.class, "close", new Class[0]);
                compiler.generateGetReceiver();
                ga.invokeInstanceMethod(SequenceOutputter.class, "getSequence", new Class[0]);
                compiler.generateGetReceiver();
                ga.invokeInstanceMethod(SequenceOutputter.class, "reset", new Class[0]);
                compiler.popReceiverInfo();
                methodInfo.releaseLocal(conVar);
                break;
            }
            case 11: {
                if (!(exp instanceof Block)) break;
                Block block = (Block)exp;
                Operand[] children = block.getOperanda();
                ga.newInstance(Chain.class);
                ga.dup();
                ga.newInstance(ArrayList.class);
                ga.dup();
                ga.push(children.length);
                ga.invokeConstructor(ArrayList.class, Integer.TYPE);
                for (Operand o : children) {
                    Expression child = o.getChildExpression();
                    if (Cardinality.allowsMany(child.getCardinality())) {
                        ga.dup();
                        compiler.compileToIterator(child);
                        ga.invokeInstanceMethod(SequenceIterator.class, "materialize", new Class[0]);
                        ga.invokeInstanceMethod(List.class, "add", Object.class);
                        ga.pop();
                        continue;
                    }
                    ga.dup();
                    compiler.compileToItem(child);
                    if (Cardinality.allowsZero(child.getCardinality())) {
                        LabelInfo itemNull = methodInfo.newLabel("itemNull");
                        LabelInfo itemDone = methodInfo.newLabel("itemDone");
                        LabelInfo groundedLab = methodInfo.newLabel("groundedLab");
                        ga.dup();
                        ga.ifNull(itemNull.label());
                        ga.dup();
                        ga.ifInstance(GroundedValue.class, groundedLab);
                        ga.newInstance(ZeroOrOne.class);
                        ga.dup2();
                        ga.swap();
                        ga.invokeConstructor(ZeroOrOne.class, Item.class);
                        ga.swap();
                        ga.pop();
                        methodInfo.placeLabel(groundedLab);
                        ga.invokeInstanceMethod(List.class, "add", Object.class);
                        ga.pop();
                        ga.goTo(itemDone.label());
                        methodInfo.placeLabel(itemNull);
                        ga.pop();
                        ga.pop();
                        methodInfo.placeLabel(itemDone);
                        continue;
                    }
                    ga.dup();
                    LabelInfo groundedLab = methodInfo.newLabel("groundedLab");
                    ga.ifInstance(GroundedValue.class, groundedLab);
                    ga.newInstance(ZeroOrOne.class);
                    ga.dup2();
                    ga.swap();
                    ga.invokeConstructor(ZeroOrOne.class, Item.class);
                    ga.swap();
                    ga.pop();
                    methodInfo.placeLabel(groundedLab);
                    ga.invokeInstanceMethod(List.class, "add", Object.class);
                    ga.pop();
                }
                ga.invokeConstructor(Chain.class, List.class);
                break;
            }
            case 12: {
                compiler.compileToIterator(exp);
                ga.invokeStaticMethod(SearchableValue.class, "makeSearchableValue", SequenceIterator.class);
                break;
            }
            case 15: {
                PostureAndSweep ps = Streamability.getPostureAndSweepIfKnown(exp);
                if (ps == null || ps.getPosture() == Posture.GROUNDED) {
                    LetExpressionCompiler.visitLineNumber(compiler, ga, exp);
                    compiler.compileToIterator(exp);
                    ga.invokeStaticMethod(SequenceExtent.class, "makeSequenceExtent", SequenceIterator.class);
                    break;
                }
                LetExpressionCompiler.allocateStatic(compiler, EmptySequence.getInstance());
                break;
            }
            default: {
                throw new CannotCompileException(exp);
            }
        }
    }

    private static void makeClosure(CompilerService compiler, Expression exp, int refCount, Generator ga, GeneratedMethodInfo methodInfo) throws CannotCompileException {
        if (refCount == 10000) {
            LetExpressionCompiler.allocateStatic(compiler, exp);
            compiler.generateGetContext();
            ga.push(refCount);
            ga.invokeStaticMethod(Closure.class, "make", Expression.class, XPathContext.class, Integer.TYPE);
        } else {
            int closureVar = -1;
            if (refCount == 1) {
                ga.invokeDefaultConstructor(Closure.class);
                closureVar = methodInfo.allocateLocal(Closure.class);
            } else {
                ga.invokeDefaultConstructor(MemoClosure.class);
                closureVar = methodInfo.allocateLocal(MemoClosure.class);
            }
            ga.storeLocal(closureVar);
            ga.loadLocal(closureVar);
            ga.dup();
            CompiledExpression compiledExpr = compiler.compileToByteCode(exp, "", 2);
            if (compiledExpr == null) {
                throw new CannotCompileException(exp);
            }
            LetExpressionCompiler.allocateStatic(compiler, compiledExpr);
            ga.dupX1();
            ga.invokeInstanceMethod(Closure.class, "setExpression", Expression.class);
            ga.loadLocal(closureVar);
            compiler.generateGetContext();
            ga.invokeInstanceMethod(XPathContext.class, "newContext", new Class[0]);
            ga.dupX1();
            ga.invokeInstanceMethod(Closure.class, "setSavedXPathContext", XPathContextMajor.class);
            ga.invokeInstanceMethod(Closure.class, "saveContext", Expression.class, XPathContext.class);
            ga.loadLocal(closureVar);
            methodInfo.releaseLocal(closureVar);
        }
    }
}

