/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToItemCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.bytecode.util.OnEmpty;
import com.saxonica.objectweb.asm.Type;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.PositionAndLast;
import net.sf.saxon.om.FocusIterator;

public class PositionCompiler
extends ToItemCompiler {
    @Override
    public void compileToPrimitive(CompilerService compiler, Expression expression, Class requiredClass, OnEmpty onEmpty) {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        PositionCompiler.visitAnnotation(compiler, "PositionCompiler-Int");
        PositionCompiler.visitLineNumber(compiler, ga, expression);
        SystemFunctionCall sfc = (SystemFunctionCall)expression;
        PositionAndLast.Position fn = (PositionAndLast.Position)sfc.getTargetFunction();
        if (fn.isContextPossiblyUndefined()) {
            compiler.generateGetContext();
            ga.invokeInstanceMethod(XPathContext.class, "getContextItem", new Class[0]);
            LabelInfo lab = methodInfo.newLabel("lab");
            ga.ifNonNull(lab.label());
            compiler.generateDynamicError("Context position is absent", "XPDY0002", expression.getLocation(), false);
            methodInfo.placeLabel(lab);
        }
        compiler.generateGetContext();
        ga.invokeInstanceMethod(XPathContext.class, "getCurrentIterator", new Class[0]);
        ga.invokeInstanceMethod(FocusIterator.class, "position", new Class[0]);
        if (requiredClass == Long.TYPE) {
            ga.cast(Type.INT_TYPE, Type.LONG_TYPE);
        }
    }

    @Override
    public void compileToItem(CompilerService compiler, Expression expression) throws CannotCompileException {
        this.compileItemFromInt(compiler, expression);
    }
}

