/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.serialize;

import com.saxonica.serialize.DecimalCharacterReferenceGenerator;
import java.io.IOException;
import net.sf.saxon.serialize.CharacterReferenceGenerator;
import net.sf.saxon.serialize.HexCharacterReferenceGenerator;
import net.sf.saxon.str.UnicodeWriter;

public class HTMLEntityReferenceGenerator
implements CharacterReferenceGenerator {
    private static final String[] latin1Entities = new String[]{"nbsp", "iexcl", "cent", "pound", "curren", "yen", "brvbar", "sect", "uml", "copy", "ordf", "laquo", "not", "shy", "reg", "macr", "deg", "plusmn", "sup2", "sup3", "acute", "micro", "para", "middot", "cedil", "sup1", "ordm", "raquo", "frac14", "frac12", "frac34", "iquest", "Agrave", "Aacute", "Acirc", "Atilde", "Auml", "Aring", "AElig", "Ccedil", "Egrave", "Eacute", "Ecirc", "Euml", "Igrave", "Iacute", "Icirc", "Iuml", "ETH", "Ntilde", "Ograve", "Oacute", "Ocirc", "Otilde", "Ouml", "times", "Oslash", "Ugrave", "Uacute", "Ucirc", "Uuml", "Yacute", "THORN", "szlig", "agrave", "aacute", "acirc", "atilde", "auml", "aring", "aelig", "ccedil", "egrave", "eacute", "ecirc", "euml", "igrave", "iacute", "icirc", "iuml", "eth", "ntilde", "ograve", "oacute", "ocirc", "otilde", "ouml", "divide", "oslash", "ugrave", "uacute", "ucirc", "uuml", "yacute", "thorn", "yuml"};
    public static final HTMLEntityReferenceGenerator HEX = new HTMLEntityReferenceGenerator(HexCharacterReferenceGenerator.THE_INSTANCE);
    public static final HTMLEntityReferenceGenerator DECIMAL = new HTMLEntityReferenceGenerator(DecimalCharacterReferenceGenerator.THE_INSTANCE);
    private final CharacterReferenceGenerator fallback;

    private HTMLEntityReferenceGenerator(CharacterReferenceGenerator fallback) {
        this.fallback = fallback;
    }

    @Override
    public void outputCharacterReference(int c, UnicodeWriter writer) throws IOException {
        if (c > 160 && c <= 255) {
            writer.writeCodePoint(38);
            writer.write(latin1Entities[c - 160]);
            writer.writeCodePoint(59);
        } else {
            this.fallback.outputCharacterReference(c, writer);
        }
    }
}

