/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query;

import de.ids_mannheim.korap.query.SimpleSpanQuery;
import de.ids_mannheim.korap.query.spans.ExpandedExclusionSpans;
import de.ids_mannheim.korap.query.spans.ExpandedSpans;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.Bits;

public class SpanExpansionQuery
extends SimpleSpanQuery {
    private int min;
    private int max;
    private byte classNumber;
    private int direction;
    final boolean isExclusion;

    public SpanExpansionQuery(SpanQuery firstClause, int min, int max, int direction, boolean collectPayloads) {
        super(firstClause, collectPayloads);
        if (max < min) {
            throw new IllegalArgumentException("The max position has to be bigger than or the same as min position.");
        }
        this.min = min;
        this.max = max;
        this.direction = direction;
        this.isExclusion = false;
    }

    public SpanExpansionQuery(SpanQuery firstClause, int min, int max, int direction, byte classNumber, boolean collectPayloads) {
        this(firstClause, min, max, direction, collectPayloads);
        this.classNumber = classNumber;
    }

    public SpanExpansionQuery(SpanQuery firstClause, SpanQuery notClause, int min, int max, int direction, boolean collectPayloads) {
        super(firstClause, notClause, collectPayloads);
        if (max < min) {
            throw new IllegalArgumentException("The max position has to be bigger than or the same as min position.");
        }
        this.min = min;
        this.max = max;
        this.direction = direction;
        this.isExclusion = true;
    }

    public SpanExpansionQuery(SpanQuery firstClause, SpanQuery notClause, int min, int max, int direction, byte classNumber, boolean collectPayloads) {
        this(firstClause, notClause, min, max, direction, collectPayloads);
        this.classNumber = classNumber;
    }

    @Override
    public SimpleSpanQuery clone() {
        SpanExpansionQuery sq = null;
        sq = this.isExclusion ? new SpanExpansionQuery(this.firstClause, this.secondClause, this.min, this.max, this.direction, this.classNumber, this.collectPayloads) : new SpanExpansionQuery(this.firstClause, this.min, this.max, this.direction, this.classNumber, this.collectPayloads);
        return sq;
    }

    @Override
    public Spans getSpans(LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts) throws IOException {
        if (this.isExclusion) {
            return new ExpandedExclusionSpans(this, context, acceptDocs, termContexts);
        }
        return new ExpandedSpans(this, context, acceptDocs, termContexts);
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("spanExpansion(");
        sb.append(this.firstClause.toString());
        if (this.isExclusion && this.secondClause != null) {
            sb.append(", !");
            sb.append(this.secondClause.toString());
        } else {
            sb.append(", []");
        }
        sb.append("{");
        sb.append(this.min);
        sb.append(", ");
        sb.append(this.max);
        sb.append("}, ");
        if (this.direction < 0) {
            sb.append("left");
        } else {
            sb.append("right");
        }
        if (this.classNumber > 0) {
            sb.append(", class:");
            sb.append(this.classNumber);
        }
        sb.append(")");
        return sb.toString();
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = min;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public byte getClassNumber() {
        return this.classNumber;
    }

    public void setClassNumber(byte classNumber) {
        this.classNumber = classNumber;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }
}

