/*
 * Decompiled with CFR 0.152.
 */
package experimental.igel;

import experimental.igel.BinaryFactor;
import experimental.igel.Message;
import experimental.igel.SegmentVariable;
import experimental.igel.SemiMarkovFactor;
import experimental.igel.UnaryFactor;
import experimental.igel.Word;
import java.util.ArrayList;
import java.util.List;
import org.javatuples.Pair;

public class FactorGraph {
    private List<SegmentVariable> variables = new ArrayList<SegmentVariable>();
    private List<UnaryFactor> unaryFactors = new ArrayList<UnaryFactor>();
    private List<BinaryFactor> binaryFactors = new ArrayList<BinaryFactor>();
    private SemiMarkovFactor globalFactor;
    private int numVariables = 0;

    public FactorGraph(Word word) {
        for (Pair<Integer, Integer> key : word.getPos2String().keySet()) {
            int startPos = (Integer)key.getValue0();
            int endPos = (Integer)key.getValue1();
            String segment = word.getPos2String().get(key);
            ++this.numVariables;
            this.variables.add(new SegmentVariable(segment, startPos, endPos));
        }
        for (SegmentVariable sv : this.variables) {
            UnaryFactor uf = new UnaryFactor();
            uf.getNeighbors().add(sv);
            uf.getMessageIds().add(sv.getMessages().size());
            sv.getMessages().add(new Message(2));
            this.unaryFactors.add(uf);
        }
        for (SegmentVariable sv1 : this.variables) {
            for (SegmentVariable sv2 : this.variables) {
                if (sv1.getEndPos() != sv2.getStartPos()) continue;
                System.out.println(sv1.getSegment() + "\t" + sv2.getSegment());
                BinaryFactor bf = new BinaryFactor();
                bf.getNeighbors().add(sv1);
                bf.getMessageIds().add(sv1.getMessages().size());
                sv1.getMessages().add(new Message(2));
                bf.getNeighbors().add(sv2);
                bf.getMessageIds().add(sv2.getMessages().size());
                sv2.getMessages().add(new Message(2));
                this.binaryFactors.add(bf);
            }
        }
    }

    public void inferenceBP(int maxIterations, double convergence) {
        for (int iterNum = 0; iterNum < maxIterations; ++iterNum) {
            for (UnaryFactor uf : this.unaryFactors) {
                uf.passMessages();
            }
            for (BinaryFactor bf : this.binaryFactors) {
                bf.passMessages();
            }
            for (SegmentVariable sv : this.variables) {
                sv.passMessages();
            }
        }
    }

    public void inferenceBruteForce() {
        int i = 0;
        while ((double)i < Math.pow(2.0, this.numVariables)) {
            double configurationScore = 1.0;
            String format = "%0" + this.numVariables + "d";
            String newString = String.format(format, Integer.valueOf(Integer.toBinaryString(i)));
            System.out.println(newString);
            ++i;
        }
    }
}

