/*
 * Decompiled with CFR 0.152.
 */
package marmot.morph.mapper.spanish;

import java.util.HashSet;
import java.util.Set;
import marmot.morph.mapper.MorphTag;
import marmot.morph.mapper.Node;

public class EaglesTag
implements MorphTag {
    Pos pos_;
    Type type_;
    Degree degree_;
    Gender gender_;
    Number number_;
    Function function_;
    Mood mood_;
    Tense tense_;
    Person person_;
    Case case_;
    OwnerNumber owner_;
    Politeness politeness_;
    Form form_;
    Closing closing_;
    NounDegree noun_degree_;
    private static final Set<String> numbers = new HashSet<String>();

    public EaglesTag() {
        this.reset();
    }

    public void reset() {
        this.pos_ = Pos._x;
        this.type_ = Type._x;
        this.degree_ = Degree._x;
        this.gender_ = Gender._x;
        this.number_ = Number._x;
        this.function_ = Function._x;
        this.mood_ = Mood._x;
        this.tense_ = Tense._x;
        this.person_ = Person._x;
        this.case_ = Case._x;
        this.owner_ = OwnerNumber._x;
        this.politeness_ = Politeness._x;
        this.form_ = Form._x;
        this.closing_ = Closing._x;
        this.noun_degree_ = NounDegree._x;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.pos_);
        sb.append((Object)this.type_);
        sb.append((Object)this.degree_);
        sb.append((Object)this.gender_);
        sb.append((Object)this.number_);
        sb.append((Object)this.function_);
        sb.append((Object)this.mood_);
        sb.append((Object)this.tense_);
        sb.append((Object)this.person_);
        sb.append((Object)this.case_);
        sb.append((Object)this.owner_);
        sb.append((Object)this.politeness_);
        sb.append((Object)this.form_);
        sb.append((Object)this.closing_);
        sb.append((Object)this.noun_degree_);
        return sb.toString();
    }

    @Override
    public String toHumanMorphString() {
        StringBuilder sb = new StringBuilder();
        this.addFeature(sb, "type", this.type_ == Type._x, this.type_.toString());
        this.addFeature(sb, "deg", this.degree_ == Degree._x, this.degree_.toString());
        this.addFeature(sb, "num", this.number_ == Number._x, this.number_.toString());
        this.addFeature(sb, "gen", this.gender_ == Gender._x, this.gender_.toString());
        this.addFeature(sb, "fun", this.function_ == Function._x, this.function_.toString());
        this.addFeature(sb, "mood", this.mood_ == Mood._x, this.mood_.toString());
        this.addFeature(sb, "ten", this.tense_ == Tense._x, this.tense_.toString());
        this.addFeature(sb, "per", this.person_ == Person._x, this.person_.toString());
        this.addFeature(sb, "cas", this.case_ == Case._x, this.case_.toString());
        this.addFeature(sb, "onu", this.owner_ == OwnerNumber._x, this.owner_.toString());
        this.addFeature(sb, "pol", this.politeness_ == Politeness._x, this.politeness_.toString());
        this.addFeature(sb, "form", this.form_ == Form._x, this.form_.toString());
        this.addFeature(sb, "onu", this.closing_ == Closing._x, this.closing_.toString());
        this.addFeature(sb, "ndeg", this.noun_degree_ == NounDegree._x, this.noun_degree_.toString());
        if (sb.length() == 0) {
            return "_";
        }
        return sb.toString();
    }

    public String toHumanString() {
        StringBuilder sb = new StringBuilder();
        this.addFeature(sb, "", false, this.pos_.toString());
        sb.append("|");
        sb.append(this.toHumanMorphString());
        return sb.toString();
    }

    private void addFeature(StringBuilder sb, String name, boolean b, String value) {
        if (!b) {
            switch (value) {
                case "first": {
                    value = "1";
                    break;
                }
                case "second": {
                    value = "2";
                    break;
                }
                case "third": {
                    value = "3";
                    break;
                }
            }
            if (sb.length() > 0) {
                sb.append('|');
            }
            if (name.length() > 0) {
                sb.append(name.toLowerCase());
                sb.append('=');
            }
            sb.append(value);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void normalize(Node node, boolean iula) {
        form = node.getForm();
        this.degree_ = Degree._x;
        this.noun_degree_ = NounDegree._x;
        if (form.equals("se")) {
            this.reset();
            this.pos_ = Pos.p;
            this.type_ = Type.r;
            this.number_ = Number.n;
            this.gender_ = Gender.c;
            this.person_ = Person.third;
            return;
        }
        switch (1.$SwitchMap$marmot$morph$mapper$spanish$EaglesTag$Pos[this.pos_.ordinal()]) {
            case 1: {
                if (this.function_ != Function.p) break;
                this.pos_ = Pos.v;
                this.function_ = Function._x;
                this.mood_ = Mood.p;
                this.type_ = Type.m;
                break;
            }
            case 2: 
            case 3: {
                if (!EaglesTag.numbers.contains(form)) break;
                this.reset();
                this.pos_ = Pos.z;
                break;
            }
            case 4: {
                this.reset();
                this.pos_ = Pos.s;
                this.type_ = Type.p;
                this.form_ = Form.s;
                break;
            }
            case 5: {
                if (this.type_ != Type.p) break;
                this.reset();
                this.pos_ = Pos.n;
                this.type_ = Type.p;
                break;
            }
            case 6: {
                if (this.gender_ == Gender.c) {
                    this.gender_ = Gender._x;
                }
                if (this.number_ == Number.n) {
                    this.number_ = Number._x;
                }
                if (node.getLemma().equals("ser")) {
                    this.type_ = Type.s;
                    break;
                }
                if (!node.getLemma().equals("estar")) break;
                found_gerund = false;
                if (iula) ** GOTO lbl54
                head = node.getHead();
                if (head == null) ** GOTO lbl59
                tag = (EaglesTag)head.getMorphTag();
                if (tag.pos_ == Pos.v && tag.mood_ == Mood.g) {
                    found_gerund = true;
                }
                ** GOTO lbl59
lbl54:
                // 2 sources

                for (Node child : node.getChildren()) {
                    tag = (EaglesTag)child.getMorphTag();
                    if (tag.pos_ != Pos.v || tag.mood_ != Mood.g) continue;
                    found_gerund = true;
                    break;
                }
lbl59:
                // 4 sources

                if (found_gerund) {
                    this.type_ = Type.a;
                    break;
                }
                this.type_ = Type.m;
                break;
            }
            case 7: {
                if (this.type_ == Type.n) {
                    this.reset();
                    this.pos_ = Pos.r;
                    this.type_ = Type.n;
                    break;
                }
                this.pos_ = Pos.r;
                this.type_ = Type.g;
                break;
            }
        }
    }

    @Override
    public String toPosString() {
        return this.pos_.toString();
    }

    static {
        numbers.add("catorce");
        numbers.add("cero");
        numbers.add("cien");
        numbers.add("cien_mil");
        numbers.add("cien_por_cien");
        numbers.add("cien_por_ciento");
        numbers.add("ciento_ochenta");
        numbers.add("ciento_sesenta_mil_millones");
        numbers.add("ciento_setenta_y_ocho");
        numbers.add("cinco");
        numbers.add("cinco_mil");
        numbers.add("cinco_mil_millones");
        numbers.add("cinco_por_ciento");
        numbers.add("cincuenta");
        numbers.add("cincuenta_por_ciento");
        numbers.add("cincuenta_y_dos");
        numbers.add("cincuenta_y_uno");
        numbers.add("cuarenta");
        numbers.add("cuarenta_y_cinco");
        numbers.add("cuarenta_y_dos");
        numbers.add("cuarenta_y_ocho");
        numbers.add("cuatro");
        numbers.add("cuatro_de_cada_diez");
        numbers.add("cuatro_millones");
        numbers.add("cuatro_mil_millones");
        numbers.add("cuatro_por_ciento");
        numbers.add("cuatro_por_mil");
        numbers.add("diecinueve");
        numbers.add("dieciocho");
        numbers.add("diecis\u00e9is");
        numbers.add("diecisiete");
        numbers.add("diez");
        numbers.add("diez_mil");
        numbers.add("diez_millones");
        numbers.add("diez_por_ciento");
        numbers.add("doce");
        numbers.add("dos");
        numbers.add("doscientas_cincuenta");
        numbers.add("dos_millones");
        numbers.add("dos_mil_millones");
        numbers.add("dos_mil_quinientas");
        numbers.add("dos_por_ciento");
        numbers.add("dos_por_mil");
        numbers.add("media_docena");
        numbers.add("mil");
        numbers.add("mil_millones");
        numbers.add("mil_seiscientas");
        numbers.add("noventa");
        numbers.add("noventa_por_ciento");
        numbers.add("nueve");
        numbers.add("nueve_de_cada_diez");
        numbers.add("nueve_mil");
        numbers.add("ochenta");
        numbers.add("ocho");
        numbers.add("ocho_de_cada_diez");
        numbers.add("ocho_por_ciento");
        numbers.add("once");
        numbers.add("quince");
        numbers.add("quince_por_ciento");
        numbers.add("quinientas");
        numbers.add("quinientos_mil");
        numbers.add("quinientos_un");
        numbers.add("seis");
        numbers.add("seis_millones");
        numbers.add("seis_por_ciento");
        numbers.add("sesenta");
        numbers.add("sesenta_y_cinco");
        numbers.add("sesenta_y_nueve");
        numbers.add("sesenta_y_ocho");
        numbers.add("sesenta_y_seis");
        numbers.add("sesenta_y_siete");
        numbers.add("sesenta_y_un");
        numbers.add("setenta");
        numbers.add("siete");
        numbers.add("siete_mil");
        numbers.add("siete_por_ciento");
        numbers.add("tanto_por_ciento");
        numbers.add("treinta");
        numbers.add("treinta_mil_millones");
        numbers.add("tres");
        numbers.add("trescientas_sesenta_y_cinco");
        numbers.add("trescientos_doce");
        numbers.add("tres_de_cada_cuatro");
        numbers.add("tres_mil");
        numbers.add("tres_millones");
        numbers.add("tres_mil_millones");
        numbers.add("tres_por_ciento");
        numbers.add("un");
        numbers.add("una");
        numbers.add("una_de_cada_cuatro");
        numbers.add("una_docena");
        numbers.add("un_centenar");
        numbers.add("un_millar");
        numbers.add("un_mill\u00f3n");
        numbers.add("uno");
        numbers.add("uno_de_cada_diez");
        numbers.add("uno_por_ciento");
        numbers.add("veinte");
        numbers.add("veinte_mil");
        numbers.add("veinte_mil_millones");
        numbers.add("veinte_por_ciento");
        numbers.add("veinticinco");
        numbers.add("veinticinco_mil");
        numbers.add("veinticinco_mil_millones");
        numbers.add("veinticuatro");
        numbers.add("veintitr\u00e9s");
        numbers.add("veintiuno");
    }

    static enum Pos {
        a,
        c,
        d,
        f,
        i,
        n,
        p,
        r,
        s,
        v,
        w,
        z,
        _x;

    }

    static enum Type {
        a,
        c,
        d,
        e,
        g,
        h,
        i,
        t,
        m,
        n,
        o,
        p,
        q,
        r,
        s,
        x,
        z,
        _x;

    }

    static enum Degree {
        c,
        s,
        _x;

    }

    static enum Gender {
        m,
        f,
        n,
        c,
        _x;

    }

    static enum Number {
        s,
        p,
        n,
        _x;

    }

    static enum Function {
        p,
        _x;

    }

    static enum Mood {
        i,
        s,
        m,
        n,
        g,
        p,
        _x;

    }

    static enum Tense {
        p,
        i,
        f,
        s,
        c,
        _x;

    }

    static enum Person {
        first,
        second,
        third,
        _x;

    }

    static enum Case {
        n,
        a,
        d,
        o,
        _x;

    }

    static enum OwnerNumber {
        s,
        p,
        _x;

    }

    static enum Politeness {
        p,
        _x;

    }

    static enum Form {
        s,
        c,
        _x;

    }

    static enum Closing {
        a,
        t,
        _x;

    }

    static enum NounDegree {
        d,
        a,
        _x;

    }
}

