/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema.sdoc;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.ModelGroup;
import com.saxonica.ee.schema.ModelGroupDefinition;
import com.saxonica.ee.schema.ModelGroupParticle;
import com.saxonica.ee.schema.Particle;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SingleNamespaceSchema;
import com.saxonica.ee.schema.sdoc.SchemaElement;
import com.saxonica.ee.schema.sdoc.XSDCompositor;
import com.saxonica.ee.schema.sdoc.XSDRedefine;
import java.util.List;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.Err;
import net.sf.saxon.transpile.CSharp;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaException;

public class XSDGroup
extends SchemaElement {
    private ModelGroupDefinition groupDeclaration = null;
    private ModelGroupParticle modelGroupParticle = null;
    private boolean foundMinOccurs = false;
    private boolean foundMaxOccurs = false;
    private boolean isRedefinition;

    @Override
    protected void prepareAttributes() throws SchemaException {
        int maxOccurs;
        String attValue;
        String[] allowed;
        SingleNamespaceSchema schema = this.getSchema();
        this.isRedefinition = this.getParent() instanceof XSDRedefine;
        AttributeMap atts = this.attributes();
        if (this.isTopLevel()) {
            this.groupDeclaration = new ModelGroupDefinition((EnterpriseConfiguration)this.getConfiguration(), this);
            this.groupDeclaration.setSchemaDocumentURI(this.getParent().getSystemId());
            allowed = new String[]{"id", "name"};
            this.allowAttributes(atts, allowed);
            this.requireAttribute(atts, "name");
        } else {
            this.modelGroupParticle = new ModelGroupParticle((EnterpriseConfiguration)this.getConfiguration(), this);
            schema.addComponent(this.modelGroupParticle);
            allowed = new String[]{"id", "maxOccurs", "minOccurs", "ref"};
            this.allowAttributes(atts, allowed);
            this.requireAttribute(atts, "ref");
        }
        String name = atts.getValue(NamespaceUri.NULL, "name");
        if (this.groupDeclaration != null) {
            if (name != null) {
                StructuredQName qName;
                try {
                    qName = this.getComponentName(name, 1);
                }
                catch (SchemaException err) {
                    this.error(err.getMessage());
                    qName = StandardNames.SQ_XS_INVALID_NAME;
                }
                this.groupDeclaration.setModelGroupName(qName);
            } else if (name == null) {
                this.groupDeclaration.setModelGroupName(StandardNames.SQ_XS_INVALID_NAME);
            }
        }
        if ((attValue = atts.getValue(NamespaceUri.NULL, "maxOccurs")) != null && this.modelGroupParticle != null) {
            this.foundMaxOccurs = true;
            if (this.groupDeclaration != null) {
                this.mutuallyExclusiveAttributes("name", "maxOccurs");
            } else {
                int max = this.processMaxOccurs(attValue);
                this.modelGroupParticle.setMaxOccurs(max);
            }
        }
        if ((attValue = atts.getValue(NamespaceUri.NULL, "minOccurs")) != null && this.modelGroupParticle != null) {
            this.foundMinOccurs = true;
            if (this.groupDeclaration != null) {
                this.mutuallyExclusiveAttributes("name", "minOccurs");
            } else {
                int minOccurs = this.processMinOccurs(attValue);
                this.modelGroupParticle.setMinOccurs(minOccurs);
            }
        }
        if (this.modelGroupParticle != null && (maxOccurs = this.modelGroupParticle.getMaxOccurs()) != -1 && this.modelGroupParticle.getMinOccurs() > maxOccurs) {
            this.error("maxOccurs must not be less than minOccurs");
        }
        if ((attValue = atts.getValue(NamespaceUri.NULL, "ref")) != null && this.modelGroupParticle != null) {
            if (this.groupDeclaration != null) {
                this.mutuallyExclusiveAttributes("name", "ref");
            } else {
                StructuredQName fp;
                try {
                    fp = this.getComponentName(attValue, 0);
                }
                catch (SchemaException err) {
                    this.error(err.getMessage());
                    return;
                }
                this.modelGroupParticle.setTargetComponentName(fp);
            }
        }
        this.processId();
    }

    public ModelGroupDefinition getGroupDeclaration() {
        return this.groupDeclaration;
    }

    public ModelGroupParticle getGroupReference() {
        return this.modelGroupParticle;
    }

    @Override
    public void validate(SchemaCompiler compiler) throws SchemaException {
        boolean foundAnnotation = false;
        NodeInfo foundCompositor = null;
        block5: for (NodeInfo nodeInfo : this.children()) {
            int fp = nodeInfo.getFingerprint();
            switch (fp) {
                case 578: {
                    if (foundAnnotation) {
                        this.duplicateElement("annotation");
                    }
                    if (foundCompositor != null) {
                        this.mustBeFirstElement("annotation");
                    }
                    foundAnnotation = true;
                    continue block5;
                }
                case 576: {
                    if (this.foundMinOccurs) {
                        this.mutuallyExclusiveElementAndAttribute("all", "minOccurs");
                    }
                    if (this.foundMaxOccurs) {
                        this.mutuallyExclusiveElementAndAttribute("all", "maxOccurs");
                    }
                    CSharp.emitCode("goto case Saxon.Hej.om.StandardNames.XS_SEQUENCE;");
                }
                case 586: 
                case 619: {
                    if (foundCompositor != null) {
                        this.mutuallyExclusive(nodeInfo.getDisplayName(), foundCompositor.getDisplayName());
                    }
                    if (this.modelGroupParticle != null) {
                        this.mutuallyExclusiveElementAndAttribute(nodeInfo.getDisplayName(), "ref");
                    }
                    foundCompositor = nodeInfo;
                    continue block5;
                }
            }
            this.illegalElement(nodeInfo);
        }
    }

    @Override
    public void postValidate(SchemaCompiler compiler) throws SchemaException {
        if (this.groupDeclaration == null) {
            return;
        }
        for (NodeInfo nodeInfo : this.children()) {
            int fp = nodeInfo.getFingerprint();
            switch (fp) {
                case 576: 
                case 586: 
                case 619: {
                    ModelGroupParticle compositor = ((XSDCompositor)nodeInfo).getModelGroupParticle();
                    this.groupDeclaration.addParticle(compositor);
                }
            }
        }
        if (this.isRedefinition) {
            SingleNamespaceSchema externalSchema = ((XSDRedefine)this.getParent()).getExternalSchema();
            SingleNamespaceSchema singleNamespaceSchema = ((XSDRedefine)this.getParent()).getRedefinedSchema();
            if (externalSchema == null || singleNamespaceSchema == null) {
                return;
            }
            ModelGroupDefinition originalGroup = externalSchema.getGroup(this.groupDeclaration.getModelGroupName());
            if (originalGroup == null) {
                this.error("Group " + Err.wrap(this.groupDeclaration.getName()) + " is not defined in the schema being redefined");
                return;
            }
            if (!((XSDRedefine)this.getParent()).getExternalSchemaDocumentURI().equals(originalGroup.getSchemaDocumentURI())) {
                compiler.warning("The redefined model group was found, but not in the schema document referenced by the schemaLocation attribute of the containing <xs:redefine> element. This is not allowed by the XSD specification. However, Saxon does not currently enforce this rule.", "SXSD1016", this);
            }
            this.groupDeclaration.setRedefinitionLevel(originalGroup.getRedefinitionLevel() + 1);
            boolean found = this.patchUpSelfReferences(this.groupDeclaration.getParticles(), this.groupDeclaration.getModelGroupName(), originalGroup, false);
            if (!found) {
                this.groupDeclaration.setRedefinedModelGroupDefinition(originalGroup);
            }
            singleNamespaceSchema.addGroup(this.groupDeclaration);
        }
    }

    private boolean patchUpSelfReferences(List<Particle> particles, StructuredQName qName, ModelGroupDefinition originalGroup, boolean found) throws SchemaException {
        SingleNamespaceSchema redefinedSchema = ((XSDRedefine)this.getParent()).getRedefinedSchema();
        boolean f = found;
        for (Particle p : particles) {
            ModelGroup group;
            if (p instanceof ModelGroupParticle && qName.equals(p.getTargetComponentName())) {
                if (f) {
                    this.error("Redefined group " + Err.wrap(this.groupDeclaration.getName()) + " contains more than one reference to itself");
                }
                f = true;
                ModelGroupParticle gref = (ModelGroupParticle)p;
                if (gref.getMinOccurs() != 1) {
                    this.error("Redefined group " + Err.wrap(this.groupDeclaration.getName()) + " must have minOccurs=1");
                }
                if (gref.getMaxOccurs() != 1) {
                    this.error("Redefined group " + Err.wrap(this.groupDeclaration.getName()) + " must have maxOccurs=1");
                }
                NamespaceUri uri = this.getXSDSchema().getTargetNamespace();
                String localName = gref.getTargetComponentName().getLocalPart();
                String newLocalName = localName + '_' + gref.hashCode();
                StructuredQName newNameCode = new StructuredQName("", uri, newLocalName);
                gref.setTargetComponentName(newNameCode);
                originalGroup.setModelGroupName(newNameCode);
                redefinedSchema.addGroup(originalGroup);
                continue;
            }
            if (!(p instanceof ModelGroupParticle)) continue;
            try {
                group = ((ModelGroupParticle)p).getGroup();
            }
            catch (MissingComponentException e) {
                continue;
            }
            f = this.patchUpSelfReferences(group.getParticles(), qName, originalGroup, f);
        }
        return f;
    }
}

