/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.watch;

import com.saxonica.ee.stream.Inversion;
import com.saxonica.ee.stream.feed.DecomposingFeed;
import com.saxonica.ee.stream.om.FleetingNode;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.AbstractWatch;
import com.saxonica.ee.stream.watch.Trigger;
import com.saxonica.ee.stream.watch.WatchManager;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ManualIterator;
import net.sf.saxon.type.UType;

public class StreamWatch
extends AbstractWatch {
    private final Inversion action;
    private final WatchManager watchManager;
    private final XPathContext context;

    public StreamWatch(Inversion action, WatchManager watchManager, XPathContext context) {
        this.action = action;
        this.watchManager = watchManager;
        this.context = context;
    }

    @Override
    public boolean matchesNode(FleetingNode node, XPathContext context) throws XPathException {
        return node.getNodeKind() == 9;
    }

    @Override
    public boolean matchesNodesOfKind(UType kind) {
        return kind.subsumes(UType.DOCUMENT);
    }

    @Override
    public void setAnchorNode(FleetingParentNode anchor) {
    }

    @Override
    public FleetingParentNode getAnchorNode() {
        return null;
    }

    @Override
    public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
        Inversion inversion = this.action;
        ManualIterator iter = new ManualIterator(node);
        this.context.setCurrentIterator(iter);
        DecomposingFeed parentFeed = new DecomposingFeed(this.watchManager.getOutputter(), this.context);
        Trigger watch = inversion.getWatch(this.watchManager, parentFeed, this.context);
        watch.setAnchorNode(node);
        this.watchManager.addWatch(watch, true);
        return null;
    }

    @Override
    public void endSelectedParentNode(Location locationId) throws XPathException {
    }
}

