/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query.spans;

import de.ids_mannheim.korap.query.SpanSubspanQuery;
import de.ids_mannheim.korap.query.spans.CandidateSpan;
import de.ids_mannheim.korap.query.spans.CandidateSpanComparator;
import de.ids_mannheim.korap.query.spans.SimpleSpans;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.PriorityQueue;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.util.Bits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubSpans
extends SimpleSpans {
    private final Logger log = LoggerFactory.getLogger(SubSpans.class);
    public static final boolean DEBUG = false;
    private int startOffset;
    private int length;
    private int windowSize;
    private int currentDoc;
    private int prevStart;
    private int prevDoc;
    private PriorityQueue<CandidateSpan> candidates;
    private CandidateSpanComparator comparator;

    public SubSpans(SpanSubspanQuery subspanQuery, LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts) throws IOException {
        super(subspanQuery, context, acceptDocs, termContexts);
        this.startOffset = subspanQuery.getStartOffset();
        this.length = subspanQuery.getLength();
        this.matchPayload = new ArrayList(6);
        this.windowSize = subspanQuery.getWindowSize();
        this.candidates = new PriorityQueue<CandidateSpan>(this.windowSize, this.comparator);
        this.hasMoreSpans = this.firstSpans.next();
    }

    @Override
    public boolean next() throws IOException {
        this.isStartEnumeration = false;
        return this.advance();
    }

    private boolean advance() throws IOException {
        while (this.hasMoreSpans || this.candidates.size() > 0) {
            CandidateSpan cs = new CandidateSpan(this.firstSpans);
            if (this.startOffset > 0) {
                if (this.findMatch(cs)) {
                    this.setMatch(cs);
                    this.hasMoreSpans = this.firstSpans.next();
                    return true;
                }
                this.hasMoreSpans = this.firstSpans.next();
                continue;
            }
            if (this.candidates.isEmpty()) {
                this.currentDoc = this.firstSpans.doc();
                this.collectCandidates();
                continue;
            }
            this.setMatch(this.candidates.poll());
            this.collectCandidates();
            return true;
        }
        return false;
    }

    private void collectCandidates() throws IOException {
        while (this.hasMoreSpans && this.candidates.size() < this.windowSize && this.firstSpans.doc() == this.currentDoc) {
            CandidateSpan cs = new CandidateSpan(this.firstSpans);
            if (this.findMatch(cs) && (cs.getDoc() != this.prevDoc || cs.getStart() >= this.prevStart)) {
                this.candidates.add(cs);
            }
            this.hasMoreSpans = this.firstSpans.next();
        }
    }

    public boolean findMatch(CandidateSpan cs) throws IOException {
        if (this.startOffset < 0) {
            cs.setStart(this.firstSpans.end() + this.startOffset);
            if (cs.getStart() < this.firstSpans.start()) {
                cs.setStart(this.firstSpans.start());
            }
        } else {
            cs.setStart(this.firstSpans.start() + this.startOffset);
            if (cs.getStart() >= this.firstSpans.end()) {
                return false;
            }
        }
        if (this.length > 0) {
            cs.setEnd(cs.getStart() + this.length);
            if (cs.getEnd() > this.firstSpans.end()) {
                cs.setEnd(this.firstSpans.end());
            }
        } else {
            cs.setEnd(this.firstSpans.end());
        }
        cs.getPayloads().clear();
        for (byte[] payload : this.firstSpans.getPayload()) {
            if ((payload[0] & 0x40) != 0) continue;
            cs.getPayloads().add((byte[])payload.clone());
        }
        cs.setDoc(this.firstSpans.doc());
        return true;
    }

    private void setMatch(CandidateSpan cs) {
        this.prevStart = this.matchStartPosition = cs.getStart();
        this.matchEndPosition = cs.getEnd();
        this.prevDoc = this.matchDocNumber = cs.getDoc();
        this.matchPayload.clear();
        this.matchPayload.addAll(cs.getPayloads());
    }

    @Override
    public boolean skipTo(int target) throws IOException {
        if (this.candidates.size() > 0) {
            CandidateSpan cs;
            while ((cs = this.candidates.poll()) != null) {
                if (cs.getDoc() != target) continue;
                return this.next();
            }
        }
        if (this.firstSpans.doc() == target) {
            return this.next();
        }
        if (this.firstSpans.doc() < target && this.firstSpans.skipTo(target)) {
            return this.next();
        }
        return this.advance();
    }

    @Override
    public long cost() {
        return this.firstSpans.cost() + 1L;
    }
}

