/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.extfn.js;

import com.saxonica.ee.extfn.js.IXSLFunctionSet;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.ma.arrays.SquareArrayConstructor;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;

public class JSFunctionLibrary
implements FunctionLibrary {
    @Override
    public boolean isAvailable(SymbolicName.F functionName, int languageLevel) {
        return NamespaceUri.GLOBAL_JS.equals(functionName.getComponentName().getNamespaceUri());
    }

    @Override
    public Expression bind(SymbolicName.F functionName, Expression[] staticArgs, Map<StructuredQName, Integer> keywords, StaticContext env, List<String> reasons) {
        StructuredQName fName = functionName.getComponentName();
        if (NamespaceUri.GLOBAL_JS.equals(fName.getNamespaceUri())) {
            if (keywords != null && !keywords.isEmpty()) {
                reasons.add("Calls to external Javascript functions cannot use keyword arguments");
                return null;
            }
            try {
                Expression windowCall = IXSLFunctionSet.getInstance().makeFunction("window", 0).makeFunctionCall(new Expression[0]);
                Expression callCall = IXSLFunctionSet.getInstance().makeFunction("call", 3).makeFunctionCall(windowCall, new StringLiteral(fName.getLocalPart()), new SquareArrayConstructor(Arrays.asList(staticArgs)));
                callCall.setRetainedStaticContext(env.makeRetainedStaticContext());
                return callCall;
            }
            catch (XPathException e) {
                reasons.add(e.getMessage());
                return null;
            }
        }
        return null;
    }

    @Override
    public FunctionLibrary copy() {
        return this;
    }

    @Override
    public FunctionItem getFunctionItem(SymbolicName.F functionName, StaticContext staticContext) throws XPathException {
        return null;
    }
}

