/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema.sdoc;

import com.saxonica.ee.schema.ElementWildcard;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.sdoc.AnnotationParent;
import com.saxonica.ee.schema.sdoc.XSDDefaultOpenContent;
import com.saxonica.ee.schema.sdoc.XSDOpenContent;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.type.SchemaException;

public class XSDAny
extends AnnotationParent {
    private ElementWildcard wildcard = null;

    @Override
    protected void prepareAttributes() throws SchemaException {
        int maxOccurs;
        String[] allowed;
        this.wildcard = new ElementWildcard(this.getSchema().getConfiguration());
        this.wildcard.setLocator(this);
        AttributeMap atts = this.attributes();
        if (this.getParent() instanceof XSDDefaultOpenContent || this.getParent() instanceof XSDOpenContent) {
            allowed = new String[]{"id", "namespace", "notNamespace", "notQName", "processContents"};
            this.allowAttributes(atts, allowed);
        } else {
            allowed = new String[]{"id", "maxOccurs", "minOccurs", "namespace", "notNamespace", "notQName", "processContents"};
            this.allowAttributes(atts, allowed);
        }
        this.checkMutuallyExclusiveAttributes("namespace", "notNamespace");
        String attValue = atts.getValue(NamespaceUri.NULL, "namespace");
        if (attValue != null) {
            this.processAllowedNamespaces(attValue, this.wildcard.getWildcard());
        }
        if ((attValue = atts.getValue(NamespaceUri.NULL, "notNamespace")) != null) {
            this.processDisallowedNamespaces(attValue, this.wildcard.getWildcard());
        }
        if ((attValue = atts.getValue(NamespaceUri.NULL, "notQName")) != null) {
            this.processDisallowedQNames(attValue, this.wildcard.getWildcard());
        }
        if ((attValue = atts.getValue(NamespaceUri.NULL, "maxOccurs")) != null) {
            int max = this.processMaxOccurs(attValue);
            this.wildcard.setMaxOccurs(max);
        }
        if ((attValue = atts.getValue(NamespaceUri.NULL, "minOccurs")) != null) {
            int minOccurs = this.processMinOccurs(attValue);
            this.wildcard.setMinOccurs(minOccurs);
        }
        if ((maxOccurs = this.wildcard.getMaxOccurs()) != -1 && this.wildcard.getMinOccurs() > maxOccurs) {
            this.error("maxOccurs must not be less than minOccurs");
        }
        if ((attValue = atts.getValue(NamespaceUri.NULL, "processContents")) != null) {
            if (XSDAny.isProcessName(attValue)) {
                this.wildcard.getWildcard().setProcessContents(attValue);
            } else {
                this.invalidAttributeValue("processContents", attValue, null);
            }
        }
        this.processId();
    }

    @Override
    public void validate(SchemaCompiler compiler) throws SchemaException {
        super.validate(compiler);
        if (this.getAttributeValue(NamespaceUri.NULL, "notNamespace") != null && compiler.getLanguageVersion() != 11) {
            this.error("The notNamespace attribute requires XSD 1.1 to be enabled");
        }
        if (this.getAttributeValue(NamespaceUri.NULL, "notQName") != null && compiler.getLanguageVersion() != 11) {
            this.error("The notQName attribute requires XSD 1.1 to be enabled");
        }
    }

    public ElementWildcard getElementWildcard() {
        return this.wildcard;
    }

    protected static boolean isProcessName(String name) {
        return "lax".equals(name) || "skip".equals(name) || "strict".equals(name);
    }
}

