/*
 * Decompiled with CFR 0.152.
 */
package marmot.morph.mapper.latin;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import marmot.morph.mapper.latin.LatMorNormalizer;
import marmot.morph.mapper.latin.LdtMorphTag;
import marmot.util.FileUtils;
import marmot.util.LineIterator;

public class LatMorReader {
    Map<String, Map<String, Set<LdtMorphTag>>> dict_;

    public LatMorReader() {
        this.dict_ = new HashMap<String, Map<String, Set<LdtMorphTag>>>();
    }

    public LatMorReader(Map<String, Map<String, Set<LdtMorphTag>>> dict) {
        this.dict_ = dict;
    }

    public void readLatMorFile(String filename) throws IOException {
        BufferedReader reader = FileUtils.openFile(filename);
        String line = null;
        while (reader.ready()) {
            if (line == null) {
                line = reader.readLine().trim();
            }
            if (line.isEmpty()) continue;
            assert (line.startsWith("> "));
            String form = LatMorNormalizer.normalize(line.substring(2));
            Map<String, Set<LdtMorphTag>> readings = this.dict_.get(form);
            boolean insert = false;
            if (readings == null) {
                insert = true;
                readings = new HashMap<String, Set<LdtMorphTag>>();
            }
            line = this.readReadings(reader, readings);
            if (!insert || readings.isEmpty()) continue;
            this.dict_.put(form, readings);
        }
        reader.close();
    }

    public void readMissingFile(String filename) throws IOException {
        LineIterator iterator2 = new LineIterator(filename);
        while (iterator2.hasNext()) {
            Object line = iterator2.next();
            if (line.size() <= 2) continue;
            String form = LatMorNormalizer.normalize((String)line.get(0));
            HashSet<LdtMorphTag> tags = new HashSet<LdtMorphTag>();
            for (String tag_string : line.subList(2, line.size())) {
                LdtMorphTag tag = new LdtMorphTag();
                switch (tag_string) {
                    case "aj": {
                        tag.pos_ = LdtMorphTag.Pos.a;
                        break;
                    }
                    case "su": {
                        tag.pos_ = LdtMorphTag.Pos.n;
                        break;
                    }
                    case "np": {
                        tag.pos_ = LdtMorphTag.Pos.n;
                        break;
                    }
                    case "pn": {
                        tag.pos_ = LdtMorphTag.Pos.p;
                        break;
                    }
                    case "nu": {
                        tag.pos_ = LdtMorphTag.Pos.m;
                        break;
                    }
                    default: {
                        System.err.println("Unknown tag: " + tag_string);
                    }
                }
                if (tag.pos_ == LdtMorphTag.Pos.Undef) continue;
                tags.add(tag);
            }
            if (tags.size() <= 0) continue;
            Map readings = this.dict_.computeIfAbsent(form, k -> new HashMap());
            readings.put("_", tags);
        }
    }

    public String readReadings(BufferedReader reader, Map<String, Set<LdtMorphTag>> readings) throws IOException {
        String line = null;
        while (reader.ready() && !(line = reader.readLine().trim()).startsWith(">")) {
            if (line.startsWith("no result for ")) continue;
            this.parseReading(line, readings);
        }
        return line;
    }

    public void parseReading(String line, Map<String, Set<LdtMorphTag>> readings) {
        int morph_start = line.indexOf(60);
        if (morph_start < 0) {
            throw new RuntimeException("Invalid reading: " + line);
        }
        String lemma = LatMorNormalizer.normalize(line.substring(0, morph_start).replace("-", ""));
        String morph_tag_string = line.substring(morph_start);
        Set set = readings.computeIfAbsent(lemma, k -> new HashSet());
        set.add(this.parseMorpTagString(morph_tag_string));
    }

    public LdtMorphTag parseMorpTagString(String morph_tag_string) {
        String[] features;
        LdtMorphTag tag = new LdtMorphTag();
        for (String feature : features = morph_tag_string.split("[<>]")) {
            if (feature.isEmpty()) continue;
            LatMorReader.setFeature(tag, feature);
        }
        this.postProcess(tag);
        return tag;
    }

    public void postProcess(LdtMorphTag tag) {
        if (tag.pos_ == LdtMorphTag.Pos.p) {
            tag.person_ = LdtMorphTag.Person.Undef;
        }
        if (tag.pos_ == LdtMorphTag.Pos.r) {
            tag.case_ = LdtMorphTag.Case.Undef;
        }
    }

    public static void setFeature(LdtMorphTag tag, String feature) {
        switch (feature) {
            case "N": 
            case "PN": {
                tag.pos_ = LdtMorphTag.Pos.n;
                break;
            }
            case "V": {
                tag.pos_ = LdtMorphTag.Pos.v;
                if (tag.mood_ != LdtMorphTag.Mood.p) break;
                tag.pos_ = LdtMorphTag.Pos.t;
                break;
            }
            case "ADJ": {
                tag.pos_ = LdtMorphTag.Pos.a;
                break;
            }
            case "PREP": {
                tag.pos_ = LdtMorphTag.Pos.r;
                break;
            }
            case "ADV": {
                tag.pos_ = LdtMorphTag.Pos.d;
                break;
            }
            case "CONJ": {
                tag.pos_ = LdtMorphTag.Pos.c;
                break;
            }
            case "PRO": {
                tag.pos_ = LdtMorphTag.Pos.p;
                break;
            }
            case "NUM": {
                tag.pos_ = LdtMorphTag.Pos.m;
                break;
            }
            case "1": {
                tag.person_ = LdtMorphTag.Person.first;
                break;
            }
            case "2": {
                tag.person_ = LdtMorphTag.Person.second;
                break;
            }
            case "3": {
                tag.person_ = LdtMorphTag.Person.third;
                break;
            }
            case "sg": {
                tag.number_ = LdtMorphTag.Number.s;
                break;
            }
            case "pl": {
                tag.number_ = LdtMorphTag.Number.p;
                break;
            }
            case "pres": {
                tag.tense_ = LdtMorphTag.Tense.p;
                break;
            }
            case "imperf": {
                tag.tense_ = LdtMorphTag.Tense.i;
                break;
            }
            case "perf": {
                tag.tense_ = LdtMorphTag.Tense.r;
                break;
            }
            case "pqperf": {
                tag.tense_ = LdtMorphTag.Tense.l;
                break;
            }
            case "futureII": {
                tag.tense_ = LdtMorphTag.Tense.t;
                break;
            }
            case "future": 
            case "futureI": {
                tag.tense_ = LdtMorphTag.Tense.f;
                break;
            }
            case "ind": {
                tag.mood_ = LdtMorphTag.Mood.i;
                break;
            }
            case "cond": {
                tag.mood_ = LdtMorphTag.Mood.s;
            }
            case "inf": {
                tag.mood_ = LdtMorphTag.Mood.n;
                break;
            }
            case "imp": {
                tag.mood_ = LdtMorphTag.Mood.m;
                break;
            }
            case "part": {
                tag.mood_ = LdtMorphTag.Mood.p;
                if (tag.pos_ != LdtMorphTag.Pos.v) break;
                tag.pos_ = LdtMorphTag.Pos.t;
                break;
            }
            case "gerund": {
                tag.mood_ = LdtMorphTag.Mood.d;
                break;
            }
            case "gerundivum": {
                tag.mood_ = LdtMorphTag.Mood.g;
                break;
            }
            case "supinI": 
            case "supinII": {
                tag.mood_ = LdtMorphTag.Mood.u;
                break;
            }
            case "active": {
                tag.voice_ = LdtMorphTag.Voice.a;
                break;
            }
            case "passive": 
            case "deponens": {
                tag.voice_ = LdtMorphTag.Voice.p;
                break;
            }
            case "masc": {
                tag.gender_ = LdtMorphTag.Gender.m;
                break;
            }
            case "fem": {
                tag.gender_ = LdtMorphTag.Gender.f;
                break;
            }
            case "neut": {
                tag.gender_ = LdtMorphTag.Gender.n;
                break;
            }
            case "nom": {
                tag.case_ = LdtMorphTag.Case.n;
                break;
            }
            case "gen": {
                tag.case_ = LdtMorphTag.Case.g;
                break;
            }
            case "dat": {
                tag.case_ = LdtMorphTag.Case.d;
                break;
            }
            case "acc": {
                tag.case_ = LdtMorphTag.Case.a;
                break;
            }
            case "abl": {
                tag.case_ = LdtMorphTag.Case.b;
                break;
            }
            case "voc": {
                tag.case_ = LdtMorphTag.Case.v;
                break;
            }
            case "superlative": {
                tag.degree_ = LdtMorphTag.Degree.s;
                break;
            }
            case "comparative": {
                tag.degree_ = LdtMorphTag.Degree.c;
                break;
            }
            case "INTJ": {
                tag.pos_ = LdtMorphTag.Pos.i;
            }
            case "subj": 
            case "positive": 
            case "conj": 
            case "alt": 
            case "coord": 
            case "dem": 
            case "indef": 
            case "subord": 
            case "dist": 
            case "card": 
            case "rel": 
            case "quest": 
            case "ord": 
            case "poss": 
            case "refl": 
            case "pers": 
            case "dig": 
            case "adj": {
                break;
            }
            default: {
                throw new RuntimeException("Unknown feature: " + feature);
            }
        }
    }

    Set<LdtMorphTag.Pos> getPosCandidates(String form, String lemma) {
        Map<String, Set<LdtMorphTag>> lemmas = this.dict_.get(form);
        HashSet<LdtMorphTag.Pos> tags = new HashSet<LdtMorphTag.Pos>();
        if (lemmas != null) {
            Set<Object> ldt_tags;
            if (lemma != null) {
                ldt_tags = lemmas.get(lemma);
            } else {
                ldt_tags = new HashSet();
                for (Set set : lemmas.values()) {
                    ldt_tags.addAll(set);
                }
            }
            if (ldt_tags != null) {
                for (LdtMorphTag ldtMorphTag : ldt_tags) {
                    tags.add(ldtMorphTag.pos_);
                }
            }
        }
        return tags;
    }

    public void readWrongFile(String filename) {
        LineIterator iterator2 = new LineIterator(filename);
        while (iterator2.hasNext()) {
            Object line = iterator2.next();
            if (line.size() <= 3) continue;
            String form = LatMorNormalizer.normalize((String)line.get(1));
            HashSet<LdtMorphTag> tags = new HashSet<LdtMorphTag>();
            for (String tag_string : line.subList(3, line.size())) {
                LdtMorphTag tag = new LdtMorphTag();
                switch (tag_string) {
                    case "a": {
                        tag.pos_ = LdtMorphTag.Pos.a;
                        break;
                    }
                    case "n": {
                        tag.pos_ = LdtMorphTag.Pos.n;
                        break;
                    }
                    case "p": {
                        tag.pos_ = LdtMorphTag.Pos.p;
                        break;
                    }
                    default: {
                        System.err.println("Unknown tag: " + tag_string);
                    }
                }
                if (tag.pos_ == LdtMorphTag.Pos.Undef) continue;
                tags.add(tag);
            }
            if (tags.size() <= 0) continue;
            Map readings = this.dict_.computeIfAbsent(form, k -> new HashMap());
            readings.put((String)line.get(2), tags);
        }
    }

    public Set<String> getLemmas(String form) {
        Map<String, Set<LdtMorphTag>> lemmas = this.dict_.get(form);
        if (lemmas == null) {
            return null;
        }
        return lemmas.keySet();
    }
}

