/*
 * Decompiled with CFR 0.152.
 */
package lemming.lemma.toutanova;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import lemming.lemma.toutanova.Decoder;
import lemming.lemma.toutanova.Result;
import lemming.lemma.toutanova.ToutanovaInstance;
import lemming.lemma.toutanova.ToutanovaModel;

public class FirstOrderDecoder
implements Decoder {
    private ToutanovaModel model_;
    private double[] score_array_;
    private int[] output_array_;
    private int[] index_array_;
    private int num_output_symbols_;
    private int input_length_;
    private ToutanovaInstance instance_;

    @Override
    public void init(ToutanovaModel model) {
        this.model_ = model;
        this.num_output_symbols_ = this.model_.getOutputTable().size();
    }

    @Override
    public Result decode(ToutanovaInstance instance) {
        int max_input_segment_length = this.model_.getMaxInputSegmentLength();
        this.input_length_ = instance.getFormCharIndexes().length;
        this.instance_ = instance;
        this.checkArraySize(this.num_output_symbols_ * this.input_length_);
        Arrays.fill(this.score_array_, Double.NEGATIVE_INFINITY);
        Arrays.fill(this.output_array_, -1);
        Arrays.fill(this.index_array_, -1);
        for (int l = 1; l < this.input_length_ + 1; ++l) {
            for (int o = 0; o < this.num_output_symbols_; ++o) {
                double best_score = Double.NEGATIVE_INFINITY;
                int best_output = -1;
                int best_index = -1;
                for (int l_start = Math.max(0, l - max_input_segment_length); l_start < l; ++l_start) {
                    double pair_score = this.model_.getPairScore(instance, l_start, l, o);
                    if (l_start == 0) {
                        double score = pair_score;
                        if (!(score > best_score)) continue;
                        best_score = score;
                        best_output = -1;
                        best_index = l_start;
                        continue;
                    }
                    for (int last_o = 0; last_o < this.num_output_symbols_; ++last_o) {
                        double prev_cost = this.score_array_[this.getIndex(last_o, l_start - 1)];
                        double transiton_score = this.model_.getTransitionScore(instance, last_o, o, l_start, l);
                        double score = pair_score + transiton_score + prev_cost;
                        if (!(score > best_score)) continue;
                        best_score = score;
                        best_output = last_o;
                        best_index = l_start;
                    }
                }
                this.score_array_[this.getIndex((int)o, (int)(l - 1))] = best_score;
                this.output_array_[this.getIndex((int)o, (int)(l - 1))] = best_output;
                this.index_array_[this.getIndex((int)o, (int)(l - 1))] = best_index;
            }
        }
        Result result2 = this.backTrace();
        return result2;
    }

    private Result backTrace() {
        LinkedList<Integer> outputs = new LinkedList<Integer>();
        LinkedList<Integer> inputs = new LinkedList<Integer>();
        int end_index = this.input_length_;
        double best_score = Double.NEGATIVE_INFINITY;
        int end_output = -1;
        for (int o = 0; o < this.num_output_symbols_; ++o) {
            double score = this.score_array_[this.getIndex(o, end_index - 1)];
            if (!(score > best_score)) continue;
            best_score = score;
            end_output = o;
        }
        outputs.add(end_output);
        inputs.add(end_index);
        while (true) {
            int start_index = this.index_array_[this.getIndex(end_output, end_index - 1)];
            int start_output = this.output_array_[this.getIndex(end_output, end_index - 1)];
            if (start_output < 0) break;
            outputs.add(start_output);
            inputs.add(start_index);
            end_output = start_output;
            end_index = start_index;
        }
        Collections.reverse(outputs);
        Collections.reverse(inputs);
        return new Result(this.model_, outputs, inputs, this.instance_.getInstance().getForm(), best_score);
    }

    private int getIndex(int output, int index) {
        return output * this.input_length_ + index;
    }

    private void checkArraySize(int required_length) {
        if (this.score_array_ == null || this.score_array_.length < required_length) {
            this.score_array_ = new double[required_length];
            this.output_array_ = new int[this.score_array_.length];
            this.index_array_ = new int[this.score_array_.length];
        }
    }

    @Override
    public int getOrder() {
        return 1;
    }
}

