/*
 * Decompiled with CFR 0.152.
 */
package marmot.morph;

import java.util.Arrays;
import java.util.List;
import lemming.lemma.ranker.RankerInstance;
import marmot.core.FeatureVector;
import marmot.core.Token;

public class Word
implements Token {
    private static final long serialVersionUID = 1L;
    private String word_;
    private String tag_;
    private String morph_;
    private String[] token_features_;
    private String lemma_;
    private int word_index_;
    private short[] char_indexes_;
    private int word_shape_index_;
    private int[] tag_indexes_;
    private int signature_;
    private int[] token_feature_indexes_;
    private FeatureVector vector_;
    private String[] weighted_token_features_;
    private double[] weighted_token_feature_weights_;
    private int[] weighted_token_feature_indexes_;
    private List<RankerInstance> instances_;

    public Word(String word, String lemma, String tag, String morph, String[] token_features, String[] weighted_token_features, double[] weighted_token_feature_weights) {
        this.word_ = word;
        this.lemma_ = lemma;
        this.tag_ = tag;
        this.morph_ = morph;
        this.token_features_ = token_features;
        this.weighted_token_features_ = weighted_token_features;
        this.weighted_token_feature_weights_ = weighted_token_feature_weights;
        this.word_index_ = -1;
        this.word_shape_index_ = -1;
        this.signature_ = -1;
    }

    public Word(String word, String tag, String morph, String[] token_features, String[] weighted_token_features, double[] weighted_token_feature_weights) {
        this(word, null, tag, morph, token_features, weighted_token_features, weighted_token_feature_weights);
    }

    public Word(String word, String tag, String morph) {
        this(word, tag, morph, null, null, null);
    }

    public Word(String word, String tag) {
        this(word, tag, null);
    }

    public Word(String word) {
        this(word, null);
    }

    public String getWordForm() {
        return this.word_;
    }

    public String getPosTag() {
        return this.tag_;
    }

    public void setPosTag(String tag) {
        this.tag_ = tag;
    }

    public String toString() {
        return this.word_ + " " + this.tag_ + " " + this.morph_ + " " + Arrays.toString(this.token_features_);
    }

    public void setWordIndex(int word_index) {
        this.word_index_ = word_index;
    }

    @Override
    public int[] getTagIndexes() {
        return this.tag_indexes_;
    }

    public int getWordFormIndex() {
        return this.word_index_;
    }

    public void setCharIndexes(short[] char_indexes) {
        this.char_indexes_ = char_indexes;
    }

    public short[] getCharIndexes() {
        return this.char_indexes_;
    }

    public void setWordShapeIndex(int shape_index) {
        this.word_shape_index_ = shape_index;
    }

    public int getWordShapeIndex() {
        return this.word_shape_index_;
    }

    public String getMorphTag() {
        return this.morph_;
    }

    public void setTagIndexes(int[] tag_indexes) {
        this.tag_indexes_ = tag_indexes;
    }

    public int getWordSignature() {
        return this.signature_;
    }

    public void setWordSignature(int signature) {
        this.signature_ = signature;
    }

    public String[] getTokenFeatures() {
        return this.token_features_;
    }

    public void setTokenFeatureIndexes(int[] token_feature_indexes) {
        this.token_feature_indexes_ = token_feature_indexes;
    }

    public int[] getTokenFeatureIndexes() {
        return this.token_feature_indexes_;
    }

    public void setMorphTag(String morph) {
        this.morph_ = morph;
    }

    @Override
    public void setVector(FeatureVector vector) {
        this.vector_ = vector;
    }

    @Override
    public FeatureVector getVector() {
        return this.vector_;
    }

    public Word shallowCopy() {
        Word word = new Word(this.word_, this.tag_, this.morph_, this.token_features_, this.weighted_token_features_, this.weighted_token_feature_weights_);
        word.word_index_ = this.word_index_;
        word.char_indexes_ = this.char_indexes_;
        word.word_shape_index_ = this.word_shape_index_;
        word.tag_indexes_ = this.tag_indexes_;
        word.signature_ = this.signature_;
        word.token_feature_indexes_ = this.token_feature_indexes_;
        word.vector_ = this.vector_;
        word.weighted_token_feature_indexes_ = this.token_feature_indexes_;
        return word;
    }

    public void setWordForm(String word) {
        this.word_ = word;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + Arrays.hashCode(this.char_indexes_);
        result2 = 31 * result2 + (this.morph_ == null ? 0 : this.morph_.hashCode());
        result2 = 31 * result2 + this.signature_;
        result2 = 31 * result2 + (this.tag_ == null ? 0 : this.tag_.hashCode());
        result2 = 31 * result2 + Arrays.hashCode(this.tag_indexes_);
        result2 = 31 * result2 + Arrays.hashCode(this.token_feature_indexes_);
        result2 = 31 * result2 + Arrays.hashCode(this.token_features_);
        result2 = 31 * result2 + (this.vector_ == null ? 0 : this.vector_.hashCode());
        result2 = 31 * result2 + (this.word_ == null ? 0 : this.word_.hashCode());
        result2 = 31 * result2 + this.word_index_;
        result2 = 31 * result2 + this.word_shape_index_;
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Word other = (Word)obj;
        if (!Arrays.equals(this.char_indexes_, other.char_indexes_)) {
            return false;
        }
        if (this.morph_ == null ? other.morph_ != null : !this.morph_.equals(other.morph_)) {
            return false;
        }
        if (this.signature_ != other.signature_) {
            return false;
        }
        if (this.tag_ == null ? other.tag_ != null : !this.tag_.equals(other.tag_)) {
            return false;
        }
        if (!Arrays.equals(this.tag_indexes_, other.tag_indexes_)) {
            return false;
        }
        if (!Arrays.equals(this.token_feature_indexes_, other.token_feature_indexes_)) {
            return false;
        }
        if (!Arrays.equals(this.token_features_, other.token_features_)) {
            return false;
        }
        if (this.vector_ == null ? other.vector_ != null : !this.vector_.equals(other.vector_)) {
            return false;
        }
        if (this.word_ == null ? other.word_ != null : !this.word_.equals(other.word_)) {
            return false;
        }
        if (this.word_index_ != other.word_index_) {
            return false;
        }
        return this.word_shape_index_ == other.word_shape_index_;
    }

    public void setWeightedTokenFeatureIndexes(int[] indexes) {
        this.weighted_token_feature_indexes_ = indexes;
    }

    public String[] getWeightedTokenFeatures() {
        return this.weighted_token_features_;
    }

    public int[] getWeightedTokenFeatureIndexes() {
        return this.weighted_token_feature_indexes_;
    }

    public double[] getWeightedTokenFeatureWeights() {
        return this.weighted_token_feature_weights_;
    }

    public void setTokenFeatures(String[] token_features) {
        this.token_features_ = token_features;
    }

    public String getLemma() {
        return this.lemma_;
    }

    public List<RankerInstance> getRankerIstances() {
        return this.instances_;
    }

    public void setRankerIstances(List<RankerInstance> instances) {
        this.instances_ = instances;
    }
}

