/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.update;

import com.saxonica.ee.update.PendingUpdateAction;
import java.util.Set;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.MutableNodeInfo;
import net.sf.saxon.om.NodeInfo;

public class InsertAction
extends PendingUpdateAction {
    private NodeInfo[] content;
    private MutableNodeInfo targetNode;
    private int position;
    private boolean inheritNamespaces;

    public InsertAction(NodeInfo[] content, MutableNodeInfo targetNode, int position, boolean inherit) {
        this.content = content;
        this.targetNode = targetNode;
        this.position = position;
        this.inheritNamespaces = inherit;
    }

    @Override
    public void apply(XPathContext context, Set affectedRootSet) {
        boolean affectsType = false;
        for (NodeInfo node : this.content) {
            int kind = node.getNodeKind();
            if (kind != 1 && kind != 3) continue;
            affectsType = true;
            break;
        }
        switch (this.position) {
            case 116: {
                this.targetNode.insertChildren(this.content, true, this.inheritNamespaces);
                if (!affectsType) break;
                this.targetNode.removeTypeAnnotation();
                break;
            }
            case 117: 
            case 120: {
                this.targetNode.insertChildren(this.content, false, this.inheritNamespaces);
                if (!affectsType) break;
                this.targetNode.removeTypeAnnotation();
                break;
            }
            case 119: {
                this.targetNode.insertSiblings(this.content, true, this.inheritNamespaces);
                if (!affectsType) break;
                ((MutableNodeInfo)this.targetNode.getParent()).removeTypeAnnotation();
                break;
            }
            case 118: {
                this.targetNode.insertSiblings(this.content, false, this.inheritNamespaces);
                if (!affectsType) break;
                ((MutableNodeInfo)this.targetNode.getParent()).removeTypeAnnotation();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown insert position " + this.position);
            }
        }
        affectedRootSet.add(this.targetNode.getRoot());
    }

    @Override
    public NodeInfo getTargetNode() {
        return this.targetNode;
    }

    @Override
    public int getApplyPhase() {
        return this.position == 120 ? 1 : 2;
    }
}

