/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToItemCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.OnEmpty;
import com.saxonica.objectweb.asm.Type;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.functions.Count;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;

public class CountCompiler
extends ToItemCompiler {
    @Override
    public void compileToPrimitive(CompilerService compiler, Expression expression, Class requiredClass, OnEmpty onEmpty) throws CannotCompileException {
        SystemFunctionCall fnc = (SystemFunctionCall)expression;
        Expression arg = fnc.getArg(0);
        Generator ga = compiler.getCurrentGenerator();
        CountCompiler.visitAnnotation(compiler, "count");
        CountCompiler.visitLineNumber(compiler, ga, expression);
        if (requiredClass != Integer.TYPE && requiredClass != Long.TYPE) {
            throw new IllegalArgumentException();
        }
        if (arg instanceof Literal || arg instanceof VariableReference) {
            compiler.compileToSequence(arg);
            ga.invokeStaticMethod(SequenceTool.class, "getLength", Sequence.class);
        } else {
            compiler.compileToIterator(arg);
            ga.invokeStaticMethod(Count.class, "count", SequenceIterator.class);
        }
        if (requiredClass == Long.TYPE) {
            ga.cast(Type.INT_TYPE, Type.LONG_TYPE);
        }
    }

    @Override
    public void compileToItem(CompilerService compiler, Expression expression) throws CannotCompileException {
        this.compileItemFromInt(compiler, expression);
    }

    public static boolean maybeLastPositionFinder(Expression expression) {
        return !(expression instanceof AxisExpression) && !(expression instanceof FilterExpression) && !(expression instanceof SlashExpression) && !(expression instanceof Atomizer) && !(expression instanceof ItemChecker) && !(expression instanceof CardinalityChecker);
    }
}

