/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.watch;

import com.saxonica.ee.stream.Inversion;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.StreamingSequenceWriter;
import com.saxonica.ee.stream.Sweep;
import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.feed.NoOpenOrCloseFeed;
import com.saxonica.ee.stream.om.FleetingDocumentNode;
import com.saxonica.ee.stream.om.FleetingNode;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.Trigger;
import com.saxonica.ee.stream.watch.WatchManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.SequenceWriter;
import net.sf.saxon.expr.ContextSwitchingExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ManualIterator;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;

public class ForEachAction
extends ItemFeed {
    protected XPathContext bodyContext;
    private WatchManager watchManager;
    private Stack<Activation> activationStack = new Stack();
    private List<Sequence<?>> valuesAwaitingOutput = new ArrayList(5);
    private Expression action;
    private Inversion inversion;
    private boolean actionIsConsuming;
    private SequenceWriter sequenceWriter;

    public ForEachAction(WatchManager watchManager, Expression expression, Feed result, XPathContext context) {
        super(expression, result, context);
        this.watchManager = watchManager;
        this.action = ((ContextSwitchingExpression)((Object)expression)).getActionExpression();
        this.actionIsConsuming = Streamability.getSweep(this.action) == Sweep.CONSUMING;
    }

    public void setInversion(Inversion inversion) {
        this.inversion = inversion;
    }

    protected Inversion getInversion() {
        return this.inversion;
    }

    protected WatchManager getWatchManager() {
        return this.watchManager;
    }

    protected Expression getAction() {
        return this.action;
    }

    protected boolean isActionConsuming() {
        return this.actionIsConsuming;
    }

    protected XPathContext getBodyContext() {
        return this.bodyContext;
    }

    protected Stack<Activation> getActivationStack() {
        return this.activationStack;
    }

    protected List<Sequence<?>> getValuesAwaitingOutput() {
        return this.valuesAwaitingOutput;
    }

    @Override
    public SequenceReceiver getReceiver() {
        if (this.sequenceWriter == null) {
            this.sequenceWriter = new StreamingSequenceWriter(this.getPipelineConfiguration(), this);
        }
        return this.sequenceWriter;
    }

    @Override
    public void open(Terminator terminator) throws XPathException {
        super.open(terminator);
        this.makeBodyContext();
    }

    protected void makeBodyContext() {
        this.bodyContext = this.getContext().newMinorContext();
        ManualIterator iter = new ManualIterator();
        this.bodyContext.setCurrentIterator(iter);
    }

    @Override
    public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
        if (this.actionIsConsuming) {
            Activation activation = this.startSelectedNode(node);
            NoOpenOrCloseFeed thisFeed = new NoOpenOrCloseFeed(this.getResult(), activation.context);
            Trigger watch = this.inversion.getWatch(this.watchManager, thisFeed, activation.context);
            watch.setAnchorNode(node);
            this.watchManager.addWatch(watch, true);
            return null;
        }
        ManualIterator iter = (ManualIterator)this.bodyContext.getCurrentIterator();
        iter.setContextItem(node);
        iter.incrementPosition();
        SequenceIterator<?> stepIter = this.action.iterate(this.bodyContext);
        ForEachAction.processItems(stepIter, this.getResult());
        return null;
    }

    private Activation startSelectedNode(FleetingNode node) throws XPathException {
        XPathContext context;
        ManualIterator iter = (ManualIterator)this.bodyContext.getCurrentIterator();
        iter.setContextItem(node);
        iter.incrementPosition();
        if (this.activationStack.isEmpty()) {
            context = this.bodyContext;
        } else {
            context = this.bodyContext.newMinorContext();
            SequenceOutputter out = new SequenceOutputter(this.getPipelineConfiguration());
            context.setReceiver(out);
            this.valuesAwaitingOutput.add(StringValue.EMPTY_STRING);
        }
        Activation activation = new Activation(this.valuesAwaitingOutput.size() - 1);
        activation.context = context;
        activation.isDocumentNode = node instanceof FleetingDocumentNode;
        this.activationStack.push(activation);
        return activation;
    }

    @Override
    public void processItem(Item<?> it) throws XPathException {
        if (this.actionIsConsuming && it instanceof FleetingParentNode) {
            XPathContext cxt = this.activationStack.isEmpty() ? this.bodyContext : this.activationStack.peek().context;
            NoOpenOrCloseFeed thisFeed = new NoOpenOrCloseFeed(this.getResult(), cxt);
            Trigger watch = this.inversion.getWatch(this.watchManager, thisFeed, cxt);
            if (watch.matchesNode((FleetingParentNode)it, cxt)) {
                this.startSelectedNode((FleetingNode)it);
                watch.open(Terminator.getInstance());
                watch.processItem(it);
                watch.close();
                this.endSelectedParentNode(ExplicitLocation.UNKNOWN_LOCATION);
            } else {
                watch.open(Terminator.getInstance());
                this.getWatchManager().addWatch(watch, true);
            }
        } else {
            XPathContext context = this.bodyContext;
            ManualIterator iterator = (ManualIterator)context.getCurrentIterator();
            iterator.setContextItem(it);
            iterator.incrementPosition();
            Feed parentFeed = this.getResult();
            this.action.iterate(context).forEachOrFail(parentFeed::processItem);
        }
    }

    @Override
    public void endSelectedParentNode(Location locationId) throws XPathException {
        if (this.actionIsConsuming) {
            Activation activation = this.activationStack.pop();
            XPathContext context = activation.context;
            if (this.activationStack.isEmpty()) {
                for (Sequence<?> aValuesAwaitingOutput : this.valuesAwaitingOutput) {
                    SequenceIterator<?> iter = aValuesAwaitingOutput.iterate();
                    ForEachAction.processItems(iter, this.getResult());
                }
                this.valuesAwaitingOutput.clear();
            } else {
                SequenceOutputter temp = (SequenceOutputter)context.getReceiver();
                int seq = activation.sequence;
                GroundedValue<Item<?>> root = SequenceExtent.makeSequenceExtent(temp.getList());
                temp.close();
                this.valuesAwaitingOutput.set(seq, root);
            }
        }
    }

    @Override
    public void close() throws XPathException {
        super.close();
    }

    protected static class Activation {
        public int sequence;
        public boolean isDocumentNode;
        public XPathContext context;
        public boolean matches;

        public Activation(int sequence) {
            this.sequence = sequence;
        }
    }
}

