/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.validate;

import com.saxonica.ee.schema.ElementDecl;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.IntPredicate;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.SchemaNodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.NodeVectorTree;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.z.IntHashMap;
import net.sf.saxon.z.IntSet;
import net.sf.saxon.z.IntSetPredicate;

public class SchemaElementTest
extends NodeTest
implements SchemaNodeTest {
    private ElementDecl head;
    private IntHashMap<ElementDecl> groupByFingerprint;
    private HashMap<NodeName, ElementDecl> groupByName;
    private SchemaType requiredType;

    public SchemaElementTest(ElementDecl element) throws MissingComponentException {
        this.head = element;
        Collection<ElementDecl> subsGroup = element.getSubstitutionGroupMembers();
        this.groupByFingerprint = new IntHashMap(subsGroup.size());
        this.groupByName = new HashMap(subsGroup.size());
        for (ElementDecl decl : subsGroup) {
            if (decl.isAbstract()) continue;
            this.groupByFingerprint.put(decl.getFingerprint(), decl);
            this.groupByName.put(new FingerprintedQName("", decl.getTargetNamespace(), decl.getName()), decl);
        }
        this.requiredType = element.getType();
    }

    public ElementDecl getElementDeclaration() {
        return this.head;
    }

    @Override
    public UType getUType() {
        return UType.ELEMENT;
    }

    @Override
    public boolean matches(int nodeKind, NodeName name, SchemaType annotation) {
        if (nodeKind != 1) {
            return false;
        }
        try {
            TypeHierarchy th = this.head.getConfiguration().getTypeHierarchy();
            if (name.hasFingerprint()) {
                ElementDecl decl = this.groupByFingerprint.get(name.getFingerprint() & 0xFFFFF);
                return decl != null && SchemaElementTest.matchesAnnotation(decl.getType(), annotation, th);
            }
            ElementDecl decl = this.groupByName.get(name);
            return decl != null && SchemaElementTest.matchesAnnotation(decl.getType(), annotation, th);
        }
        catch (MissingComponentException e) {
            return false;
        }
    }

    @Override
    public IntPredicate getMatcher(NodeVectorTree tree) {
        if (!tree.isTyped()) {
            return IntSetPredicate.ALWAYS_FALSE;
        }
        byte[] nodeKindArray = tree.getNodeKindArray();
        int[] nameCodeArray = tree.getNameCodeArray();
        return nodeNr -> {
            if ((nodeKindArray[nodeNr] & 0xF) != 1) {
                return false;
            }
            ElementDecl decl = this.groupByFingerprint.get(nameCodeArray[nodeNr] & 0xFFFFF);
            try {
                return decl != null && (!((TinyTree)tree).isNilled(nodeNr) || decl.isNillable()) && SchemaElementTest.matchesAnnotation(decl.getType(), ((TinyTree)tree).getSchemaType(nodeNr), decl.getConfiguration().getTypeHierarchy());
            }
            catch (MissingComponentException e) {
                return false;
            }
        };
    }

    @Override
    public boolean matchesNode(NodeInfo node) {
        if (node.getNodeKind() != 1) {
            return false;
        }
        ElementDecl decl = this.groupByName.get(NameOfNode.makeName(node));
        try {
            return decl != null && (!node.isNilled() || decl.isNillable()) && SchemaElementTest.matchesAnnotation(decl.getType(), node.getSchemaType(), decl.getConfiguration().getTypeHierarchy());
        }
        catch (MissingComponentException e) {
            return false;
        }
    }

    public static boolean matchesAnnotation(SchemaType required, SchemaType actual, TypeHierarchy th) {
        int requiredType = required.getFingerprint();
        if (requiredType == 572) {
            return true;
        }
        if (AnyType.getInstance().equals(required)) {
            return true;
        }
        int rel = th.schemaTypeRelationship(required, actual);
        return rel == 0 || rel == 1;
    }

    @Override
    public final double getDefaultPriority() {
        return 0.0;
    }

    @Override
    public int getPrimitiveType() {
        return 1;
    }

    @Override
    public Optional<IntSet> getRequiredNodeNames() {
        return Optional.of(this.groupByFingerprint.keySet());
    }

    @Override
    public SchemaType getContentType() {
        return this.requiredType;
    }

    @Override
    public boolean isNillable() {
        return this.head.isNillable();
    }

    public boolean isNillable(int fingerprint) {
        ElementDecl decl = this.groupByFingerprint.get(fingerprint);
        return decl == null ? this.isNillable() : decl.isNillable();
    }

    public int getHeadFingerprint() {
        return this.head.getFingerprint();
    }

    @Override
    public String toString() {
        return "schema-element(" + this.head.getComponentName().getEQName() + ')';
    }

    public int hashCode() {
        return this.head.getFingerprint();
    }

    public boolean equals(Object other) {
        return other instanceof SchemaElementTest && ((SchemaElementTest)other).head == this.head;
    }

    @Override
    public String generateJavaScriptItemTypeTest(ItemType knownToBe, int targetVersion) throws XPathException {
        throw new XPathException("Cannot generate JS code for a SchemaElementTest", "SXJS0001");
    }

    @Override
    public Optional<String> explainMismatch(Item item, TypeHierarchy th) {
        Optional<String> explanation = super.explainMismatch(item, th);
        if (explanation.isPresent()) {
            return explanation;
        }
        NodeInfo node = (NodeInfo)item;
        NodeName name = NameOfNode.makeName(node);
        try {
            ElementDecl decl = this.groupByName.get(name);
            if (decl == null) {
                return Optional.of("The supplied element is not in the substitution group of element " + this.head.getDisplayName());
            }
            if (!SchemaElementTest.matchesAnnotation(decl.getType(), node.getSchemaType(), th)) {
                if (node.getSchemaType() == Untyped.getInstance()) {
                    return Optional.of("The supplied element has not been schema-validated");
                }
                return Optional.of("The type annotation of the supplied element (" + decl.getType().getDescription() + ") does not match the type for the global element declaration in the schema");
            }
        }
        catch (MissingComponentException e) {
            return Optional.empty();
        }
        return Optional.empty();
    }
}

