/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.validate;

import com.saxonica.ee.validate.ConstraintChecker;
import com.saxonica.ee.validate.ContentValidator;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.Untyped;

public class SkipValidator
extends ContentValidator {
    boolean stripIdProperty = false;
    TypeHierarchy typeHierarchy;

    public SkipValidator(Receiver next) {
        super(next);
    }

    @Override
    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        super.setPipelineConfiguration(pipe);
        this.stripIdProperty = pipe.getHostLanguage() == 51;
        this.typeHierarchy = pipe.getConfiguration().getTypeHierarchy();
    }

    @Override
    public SchemaType getSchemaType() {
        return null;
    }

    @Override
    protected ConstraintChecker getConstraintChecker() {
        return null;
    }

    @Override
    public void startElement(NodeName nameCode, SchemaType typeCode, Location location, int properties) throws XPathException {
        if (!this.stripIdProperty && typeCode != Untyped.getInstance() && (properties & 0x2000) == 0) {
            if (typeCode.isIdType()) {
                properties |= 0x800;
            } else if (typeCode.isIdRefType()) {
                properties |= 0x1000;
            }
            properties |= 0x2000;
        }
        super.startElement(nameCode, Untyped.getInstance(), location, properties &= 0xFFFFFFEF);
    }

    @Override
    protected ContentValidator getChildValidator() {
        return this;
    }

    @Override
    public void attribute(NodeName nameCode, SimpleType type, CharSequence value, Location locationId, int properties) throws XPathException {
        if (!this.stripIdProperty && (properties & 0x2000) == 0) {
            if (type.isIdType()) {
                properties |= 0x800;
            } else if (type.isIdRefType()) {
                properties |= 0x1000;
            }
            properties |= 0x2000;
        }
        if (this.stripIdProperty) {
            properties &= 0xFFFFE7FF;
            properties |= 0x2000;
        }
        this.nextReceiver.attribute(nameCode, BuiltInAtomicType.UNTYPED_ATOMIC, value, locationId, properties);
    }

    @Override
    public void append(Item item, Location locationId, int copyNamespaces) throws XPathException {
        if (item instanceof NodeInfo) {
            this.decompose(item, locationId, copyNamespaces);
        } else {
            this.nextReceiver.append(item, locationId, copyNamespaces);
        }
    }
}

