/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query.spans;

import de.ids_mannheim.korap.query.SpanMultipleDistanceQuery;
import de.ids_mannheim.korap.query.spans.CandidateSpan;
import de.ids_mannheim.korap.query.spans.DistanceSpans;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.Bits;

public class MultipleDistanceSpans
extends DistanceSpans {
    private DistanceSpans x;
    private DistanceSpans y;
    private boolean isOrdered;

    public MultipleDistanceSpans(SpanMultipleDistanceQuery query, LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts, Spans firstSpans, Spans secondSpans, boolean isOrdered, boolean exclusion) throws IOException {
        super(query, context, acceptDocs, termContexts);
        this.isOrdered = isOrdered;
        this.exclusion = exclusion;
        this.x = (DistanceSpans)firstSpans;
        this.y = (DistanceSpans)secondSpans;
        this.hasMoreSpans = this.x.next() && this.y.next();
    }

    @Override
    public boolean next() throws IOException {
        this.isStartEnumeration = false;
        this.matchPayload.clear();
        return this.advance();
    }

    @Override
    protected boolean advance() throws IOException {
        while (this.hasMoreSpans && this.ensureSameDoc(this.x, this.y)) {
            if (this.findMatch()) {
                this.moveForward();
                return true;
            }
            this.moveForward();
        }
        return false;
    }

    private void moveForward() throws IOException {
        this.hasMoreSpans = this.isOrdered ? (this.x.end() < this.y.end() || this.x.end() == this.y.end() && this.x.start() < this.y.start() ? this.x.next() : this.y.next()) : (this.x.start() < this.y.start() || this.x.start() == this.y.start() && this.x.end() < this.y.end() ? this.x.next() : this.y.next());
    }

    protected boolean findMatch() throws IOException {
        CandidateSpan xf = this.x.getMatchFirstSpan();
        CandidateSpan xs = this.x.getMatchSecondSpan();
        CandidateSpan yf = this.y.getMatchFirstSpan();
        CandidateSpan ys = this.y.getMatchSecondSpan();
        if (this.x.isExclusion() || this.y.isExclusion()) {
            if (xf.getStart() == yf.getStart() && xf.getEnd() == yf.getEnd()) {
                if (this.x.isExclusion() && this.y.isExclusion()) {
                    this.setMatchProperties(this.x, true);
                } else if (this.x.isExclusion()) {
                    this.setMatchProperties(this.y, true);
                } else {
                    this.setMatchProperties(this.x, true);
                }
                return true;
            }
        } else if (xf.getStart() == yf.getStart() && xf.getEnd() == yf.getEnd() && xs.getStart() == ys.getStart() && xs.getEnd() == ys.getEnd()) {
            this.setMatchProperties(this.x, false);
            return true;
        }
        return false;
    }

    private void setMatchProperties(DistanceSpans span, boolean exclusion) {
        this.matchStartPosition = span.start();
        this.matchEndPosition = span.end();
        this.matchDocNumber = span.doc();
        this.matchPayload = span.matchPayload;
        this.setMatchFirstSpan(span.getMatchFirstSpan());
        if (!exclusion) {
            this.setMatchSecondSpan(span.getMatchSecondSpan());
        }
    }

    @Override
    public boolean skipTo(int target) throws IOException {
        if (this.hasMoreSpans && this.y.doc() < target && !this.y.skipTo(target)) {
            return false;
        }
        this.matchPayload.clear();
        this.isStartEnumeration = false;
        return this.advance();
    }

    @Override
    public long cost() {
        return this.x.cost() + this.y.cost();
    }
}

