/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.watch;

import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.ForEachAction;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.WatchManager;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.TailCallLoop;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.BreakInstr;
import net.sf.saxon.expr.instruct.IterateInstr;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.QuitParsingException;
import net.sf.saxon.trans.XPathException;

public class IterateAction
extends ForEachAction {
    boolean broken = false;
    Terminator terminator;

    public IterateAction(WatchManager watchManager, Expression expression, Feed result, XPathContext context) {
        super(watchManager, expression, result, context);
    }

    @Override
    public void open(Terminator terminator) throws XPathException {
        super.open(terminator);
        this.terminator = terminator;
        XPathContext outerContext = this.getContext();
        ((IterateInstr)this.getExpression()).getInitiallyExp().process(outerContext);
        this.makeBodyContext();
    }

    @Override
    public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
        if (this.broken) {
            return null;
        }
        return super.startSelectedParentNode(node, locationId);
    }

    @Override
    public void processItem(Item<?> it) throws XPathException {
        if (this.broken) {
            return;
        }
        super.processItem(it);
        this.checkForBreakInstruction();
    }

    @Override
    public void endSelectedParentNode(Location locationId) throws XPathException {
        if (this.broken) {
            return;
        }
        super.endSelectedParentNode(locationId);
        this.checkForBreakInstruction();
    }

    private void checkForBreakInstruction() throws QuitParsingException {
        XPathContext c = this.getContext();
        while (!(c instanceof XPathContextMajor)) {
            c = c.getCaller();
        }
        XPathContextMajor cm = (XPathContextMajor)c;
        TailCallLoop.TailCallInfo tail = cm.getTailCallInfo();
        if (tail != null && tail instanceof BreakInstr) {
            this.broken = true;
            this.terminator.terminate();
        }
    }

    @Override
    public void close() throws XPathException {
        if (!this.broken) {
            Expression onCompletion = ((IterateInstr)this.getExpression()).getOnCompletion();
            SequenceIterator<?> iter = onCompletion.iterate(this.getContext());
            IterateAction.processItems(iter, this.getResult());
        }
        this.broken = false;
        super.close();
    }
}

