/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query;

import de.ids_mannheim.korap.query.SimpleSpanQuery;
import de.ids_mannheim.korap.query.SpanRelationQuery;
import de.ids_mannheim.korap.query.spans.SegmentSpans;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.ToStringUtils;

public class SpanSegmentQuery
extends SimpleSpanQuery {
    private boolean isRelation;

    public SpanSegmentQuery(SpanQuery firstClause, SpanQuery secondClause) {
        this(firstClause, secondClause, true);
    }

    public SpanSegmentQuery(SpanQuery firstClause, SpanQuery secondClause, boolean collectPayloads) {
        super(firstClause, secondClause, collectPayloads);
        if (firstClause instanceof SpanRelationQuery) {
            this.isRelation = true;
        }
    }

    @Override
    public Spans getSpans(LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts) throws IOException {
        return new SegmentSpans(this, context, acceptDocs, termContexts);
    }

    @Override
    public SpanSegmentQuery clone() {
        SpanSegmentQuery spanSegmentQuery = new SpanSegmentQuery((SpanQuery)this.firstClause.clone(), (SpanQuery)this.secondClause.clone(), this.collectPayloads);
        spanSegmentQuery.setBoost(this.getBoost());
        return spanSegmentQuery;
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("spanSegment(");
        sb.append(this.firstClause.toString(field));
        sb.append(", ");
        sb.append(this.secondClause.toString(field));
        sb.append(")");
        sb.append(ToStringUtils.boost(this.getBoost()));
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpanSegmentQuery)) {
            return false;
        }
        SpanSegmentQuery spanSegmentQuery = (SpanSegmentQuery)o;
        if (this.collectPayloads != spanSegmentQuery.collectPayloads) {
            return false;
        }
        if (!this.firstClause.equals(spanSegmentQuery.firstClause)) {
            return false;
        }
        if (!this.secondClause.equals(spanSegmentQuery.secondClause)) {
            return false;
        }
        return this.getBoost() == spanSegmentQuery.getBoost();
    }

    @Override
    public int hashCode() {
        int result = this.firstClause.hashCode() + this.secondClause.hashCode();
        result ^= 31 * result + (result >>> 3);
        return result += Float.floatToRawIntBits(this.getBoost());
    }

    public boolean isRelation() {
        return this.isRelation;
    }

    public void setRelation(boolean isRelation) {
        this.isRelation = isRelation;
    }
}

