/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.trans;

import com.saxonica.ee.trans.Characteristic;
import com.saxonica.ee.trans.ModeEE;
import com.saxonica.ee.trans.RuleEE;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.rules.Rule;
import net.sf.saxon.trans.rules.RuleChain;
import net.sf.saxon.trans.rules.RuleSearchState;

public class PreconditionMatcher
extends RuleSearchState {
    private final XPathContext context;
    private int[] preconditionState;
    private Object[] characteristics;

    public PreconditionMatcher(RuleChain chain, XPathContext context) {
        this.context = context;
        if (chain.hasOptimizationData()) {
            ModeEE.RuleChainOptimizationData data = (ModeEE.RuleChainOptimizationData)chain.optimizationData;
            this.preconditionState = new int[data.preconditions.size()];
            this.characteristics = new Object[data.characteristics.size()];
        }
    }

    public int getPreconditionState(int slot) {
        return this.preconditionState[slot];
    }

    public void setPreconditionState(int slot, boolean value) {
        this.preconditionState[slot] = value ? 1 : -1;
    }

    @Override
    public boolean checkPreconditions(Rule rule) throws XPathException {
        return ((RuleEE)rule).checkPreconditions(this);
    }

    public Object obtainCharacteristic(Characteristic chic) throws XPathException {
        Object val = this.characteristics[chic.getSlotNumber()];
        if (val == null) {
            this.characteristics[chic.getSlotNumber()] = val = chic.evaluate(this.context);
        }
        return val;
    }
}

