/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SchemaModelSerializer;
import com.saxonica.ee.schema.SchemaStructure;
import com.saxonica.ee.schema.SerializableSchemaComponent;
import com.saxonica.ee.schema.UserSchemaComponent;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.CallableDelegate;
import net.sf.saxon.functions.CallableFunction;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaValidationStatus;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.StringValue;

public class Notation
extends SchemaStructure
implements UserSchemaComponent,
SerializableSchemaComponent {
    private String notationSystemId;
    private StructuredQName notationName;
    private String notationPublicId;

    public Notation(EnterpriseConfiguration config, SourceLocator locator) {
        this.setConfiguration(config);
        this.setLocator(locator);
    }

    public void setNotationName(StructuredQName nameCode) {
        this.notationName = nameCode;
    }

    public StructuredQName getNotationName() {
        return this.notationName;
    }

    public void setNotationSystemId(String systemId) {
        this.notationSystemId = systemId;
    }

    public void setNotationPublicId(String publicId) {
        this.notationPublicId = publicId;
    }

    public String getNotationSystemId() {
        return this.notationSystemId;
    }

    public String getNotationPublicId() {
        return this.notationPublicId;
    }

    public String getName() {
        return this.notationName.getLocalPart();
    }

    public NamespaceUri getTargetNamespace() {
        return this.notationName.getNamespaceUri();
    }

    @Override
    public boolean validate(SchemaCompiler compiler) {
        return true;
    }

    @Override
    public boolean fixup(SchemaCompiler compiler) {
        this.setFixupStatus(SchemaValidationStatus.VALIDATED);
        return true;
    }

    public boolean isSameDeclaration(Notation other) {
        return this == other || this.getNotationName().equals(other.getNotationName()) && this.hasSameLocation(other);
    }

    @Override
    public void elaborate(SchemaCompiler compiler) {
    }

    @Override
    public void serialize(SchemaModelSerializer serializer) throws XPathException {
        String id = serializer.getId(this, true);
        serializer.startElement("notation");
        serializer.emitAttribute("id", id);
        serializer.emitAttribute("name", this.getName());
        if (this.getTargetNamespace() != null && !this.getTargetNamespace().isEmpty()) {
            serializer.emitAttribute("targetNamespace", this.getTargetNamespace().toString());
        }
        if (this.notationPublicId != null) {
            serializer.emitAttribute("publicId", this.notationPublicId);
        }
        if (this.notationSystemId != null) {
            serializer.emitAttribute("systemId", this.notationSystemId);
        }
        serializer.endElement();
    }

    @Override
    public FunctionItem getComponentAsFunction() {
        Notation thisNotation = this;
        CallableDelegate callable = new CallableDelegate((context, arguments) -> {
            String key;
            switch (key = arguments[0].head().getStringValue()) {
                case "class": {
                    return StringValue.bmp("Notation Declaration");
                }
                case "implementation": {
                    return new ObjectValue<Notation>(thisNotation);
                }
                case "name": {
                    return new StringValue(this.getName(), (AtomicType)BuiltInAtomicType.NCNAME);
                }
                case "target namespace": {
                    return new AnyURIValue(this.getTargetNamespace().toUnicodeString());
                }
                case "system identifier": {
                    if (this.getNotationSystemId() == null) {
                        return EmptySequence.getInstance();
                    }
                    return new AnyURIValue(this.getNotationSystemId());
                }
                case "public identifier": {
                    if (this.getNotationPublicId() == null) {
                        return EmptySequence.getInstance();
                    }
                    return new AnyURIValue(this.getNotationSystemId());
                }
            }
            return EmptySequence.getInstance();
        });
        return new CallableFunction(1, (Callable)callable, SpecificFunctionType.COMPONENT_FUNCTION_TYPE);
    }
}

