/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToBooleanCompiler;
import com.saxonica.ee.bytecode.util.Callback;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.IntegerRangeTest;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.UntypedAtomicValue;

public class IntegerRangeTestCompiler
extends ToBooleanCompiler {
    @Override
    public void compileToBoolean(CompilerService compiler, Expression expression) throws CannotCompileException {
        IntegerRangeTest test = (IntegerRangeTest)expression;
        Expression valExp = test.getValue();
        Expression minExp = test.getMin();
        Expression maxExp = test.getMax();
        TypeHierarchy th = compiler.getConfiguration().getTypeHierarchy();
        boolean maybeUntypedAtomic = th.relationship(valExp.getItemType(), BuiltInAtomicType.UNTYPED_ATOMIC) != 4;
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        IntegerRangeTestCompiler.visitAnnotation(compiler, "IntegerRangeTestCompiler");
        IntegerRangeTestCompiler.visitLineNumber(compiler, ga, expression);
        LabelInfo done = methodInfo.newLabel("IRTdone");
        int valueVar = 0;
        valueVar = methodInfo.allocateLocal(NumericValue.class);
        compiler.compileToIterator(valExp);
        int iterVar = methodInfo.allocateLocal(SequenceIterator.class);
        ga.storeLocal(iterVar);
        LabelInfo intRangeLoop = methodInfo.newLabel("intRange_loop");
        LabelInfo falseLabel = methodInfo.newLabel("intRange_FalseLabel");
        compiler.compileToItem(minExp);
        int minVar = methodInfo.allocateLocal(IntegerValue.class);
        ga.checkClass(IntegerValue.class);
        if (Cardinality.allowsZero(minExp.getCardinality())) {
            ga.dup();
            ga.ifNull(falseLabel.label());
        }
        ga.storeLocal(minVar);
        compiler.compileToItem(maxExp);
        int maxVar = methodInfo.allocateLocal(IntegerValue.class);
        ga.checkClass(IntegerValue.class);
        if (Cardinality.allowsZero(maxExp.getCardinality())) {
            ga.dup();
            ga.ifNull(falseLabel.label());
        }
        ga.storeLocal(maxVar);
        Configuration config = compiler.getConfiguration();
        StringConverter toDouble = BuiltInAtomicType.DOUBLE.getStringConverter(config.getConversionRules());
        int toDoubleVar = methodInfo.allocateLocal(StringConverter.class);
        IntegerRangeTestCompiler.allocateStatic(compiler, toDouble);
        ga.storeLocal(toDoubleVar);
        methodInfo.placeLabel(intRangeLoop);
        ga.loadLocal(iterVar);
        ga.invokeInstanceMethod(SequenceIterator.class, "next", new Class[0]);
        ga.dup();
        ga.ifNull(falseLabel.label());
        ga.checkClass(AtomicValue.class);
        int atomicValueVar = methodInfo.allocateLocal(AtomicValue.class);
        ga.storeLocal(atomicValueVar);
        LabelInfo not_untypedAtomicValueLb = methodInfo.newLabel("untypedAtomicType_label");
        LabelInfo numericInstanceLb = methodInfo.newLabel("numericInstance_label");
        LabelInfo checkWholeNumber_lb = methodInfo.newLabel("checkWholeNumber_lb");
        if (maybeUntypedAtomic) {
            ga.loadLocal(atomicValueVar);
            ga.ifNotInstance(UntypedAtomicValue.class, not_untypedAtomicValueLb);
            this.untypedAtomicChecker(test, ga, methodInfo, valueVar, toDoubleVar, atomicValueVar, checkWholeNumber_lb);
            methodInfo.placeLabel(not_untypedAtomicValueLb);
        }
        ga.loadLocal(atomicValueVar);
        ga.ifInstance(NumericValue.class, numericInstanceLb);
        ga.push("Cannot compare value of type ");
        ga.loadLocal(atomicValueVar);
        ga.invokeInstanceMethod(AtomicValue.class, "getUType", new Class[0]);
        ga.invokeInstanceMethod(UType.class, "toString", new Class[0]);
        ga.push(" to xs:integer");
        ga.concatenateStrings(3);
        ga.push("XPTY0004");
        ga.push(test.getLocation().getSystemId());
        ga.push(test.getLocation().getLineNumber());
        ga.push(true);
        ga.invokeStaticMethod(Callback.class, "makeXPathException", String.class, String.class, String.class, Integer.TYPE, Boolean.TYPE);
        ga.throwException();
        methodInfo.placeLabel(numericInstanceLb);
        ga.loadLocal(atomicValueVar);
        ga.checkClass(NumericValue.class);
        ga.storeLocal(valueVar);
        methodInfo.placeLabel(checkWholeNumber_lb);
        if (!Type.isSubType((AtomicType)valExp.getItemType(), BuiltInAtomicType.INTEGER)) {
            ga.loadLocal(valueVar);
            ga.invokeInstanceMethod(NumericValue.class, "isWholeNumber", new Class[0]);
            ga.ifFalse(intRangeLoop);
        }
        ga.loadLocal(valueVar);
        ga.loadLocal(minVar);
        ga.invokeInstanceMethod(NumericValue.class, "compareTo", Object.class);
        LabelInfo geMin = methodInfo.newLabel("IRTgeMin");
        ga.ifZCmp(156, geMin.label());
        ga.goTo(intRangeLoop);
        methodInfo.placeLabel(geMin);
        ga.loadLocal(valueVar);
        compiler.compileToItem(maxExp);
        ga.invokeInstanceMethod(NumericValue.class, "compareTo", Object.class);
        LabelInfo leMax = methodInfo.newLabel("IRTleMax");
        ga.ifZCmp(158, leMax.label());
        ga.goTo(intRangeLoop);
        methodInfo.placeLabel(leMax);
        ga.push(true);
        ga.goTo(done);
        ga.goTo(intRangeLoop);
        methodInfo.placeLabel(falseLabel);
        ga.pop();
        ga.push(false);
        methodInfo.placeLabel(done);
        methodInfo.releaseLocal(valueVar);
        methodInfo.releaseLocal(toDoubleVar);
        methodInfo.releaseLocal(minVar);
        methodInfo.releaseLocal(maxVar);
        methodInfo.releaseLocal(toDoubleVar);
        methodInfo.releaseLocal(atomicValueVar);
    }

    private void untypedAtomicChecker(IntegerRangeTest test, Generator ga, GeneratedMethodInfo methodInfo, int valueVar, int toDoubleVar, int atomicValueVar, LabelInfo checkWholeNumber_lb) {
        ga.loadLocal(toDoubleVar);
        ga.loadLocal(atomicValueVar);
        ga.invokeInstanceMethod(AtomicValue.class, "getStringValueCS", new Class[0]);
        ga.invokeInstanceMethod(StringConverter.class, "convertString", CharSequence.class);
        ga.dup();
        LabelInfo notValidationFailure_lb = methodInfo.newLabel("notValidationFailure_label");
        ga.ifNotInstance(ValidationFailure.class, notValidationFailure_lb);
        ga.pop();
        ga.push("Failed to convert untypedAtomic value {");
        ga.loadLocal(atomicValueVar);
        ga.invokeInstanceMethod(AtomicValue.class, "getStringValueCS", new Class[0]);
        ga.checkClass(String.class);
        ga.push("}  to xs:integer");
        ga.concatenateStrings(3);
        ga.push("FORG0001");
        ga.push(test.getLocation().getSystemId());
        ga.push(test.getLocation().getLineNumber());
        ga.push(true);
        ga.invokeStaticMethod(Callback.class, "makeXPathException", String.class, String.class, String.class, Integer.TYPE, Boolean.TYPE);
        ga.throwException();
        methodInfo.placeLabel(notValidationFailure_lb);
        ga.checkClass(DoubleValue.class);
        ga.invokeInstanceMethod(AtomicValue.class, "asAtomic", new Class[0]);
        ga.checkClass(DoubleValue.class);
        ga.storeLocal(valueVar);
        ga.goTo(checkWholeNumber_lb);
    }
}

